/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Strings;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SvgTree {
    private static final Logger logger = Logger.getLogger(SvgTree.class.getSimpleName());
    public static final String SVG_WIDTH = "width";
    public static final String SVG_HEIGHT = "height";
    public static final String SVG_VIEW_BOX = "viewBox";
    private float w = -1.0f;
    private float h = -1.0f;
    private final AffineTransform mRootTransform = new AffineTransform();
    private float[] viewBox;
    private float mScaleFactor = 1.0f;
    private SvgGroupNode mRoot;
    private String mFileName;
    private ArrayList<String> mErrorLines = new ArrayList();
    private boolean mHasLeafNode = false;

    SvgTree() {
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public void setHasLeafNode(boolean hasLeafNode) {
        this.mHasLeafNode = hasLeafNode;
    }

    public float[] getViewBox() {
        return this.viewBox;
    }

    public void flatten() {
        this.mRoot.flatten(new AffineTransform());
    }

    public Document parse(File f) throws Exception {
        this.mFileName = f.getName();
        Document doc = PositionXmlParser.parse((InputStream)new FileInputStream(f), (boolean)false);
        return doc;
    }

    public void normalize() {
        this.mRootTransform.preConcatenate(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0], -this.viewBox[1]));
        this.transform(this.mRootTransform);
        logger.log(Level.FINE, "matrix=" + this.mRootTransform);
    }

    private void transform(AffineTransform rootTransform) {
        this.mRoot.transformIfNeeded(rootTransform);
    }

    public void dump(SvgGroupNode root) {
        logger.log(Level.FINE, "current file is :" + this.mFileName);
        root.dumpNode("");
    }

    public void setRoot(SvgGroupNode root) {
        this.mRoot = root;
    }

    public SvgGroupNode getRoot() {
        return this.mRoot;
    }

    public void logErrorLine(String s, Node node, SvgLogLevel level) {
        if (!Strings.isNullOrEmpty((String)s)) {
            if (node != null) {
                SourcePosition position = SvgTree.getPosition(node);
                this.mErrorLines.add(level.name() + "@ line " + (position.getStartLine() + 1) + " " + s + "\n");
            } else {
                this.mErrorLines.add(s);
            }
        }
    }

    public String getErrorLog() {
        StringBuilder errorBuilder = new StringBuilder();
        if (!this.mErrorLines.isEmpty()) {
            errorBuilder.append("In " + this.mFileName + ":\n");
        }
        for (String log : this.mErrorLines) {
            errorBuilder.append(log);
        }
        return errorBuilder.toString();
    }

    public boolean getHasLeafNode() {
        return this.mHasLeafNode;
    }

    private static SourcePosition getPosition(Node node) {
        return PositionXmlParser.getPosition((Node)node);
    }

    public float getViewportWidth() {
        return this.viewBox == null ? -1.0f : this.viewBox[2];
    }

    public float getViewportHeight() {
        return this.viewBox == null ? -1.0f : this.viewBox[3];
    }

    public void parseDimension(Node nNode) {
        NamedNodeMap a = nNode.getAttributes();
        int len = a.getLength();
        SizeType widthType = SizeType.PIXEL;
        SizeType heightType = SizeType.PIXEL;
        for (int i = 0; i < len; ++i) {
            Node n = a.item(i);
            String name = n.getNodeName().trim();
            String value = n.getNodeValue().trim();
            int subStringSize = value.length();
            SizeType currentType = SizeType.PIXEL;
            String unit = value.substring(Math.max(value.length() - 2, 0));
            if (unit.matches("em|ex|px|in|cm|mm|pt|pc")) {
                subStringSize -= 2;
            } else if (value.endsWith("%")) {
                --subStringSize;
                currentType = SizeType.PERCENTAGE;
            }
            if (SVG_WIDTH.equals(name)) {
                this.w = Float.parseFloat(value.substring(0, subStringSize));
                widthType = currentType;
                continue;
            }
            if (SVG_HEIGHT.equals(name)) {
                this.h = Float.parseFloat(value.substring(0, subStringSize));
                heightType = currentType;
                continue;
            }
            if (!SVG_VIEW_BOX.equals(name)) continue;
            this.viewBox = new float[4];
            String[] strbox = value.split(" ");
            for (int j = 0; j < this.viewBox.length; ++j) {
                this.viewBox[j] = Float.parseFloat(strbox[j]);
            }
        }
        if (this.viewBox == null && this.w > 0.0f && this.h > 0.0f) {
            this.viewBox = new float[4];
            this.viewBox[2] = this.w;
            this.viewBox[3] = this.h;
        } else if ((this.w < 0.0f || this.h < 0.0f) && this.viewBox != null) {
            this.w = this.viewBox[2];
            this.h = this.viewBox[3];
        }
        if (widthType == SizeType.PERCENTAGE && this.w > 0.0f) {
            this.w = this.viewBox[2] * this.w / 100.0f;
        }
        if (heightType == SizeType.PERCENTAGE && this.h > 0.0f) {
            this.h = this.viewBox[3] * this.h / 100.0f;
        }
    }

    private static enum SizeType {
        PIXEL,
        PERCENTAGE;

    }

    public static enum SvgLogLevel {
        ERROR,
        WARNING;

    }
}

