/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Collection;

public interface ApkInfo
extends Serializable {
    public VariantOutput.OutputType getType();

    public Collection<FilterData> getFilters();

    public int getVersionCode();

    public String getVersionName();

    public boolean isEnabled();

    public String getOutputFileName();

    public String getFilterName();

    public static ApkInfo of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode) {
        return ApkInfo.of(outputType, filters, versionCode, null, true, null);
    }

    public static ApkInfo of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode, String versionName, boolean enabled, String outputFileName) {
        return new DefaultApkInfo(outputType, filters, versionCode, versionName, outputFileName, enabled);
    }

    public static class DefaultApkInfo
    implements ApkInfo {
        private final VariantOutput.OutputType outputType;
        private final Collection<FilterData> filters;
        private final int versionCode;
        private final String versionName;
        private final String outputFileName;
        private final boolean enabled;

        public DefaultApkInfo(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode, String versionName, String outputFileName, boolean enabled) {
            this.outputType = outputType;
            this.filters = filters;
            this.versionCode = versionCode;
            this.versionName = versionName;
            this.outputFileName = outputFileName;
            this.enabled = enabled;
        }

        @Override
        public VariantOutput.OutputType getType() {
            return this.outputType;
        }

        @Override
        public Collection<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getFilterName() {
            return null;
        }

        @Override
        public int getVersionCode() {
            return this.versionCode;
        }

        @Override
        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getOutputFileName() {
            return this.outputFileName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.outputType).add("versionCode", this.versionCode).add("versionName", (Object)this.versionName).add("enabled", this.enabled).add("outputFileName", (Object)this.outputFileName).add("filters", this.filters).toString();
        }
    }
}

