/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Collection;

public interface ApkInfo
extends Serializable {
    public VariantOutput.OutputType getType();

    public Collection<FilterData> getFilters();

    public FilterData getFilter(VariantOutput.FilterType var1);

    public int getVersionCode();

    public String getVersionName();

    public boolean isEnabled();

    public String getOutputFileName();

    public boolean requiresAapt();

    public String getFilterName();

    public String getFullName();

    public String getBaseName();

    public static ApkInfo of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode) {
        return ApkInfo.of(outputType, filters, versionCode, null, null, null, null, "", true);
    }

    public static ApkInfo of(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode, String versionName, String filterName, String outputFileName, String fullName, String baseName, boolean enabled) {
        return new DefaultApkInfo(outputType, filters, versionCode, versionName, filterName, outputFileName, fullName, baseName, enabled);
    }

    public static class DefaultApkInfo
    implements ApkInfo {
        private final VariantOutput.OutputType outputType;
        private final Collection<FilterData> filters;
        private final int versionCode;
        private final String versionName;
        private final String filterName;
        private final String outputFileName;
        private final boolean enabled;
        private final String fullName;
        private final String baseName;

        public DefaultApkInfo(VariantOutput.OutputType outputType, Collection<FilterData> filters, int versionCode, String versionName, String filterName, String outputFileName, String fullName, String baseName, boolean enabled) {
            this.outputType = outputType;
            this.filters = filters;
            this.versionCode = versionCode;
            this.versionName = versionName;
            this.filterName = filterName;
            this.outputFileName = outputFileName;
            this.fullName = fullName;
            this.baseName = baseName;
            this.enabled = enabled;
        }

        @Override
        public VariantOutput.OutputType getType() {
            return this.outputType;
        }

        @Override
        public Collection<FilterData> getFilters() {
            return this.filters;
        }

        @Override
        public String getFilterName() {
            return this.filterName;
        }

        @Override
        public int getVersionCode() {
            return this.versionCode;
        }

        @Override
        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getOutputFileName() {
            return this.outputFileName;
        }

        @Override
        public boolean requiresAapt() {
            return this.outputType != VariantOutput.OutputType.SPLIT;
        }

        @Override
        public String getFullName() {
            return this.fullName;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        @Override
        public FilterData getFilter(VariantOutput.FilterType filterType) {
            for (FilterData filter2 : this.filters) {
                if (filter2.getFilterType() != filterType.name()) continue;
                return filter2;
            }
            return null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.outputType).add("versionCode", this.versionCode).add("versionName", (Object)this.versionName).add("enabled", this.enabled).add("outputFileName", (Object)this.outputFileName).add("fullName", (Object)this.fullName).add("baseName", (Object)this.baseName).add("filters", this.filters).toString();
        }
    }
}

