/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.KnownNamespacesMap;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceTable;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractResourceRepository {
    public static final Object ITEM_MAP_LOCK = new Object();

    @Deprecated
    public final boolean isFramework() {
        return false;
    }

    protected abstract ResourceTable getFullTable();

    protected abstract ListMultimap<String, ResourceItem> getMap(ResourceNamespace var1, ResourceType var2, boolean var3);

    public abstract Set<ResourceNamespace> getNamespaces();

    protected final ListMultimap<String, ResourceItem> getMap(ResourceNamespace namespace, ResourceType type) {
        return this.getMap(namespace, type, true);
    }

    public ResourceTable getItems() {
        return this.getFullTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ResourceItem> getAllResourceItems() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ResourceTable table = this.getFullTable();
            ArrayList<ResourceItem> result = new ArrayList<ResourceItem>(table.size());
            for (ListMultimap multimap : table.values()) {
                result.addAll(multimap.values());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceItem> getResourceItem(ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceNamespace.TODO, resourceType, false);
            if (map != null) {
                return map.get((Object)resourceName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getItemsOfType(ResourceType type) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceNamespace.TODO, type, false);
            if (map == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(map.keySet());
        }
    }

    public boolean hasResourceItem(String url) {
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return this.hasResourceItem(url);
            }
            int colon = url.indexOf(58);
            if (colon != -1) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return this.hasResourceItem(url);
            }
            int slash = url.indexOf(47);
            if (slash == -1) {
                url = "@attr/" + remainder;
                return this.hasResourceItem(url);
            }
        }
        if (!url.startsWith("@")) {
            return false;
        }
        assert (url.startsWith("@") || url.startsWith("?")) : url;
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd != -1) {
            String typeName;
            ResourceType type;
            int nameBegin = typeEnd + 1;
            int typeBegin = url.startsWith("@+") ? 2 : 1;
            int colon = url.lastIndexOf(58, typeEnd);
            if (colon != -1) {
                typeBegin = colon + 1;
            }
            if ((type = ResourceType.getEnum((String)(typeName = url.substring(typeBegin, typeEnd)))) != null) {
                String name = url.substring(nameBegin);
                return this.hasResourceItem(type, name);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourceItem(ResourceType resourceType, String resourceName) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceNamespace.TODO, resourceType, false);
            if (map != null) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                List itemList = map.get((Object)resourceName);
                return itemList != null && !itemList.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResourcesOfType(ResourceType resourceType) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> map = this.getMap(ResourceNamespace.TODO, resourceType, false);
            return map != null && !map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceType> getAvailableResourceTypes() {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            return Lists.newArrayList(this.getFullTable().row(ResourceNamespace.TODO).keySet());
        }
    }

    public ResourceFile getMatchingFile(String name, ResourceType type, FolderConfiguration config) {
        List<ResourceFile> matchingFiles = this.getMatchingFiles(name, type, config);
        return matchingFiles.isEmpty() ? null : matchingFiles.get(0);
    }

    public List<ResourceFile> getMatchingFiles(String name, ResourceType type, FolderConfiguration config) {
        return this.getMatchingFiles(name, type, config, new HashSet<String>(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResourceFile> getMatchingFiles(String name, ResourceType type, FolderConfiguration config, Set<String> seenNames, int depth) {
        ArrayList<ResourceFile> output;
        assert (!seenNames.contains(name));
        if (depth >= 50) {
            return Collections.emptyList();
        }
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> typeItems = this.getMap(ResourceNamespace.TODO, type, false);
            if (typeItems == null) {
                return Collections.emptyList();
            }
            seenNames.add(name);
            output = new ArrayList<ResourceFile>();
            List matchingItems = typeItems.get((Object)name);
            List matches = config.findMatchingConfigurables(matchingItems);
            for (ResourceItem match : matches) {
                ResourceUrl url;
                String value;
                ResourceValue resourceValue = match.getResourceValue(this.isFramework());
                if (resourceValue != null && (value = resourceValue.getValue()) != null && value.startsWith("@") && (url = ResourceUrl.parse((String)value)) != null && url.type == type && url.framework == this.isFramework()) {
                    if (seenNames.contains(url.name)) continue;
                    output.addAll(this.getMatchingFiles(url.name, type, config, seenNames, depth + 1));
                    continue;
                }
                output.add((ResourceFile)match.getSource());
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table<ResourceNamespace, ResourceType, ResourceValueMap> getConfiguredResources(FolderConfiguration referenceConfig) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            Set<ResourceNamespace> namespaces = this.getNamespaces();
            Map backingMap = KnownNamespacesMap.canContainAll(namespaces) ? new KnownNamespacesMap() : new HashMap();
            Table table = Tables.newCustomTable(backingMap, () -> Maps.newEnumMap(ResourceType.class));
            for (ResourceNamespace namespace : namespaces) {
                assert (namespace != ResourceNamespace.ANDROID);
                for (ResourceType type : ResourceType.values()) {
                    table.put((Object)namespace, (Object)type, (Object)this.getConfiguredResources(type, referenceConfig));
                }
            }
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceValueMap getConfiguredResources(ResourceType type, FolderConfiguration referenceConfig) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap items = (ListMultimap)this.getFullTable().get(ResourceNamespace.TODO, type);
            if (items == null) {
                return ResourceValueMap.create();
            }
            Set keys = items.keySet();
            ResourceValueMap map = ResourceValueMap.createWithExpectedSize(keys.size());
            for (String key : keys) {
                ResourceValue value;
                List keyItems = items.get((Object)key);
                ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(keyItems);
                if (match == null || (value = match.getResourceValue(this.isFramework())) == null) continue;
                map.put(match.getName(), value);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceValue getConfiguredValue(ResourceType type, String name, FolderConfiguration referenceConfig) {
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            ListMultimap<String, ResourceItem> items = this.getMap(ResourceNamespace.TODO, type, false);
            if (items == null) {
                return null;
            }
            List keyItems = items.get((Object)name);
            if (keyItems == null) {
                return null;
            }
            ResourceItem match = (ResourceItem)referenceConfig.findMatchingConfigurable(keyItems);
            ResourceValue resourceValue = match != null ? match.getResourceValue(this.isFramework()) : null;
            return resourceValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getLanguages() {
        TreeSet<String> set = new TreeSet<String>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap map : this.getFullTable().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null) continue;
            set.add(locale.getLanguage());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<LocaleQualifier> getLocales() {
        TreeSet<LocaleQualifier> set = new TreeSet<LocaleQualifier>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap map : this.getFullTable().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null) continue;
            set.add(locale);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getRegions(String currentLanguage) {
        TreeSet<String> set = new TreeSet<String>();
        HashSet qualifiers = Sets.newHashSet();
        Iterator iterator = ITEM_MAP_LOCK;
        synchronized (iterator) {
            for (ListMultimap map : this.getFullTable().values()) {
                for (ResourceItem item : map.values()) {
                    qualifiers.add(item.getQualifiers());
                }
            }
        }
        for (String s : qualifiers) {
            LocaleQualifier locale;
            FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString(s);
            if (configuration == null || (locale = configuration.getLocaleQualifier()) == null || locale.getRegion() == null || !locale.getLanguage().equals(currentLanguage)) continue;
            set.add(locale.getRegion());
        }
        return set;
    }
}

