/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceMerger;
import com.android.resources.ResourceType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;

public final class ResourceTable
extends ForwardingTable<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> {
    private final Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(ResourceType.class));

    protected Table<ResourceNamespace, ResourceType, ListMultimap<String, ResourceItem>> delegate() {
        return this.delegate;
    }

    public void remove(ResourceItem resourceItem) {
        ResourceNamespace namespace = resourceItem.getNamespace();
        ResourceType type = resourceItem.getType();
        String name = resourceItem.getName();
        ListMultimap multimap = (ListMultimap)this.get(namespace, type);
        if (multimap != null) {
            multimap.remove((Object)name, (Object)resourceItem);
            if (multimap.isEmpty()) {
                this.remove(namespace, type);
            }
        }
    }

    public ListMultimap<String, ResourceItem> getOrPutEmpty(ResourceNamespace namespace, ResourceType resourceType) {
        ListMultimap multimap = (ListMultimap)this.get(namespace, resourceType);
        if (multimap == null) {
            multimap = ArrayListMultimap.create();
            this.put(namespace, resourceType, multimap);
        }
        return multimap;
    }

    public void update(ResourceMerger merger) {
        MergeConsumer<ResourceItem> mergeConsumer = new MergeConsumer<ResourceItem>(){

            @Override
            public void start(DocumentBuilderFactory factory) {
            }

            @Override
            public void end() {
            }

            @Override
            public void addItem(ResourceItem item) {
                ListMultimap<String, ResourceItem> multimap;
                if (item.isTouched() && !(multimap = ResourceTable.this.getOrPutEmpty(item.getNamespace(), item.getType())).containsEntry((Object)item.getName(), (Object)item)) {
                    multimap.put((Object)item.getName(), (Object)item);
                }
            }

            @Override
            public void removeItem(ResourceItem removedItem, ResourceItem replacedBy) {
                ResourceTable.this.remove(removedItem);
            }

            @Override
            public boolean ignoreItemInMerge(ResourceItem item) {
                return false;
            }
        };
        try {
            merger.mergeData(mergeConsumer, true);
        }
        catch (MergingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ResourceItem> get(ResourceReference reference) {
        ListMultimap multimap = (ListMultimap)this.get(reference.getNamespace(), reference.getResourceType());
        if (multimap == null) {
            return null;
        }
        return multimap.get((Object)reference.getName());
    }
}

