/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.utils.PositionXmlParser;
import com.android.utils.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Deprecated
class ValueResourceParser2 {
    private final File mFile;
    private final String mLibraryName;
    private final ResourceNamespace mNamespace;
    private boolean mTrackSourcePositions = true;
    private boolean mCheckDuplicates = true;
    private boolean mAllowUnspecifiedAttrFormat;

    ValueResourceParser2(File file, ResourceNamespace namespace, String libraryName) {
        this.mFile = file;
        this.mNamespace = namespace;
        this.mLibraryName = libraryName;
    }

    void setTrackSourcePositions(boolean value) {
        this.mTrackSourcePositions = value;
    }

    void setCheckDuplicates(boolean value) {
        this.mCheckDuplicates = value;
    }

    void setAllowUnspecifiedAttrFormat(boolean value) {
        this.mAllowUnspecifiedAttrFormat = value;
    }

    List<ResourceItem> parseFile() throws MergingException {
        Document document = ValueResourceParser2.parseDocument(this.mFile, this.mTrackSourcePositions);
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            return Collections.emptyList();
        }
        NodeList nodes = rootNode.getChildNodes();
        int count = nodes.getLength();
        ArrayList<ResourceItem> resources = new ArrayList<ResourceItem>(count);
        EnumMap<ResourceType, Set<String>> map = this.mCheckDuplicates ? new EnumMap<ResourceType, Set<String>>(ResourceType.class) : null;
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, this.mFile, this.mNamespace, this.mLibraryName)) == null) continue;
            ValueResourceParser2.checkDuplicate(resource, map, this.mFile);
            resources.add(resource);
            if (resource.getType() != ResourceType.DECLARE_STYLEABLE) continue;
            ValueResourceParser2.addStyleableItems(node, resources, map, this.mFile, this.mNamespace, this.mLibraryName, this.mAllowUnspecifiedAttrFormat);
        }
        return resources;
    }

    static ResourceItem getResource(Node node, File from, ResourceNamespace namespace, String libraryName) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, from);
        String name = ValueResourceParser2.getName(node);
        if (name != null) {
            if (type != null) {
                ValueResourceNameValidator.validate(name, type, from);
                return new ResourceItem(name, namespace, type, node, libraryName);
            }
        } else if (type == ResourceType.PUBLIC) {
            return new ResourceItem("", namespace, type, node, libraryName);
        }
        return null;
    }

    static ResourceType getType(Node node, File from) throws MergingException {
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "type");
            if (attribute != null) {
                typeString = attribute.getValue();
            }
        } else {
            if ("eat-comment".equals(nodeName) || "skip".equals(nodeName)) {
                return null;
            }
            typeString = nodeName;
        }
        if (typeString != null) {
            ResourceType type = ResourceType.getEnum((String)typeString);
            if (type != null) {
                return type;
            }
            throw MergingException.withMessage("Unsupported type '%s'", typeString).withFile(from).build();
        }
        throw MergingException.withMessage("Unsupported node '%s'", nodeName).withFile(from).build();
    }

    static String getName(Node node) {
        Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "name");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    static Document parseDocument(File file, boolean trackPositions) throws MergingException {
        try {
            if (trackPositions) {
                return PositionXmlParser.parse((InputStream)new BufferedInputStream(new FileInputStream(file)));
            }
            return XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
        }
        catch (SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (IOException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    static void addStyleableItems(Node styleableNode, List<ResourceItem> list, Map<ResourceType, Set<String>> map, File from, ResourceNamespace namespace, String libraryName, boolean allowUnspecifiedFormat) throws MergingException {
        assert (styleableNode.getNodeName().equals(ResourceType.DECLARE_STYLEABLE.getName()));
        NodeList nodes = styleableNode.getChildNodes();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, from, namespace, libraryName)) == null) continue;
            assert (resource.getType() == ResourceType.ATTR);
            if (resource.getName().startsWith("android:") || !allowUnspecifiedFormat && !ValueResourceParser2.hasFormatAttribute(node) && !XmlUtils.hasElementChildren((Node)node)) continue;
            ValueResourceParser2.checkDuplicate(resource, map, from);
            resource.setIgnoredFromDiskMerge(true);
            list.add(resource);
        }
    }

    private static void checkDuplicate(ResourceItem resource, Map<ResourceType, Set<String>> map, File from) throws MergingException {
        String name;
        if (map == null) {
            return;
        }
        Set<String> set = map.get(resource.getType());
        if (set == null) {
            set = new HashSet<String>();
            map.put(resource.getType(), set);
        }
        if (!set.add(name = resource.getName()) && resource.getType() != ResourceType.PUBLIC) {
            throw MergingException.withMessage("Found item %s/%s more than one time", resource.getType().getDisplayName(), name).withFile(from).build();
        }
    }

    private static boolean hasFormatAttribute(Node node) {
        return node.getAttributes().getNamedItemNS(null, "format") != null;
    }
}

