/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceResolver
extends RenderResources {
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final String LEGACY_THEME = "";
    public static final Pattern DEVICE_DEFAULT_PATTERN = Pattern.compile("(\\p{Alpha}+)?\\.?DeviceDefault\\.?(.+)?");
    private final Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> mResources;
    private final Map<StyleResourceValue, StyleResourceValue> mStyleInheritanceMap = new HashMap<StyleResourceValue, StyleResourceValue>();
    private StyleResourceValue mDefaultTheme;
    private final List<StyleResourceValue> mThemes;
    private RenderResources.ResourceIdProvider mFrameworkIdProvider = new RenderResources.FrameworkResourceIdProvider();
    private RenderResources.ResourceIdProvider mLibrariesIdProvider = new RenderResources.ResourceIdProvider();
    private LayoutLog mLogger;
    private final String mThemeName;
    private boolean mIsProjectTheme;
    private String mDeviceDefaultParent;
    private SampleDataManager mSampleDataManager = new SampleDataManager();

    private ResourceResolver(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, String themeName, boolean isProjectTheme) {
        this.mResources = resources;
        this.mThemeName = themeName;
        this.mIsProjectTheme = isProjectTheme;
        this.mThemes = new LinkedList<StyleResourceValue>();
    }

    public static ResourceResolver create(Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, String themeName, boolean isProjectTheme) {
        ResourceResolver resolver = new ResourceResolver(resources, themeName, isProjectTheme);
        resolver.computeStyleMaps();
        return resolver;
    }

    public static ResourceResolver copy(ResourceResolver original) {
        if (original == null) {
            return null;
        }
        ResourceResolver resolver = new ResourceResolver(original.mResources, original.mThemeName, original.mIsProjectTheme);
        resolver.mFrameworkIdProvider = original.mFrameworkIdProvider;
        resolver.mLibrariesIdProvider = original.mLibrariesIdProvider;
        resolver.mLogger = original.mLogger;
        resolver.mDefaultTheme = original.mDefaultTheme;
        resolver.mStyleInheritanceMap.putAll(original.mStyleInheritanceMap);
        resolver.mThemes.addAll(original.mThemes);
        return resolver;
    }

    public static ResourceResolver withValues(ResourceValue ... values) {
        HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources = new HashMap<ResourceNamespace, Map<ResourceType, ResourceValueMap>>();
        for (ResourceValue value : values) {
            Map byType = resources.computeIfAbsent(value.getNamespace(), ns -> new HashMap());
            ResourceValueMap resourceValueMap = byType.computeIfAbsent(value.getResourceType(), t -> ResourceValueMap.create());
            Preconditions.checkArgument((!resourceValueMap.containsKey(value.getName()) ? 1 : 0) != 0, (Object)("Duplicate resource: " + value));
            resourceValueMap.put(value);
        }
        return ResourceResolver.create(resources, null, false);
    }

    private ResourceValueMap getResourceValueMap(ResourceNamespace namespace, ResourceType type) {
        Map<ResourceType, ResourceValueMap> row = this.mResources.get(namespace);
        return row != null ? row.get(type) : null;
    }

    public void setDeviceDefaults(String deviceDefaultParent) {
        if (deviceDefaultParent.equals(this.mDeviceDefaultParent)) {
            return;
        }
        this.mDeviceDefaultParent = deviceDefaultParent;
        String parentName = Strings.emptyToNull((String)deviceDefaultParent);
        ResourceValueMap frameworkStyles = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (frameworkStyles == null) {
            return;
        }
        for (ResourceValue value : frameworkStyles.values()) {
            Matcher matcher = DEVICE_DEFAULT_PATTERN.matcher(value.getName());
            if (!matcher.matches()) continue;
            String newParentStyle = Joiner.on((char)'.').skipNulls().join((Object)matcher.group(1), (Object)parentName, new Object[]{matcher.groupCount() > 1 ? matcher.group(2) : null});
            this.patchFrameworkStyleParent(value.getName(), newParentStyle);
        }
    }

    private void patchFrameworkStyleParent(String childStyleName, String parentName) {
        ResourceValueMap map = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        if (map != null) {
            StyleResourceValue from = (StyleResourceValue)map.get(childStyleName);
            StyleResourceValue to = (StyleResourceValue)map.get(parentName);
            if (from != null && to != null) {
                StyleResourceValue newStyle = new StyleResourceValue((ResourceReference)from, parentName, from.getLibraryName());
                newStyle.replaceWith((ResourceValue)from);
                this.mStyleInheritanceMap.put(newStyle, to);
            }
        }
    }

    public String getThemeName() {
        return this.mThemeName;
    }

    public boolean isProjectTheme() {
        return this.mIsProjectTheme;
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getProjectResources() {
        return this.mResources.get(ResourceNamespace.RES_AUTO);
    }

    @Deprecated
    public Map<ResourceType, ResourceValueMap> getFrameworkResources() {
        return this.mResources.get(ResourceNamespace.ANDROID);
    }

    public void setLibrariesIdProvider(RenderResources.ResourceIdProvider provider) {
        this.mLibrariesIdProvider = provider;
    }

    public void setFrameworkResourceIdProvider(RenderResources.ResourceIdProvider provider) {
        this.mFrameworkIdProvider = provider;
    }

    public void setFrameworkResourceIdProvider(RenderResources.FrameworkResourceIdProvider provider) {
        this.setFrameworkResourceIdProvider((RenderResources.ResourceIdProvider)provider);
    }

    public void setLogger(LayoutLog logger) {
        this.mLogger = logger;
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mDefaultTheme;
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        if (theme == null) {
            return;
        }
        if (useAsPrimary) {
            this.mThemes.add(0, theme);
        } else {
            this.mThemes.add(theme);
        }
    }

    public void clearStyles() {
        this.mThemes.clear();
        this.mThemes.add(this.mDefaultTheme);
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mThemes;
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        do {
            if ((childTheme = this.mStyleInheritanceMap.get(childTheme)) != null) continue;
            return false;
        } while (childTheme != parentTheme);
        return true;
    }

    @Deprecated
    public ItemResourceValue findItemInStyle(StyleResourceValue style, String attrName) {
        ItemResourceValue item = this.findItemInStyle(style, attrName, false);
        if (item == null) {
            item = this.findItemInStyle(style, attrName, true);
        }
        return item;
    }

    public ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
        return this.findItemInStyle(style, itemName, isFrameworkAttr, 0);
    }

    private ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr, int depth) {
        StyleResourceValue parentStyle;
        ItemResourceValue item = style.getItem(itemName, isFrameworkAttr);
        if (item == null && (parentStyle = this.mStyleInheritanceMap.get(style)) != null) {
            if (depth >= 50) {
                if (this.mLogger != null) {
                    this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(style)), null, null, null);
                }
                return null;
            }
            return this.findItemInStyle(parentStyle, itemName, isFrameworkAttr, depth + 1);
        }
        return item;
    }

    private String computeCyclicStyleChain(StyleResourceValue style) {
        StringBuilder sb = new StringBuilder(100);
        this.appendStyleParents(style, new HashSet<StyleResourceValue>(), 0, sb);
        return sb.toString();
    }

    private void appendStyleParents(StyleResourceValue style, Set<StyleResourceValue> seen, int depth, StringBuilder sb) {
        if (depth >= 50) {
            sb.append("...");
            return;
        }
        boolean haveSeen = seen.contains(style);
        seen.add(style);
        sb.append('\"');
        if (style.isFramework()) {
            sb.append("android:");
        }
        sb.append(style.getName());
        sb.append('\"');
        if (haveSeen) {
            return;
        }
        StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(style);
        if (parentStyle != null) {
            if (style.getParentStyle() != null) {
                sb.append(" specifies parent ");
            } else {
                sb.append(" implies parent ");
            }
            this.appendStyleParents(parentStyle, seen, depth + 1, sb);
        }
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        ResourceValueMap resourceValueMap = this.getResourceValueMap(reference.getNamespace(), reference.getResourceType());
        if (resourceValueMap != null) {
            return (ResourceValue)resourceValueMap.get(reference.getName());
        }
        return null;
    }

    public ResourceValue dereference(ResourceValue value) {
        ResourceReference reference = value.getReference();
        if (reference == null || !ResourceUrl.isValidName((String)reference.getName(), (ResourceType)reference.getResourceType())) {
            return null;
        }
        assert (value.getValue() != null);
        if (value.getValue().startsWith("?")) {
            if (this.mDefaultTheme == null) {
                return null;
            }
            if (reference.getResourceType() != ResourceType.ATTR) {
                return null;
            }
            return this.findItemInTheme(reference.getName(), reference.isFramework());
        }
        if (reference.getResourceType() == ResourceType.AAPT) {
            return null;
        }
        if (reference.getResourceType() == ResourceType.SAMPLE_DATA) {
            return this.findSampleDataValue(reference);
        }
        ResourceValue result = this.getUnresolvedResource(reference);
        if (result != null) {
            return result;
        }
        if (value.getValue().startsWith("@+id/")) {
            return null;
        }
        if (reference.getResourceType() == ResourceType.ID) {
            boolean idExists;
            boolean bl = reference.isFramework() ? this.mFrameworkIdProvider.getId(ResourceType.ID, reference.getName()) != null : (idExists = this.mLibrariesIdProvider.getId(ResourceType.ID, reference.getName()) != null);
            if (idExists) {
                return new ResourceValue(reference, null);
            }
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource " + reference.getResourceUrl(), null, (Object)reference);
        }
        return null;
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null || resValue instanceof ArrayResourceValue) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.dereference(resValue);
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null, null, null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    private ResourceValue findSampleDataValue(ResourceReference value) {
        String name = value.getName();
        return Optional.ofNullable(this.getResourceValueMap(value.getNamespace(), value.getResourceType())).map(t -> (ResourceValue)t.get(SampleDataManager.getResourceNameFromSampleReference(name))).filter(SampleDataResourceValue.class::isInstance).map(SampleDataResourceValue.class::cast).map(SampleDataResourceValue::getValueAsLines).map(content -> this.mSampleDataManager.getSampleDataLine(name, (ImmutableList<String>)content)).map(lineContent -> new ResourceValue(value.getNamespace(), ResourceType.SAMPLE_DATA, name, lineContent)).orElse(null);
    }

    private void computeStyleMaps() {
        ResourceValueMap projectStyleMap = this.getResourceValueMap(ResourceNamespace.TODO, ResourceType.STYLE);
        ResourceValueMap frameworkStyleMap = this.getResourceValueMap(ResourceNamespace.ANDROID, ResourceType.STYLE);
        ResourceValue theme = null;
        if (this.mIsProjectTheme) {
            if (projectStyleMap != null) {
                theme = (ResourceValue)projectStyleMap.get(this.mThemeName);
            }
        } else if (frameworkStyleMap != null) {
            theme = (ResourceValue)frameworkStyleMap.get(this.mThemeName);
        }
        if (theme instanceof StyleResourceValue) {
            this.computeStyleInheritance(projectStyleMap.values(), projectStyleMap, frameworkStyleMap);
            if (frameworkStyleMap != null) {
                this.computeStyleInheritance(frameworkStyleMap.values(), null, frameworkStyleMap);
            }
            this.mDefaultTheme = (StyleResourceValue)theme;
            this.mThemes.clear();
            this.mThemes.add(this.mDefaultTheme);
        }
    }

    private void computeStyleInheritance(Collection<ResourceValue> styles, ResourceValueMap inProjectStyleMap, ResourceValueMap inFrameworkStyleMap) {
        this.mDeviceDefaultParent = null;
        for (ResourceValue value : styles) {
            StyleResourceValue parentStyle;
            StyleResourceValue style;
            String parentName;
            if (!(value instanceof StyleResourceValue) || (parentName = ResourceResolver.getParentName(style = (StyleResourceValue)value)) == null || (parentStyle = this.getStyle(parentName, inProjectStyleMap, inFrameworkStyleMap)) == null) continue;
            this.mStyleInheritanceMap.put(style, parentStyle);
        }
    }

    public static String getParentName(StyleResourceValue style) {
        String parentName = style.getParentStyle();
        if (parentName != null) {
            return parentName;
        }
        String styleName = style.getName();
        int index = styleName.lastIndexOf(46);
        if (index != -1) {
            return styleName.substring(0, index);
        }
        return null;
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        return this.mStyleInheritanceMap.get(style);
    }

    public StyleResourceValue getStyle(ResourceReference styleReference) {
        ResourceValue style = this.getUnresolvedResource(styleReference);
        if (style == null) {
            return null;
        }
        if (style instanceof StyleResourceValue) {
            return (StyleResourceValue)style;
        }
        if (this.mLogger != null) {
            this.mLogger.error(null, String.format("Style %1$s is not of type STYLE (instead %2$s)", styleReference, style.getResourceType().toString()), null, null, (Object)styleReference);
        }
        return null;
    }

    private StyleResourceValue getStyle(String parentName, ResourceValueMap inProjectStyleMap, ResourceValueMap inFrameworkStyleMap) {
        boolean frameworkOnly = false;
        String name = parentName;
        if (name.startsWith("@")) {
            name = name.substring("@".length());
        }
        if (name.startsWith("android:")) {
            frameworkOnly = true;
            name = name.substring("android:".length());
        }
        if (name.startsWith("style/")) {
            name = name.substring("style/".length());
        } else if (name.indexOf(47) != -1) {
            return null;
        }
        ResourceValue parent = null;
        if (!frameworkOnly && inProjectStyleMap != null) {
            parent = (ResourceValue)inProjectStyleMap.get(name);
        }
        if (parent == null) {
            if (inFrameworkStyleMap == null) {
                return null;
            }
            parent = (ResourceValue)inFrameworkStyleMap.get(name);
        }
        if (parent instanceof StyleResourceValue) {
            return (StyleResourceValue)parent;
        }
        if (this.mLogger != null) {
            this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", parentName), null, null, null);
        }
        return null;
    }

    public boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache) {
        return this.isTheme(value, cache, 0);
    }

    private boolean isTheme(ResourceValue value, Map<ResourceValue, Boolean> cache, int depth) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue srv = (StyleResourceValue)value;
            String name = srv.getName();
            if (srv.isFramework() && (name.equals(THEME_NAME) || name.startsWith(THEME_NAME_DOT))) {
                if (cache != null) {
                    cache.put(value, true);
                }
                return true;
            }
            StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(srv);
            if (parentStyle != null) {
                if (depth >= 50) {
                    if (this.mLogger != null) {
                        this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(srv)), null, null, null);
                    }
                    return false;
                }
                boolean result = this.isTheme((ResourceValue)parentStyle, cache, depth + 1);
                if (cache != null) {
                    cache.put(value, result);
                }
                return result;
            }
        }
        return false;
    }

    public boolean themeExtends(String parentStyle, String themeStyle) {
        ResourceValue parentValue = this.findResValue(parentStyle, parentStyle.startsWith("@android:style/"));
        if (parentValue instanceof StyleResourceValue) {
            ResourceValue themeValue = this.findResValue(themeStyle, themeStyle.startsWith("@android:style/"));
            if (themeValue == parentValue) {
                return true;
            }
            if (themeValue instanceof StyleResourceValue) {
                return this.themeIsParentOf((StyleResourceValue)parentValue, (StyleResourceValue)themeValue);
            }
        }
        return false;
    }

    public ResourceResolver createRecorder(List<ResourceValue> lookupChain) {
        RecordingResourceResolver resolver = new RecordingResourceResolver(lookupChain, this.mResources, this.mThemeName, this.mIsProjectTheme);
        resolver.mFrameworkIdProvider = this.mFrameworkIdProvider;
        resolver.mLogger = this.mLogger;
        resolver.mDefaultTheme = this.mDefaultTheme;
        resolver.mStyleInheritanceMap.putAll(this.mStyleInheritanceMap);
        resolver.mThemes.addAll(this.mThemes);
        return resolver;
    }

    private static class RecordingResourceResolver
    extends ResourceResolver {
        private List<ResourceValue> mLookupChain;

        private RecordingResourceResolver(List<ResourceValue> lookupChain, Map<ResourceNamespace, Map<ResourceType, ResourceValueMap>> resources, String themeName, boolean isProjectTheme) {
            super(resources, themeName, isProjectTheme);
            this.mLookupChain = lookupChain;
        }

        @Override
        public ResourceValue resolveResValue(ResourceValue resValue) {
            if (resValue != null) {
                this.mLookupChain.add(resValue);
            }
            return super.resolveResValue(resValue);
        }

        @Override
        public ResourceValue dereference(ResourceValue value) {
            ResourceValue resValue;
            if (!this.mLookupChain.isEmpty() && !this.mLookupChain.get(this.mLookupChain.size() - 1).equals((Object)value)) {
                this.mLookupChain.add(value);
            }
            if ((resValue = super.dereference(value)) != null) {
                this.mLookupChain.add(resValue);
            }
            return resValue;
        }

        @Override
        public ItemResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
            ItemResourceValue value = super.findItemInStyle(style, itemName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add((ResourceValue)value);
            }
            return value;
        }

        public ResourceValue findItemInTheme(String attrName, boolean isFrameworkAttr) {
            ResourceValue value = super.findItemInTheme(attrName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }
    }
}

