/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LazyUnionMap<K, V>
implements Map<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;

    public LazyUnionMap(Map<K, V> first, Map<K, V> second) {
        Preconditions.checkArgument((boolean)Sets.intersection(first.keySet(), second.keySet()).isEmpty(), (Object)"Key sets are not disjoint.");
        this.first = first;
        this.second = second;
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V result = this.first.get(key);
        if (result == null) {
            result = this.second.get(key);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return LazyUnionMap.unionOfDisjointSets(this.first.keySet(), this.second.keySet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return LazyUnionMap.unionOfDisjointSets(this.first.entrySet(), this.second.entrySet());
    }

    private static <T> Set<T> unionOfDisjointSets(Set<T> first, Set<T> second) {
        HashSet allKeys = Sets.newHashSetWithExpectedSize((int)(first.size() + second.size()));
        allKeys.addAll(first);
        allKeys.addAll(second);
        return allKeys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> allValues = new ArrayList<V>(this.first.size() + this.second.size());
        allValues.addAll(this.first.values());
        allValues.addAll(this.second.values());
        return allValues;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

