/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import java.util.List;

public class ResourceItemResolver
extends RenderResources {
    private final FolderConfiguration myConfiguration;
    private final LayoutLog myLogger;
    private final ResourceProvider myResourceProvider;
    private ResourceResolver myResolver;
    private AbstractResourceRepository myFrameworkResources;
    private AbstractResourceRepository myAppResources;
    private List<ResourceValue> myLookupChain;

    public ResourceItemResolver(FolderConfiguration configuration, ResourceProvider resourceProvider, LayoutLog logger) {
        this.myConfiguration = configuration;
        this.myResourceProvider = resourceProvider;
        this.myLogger = logger;
        this.myResolver = resourceProvider.getResolver(false);
    }

    public ResourceItemResolver(FolderConfiguration configuration, AbstractResourceRepository frameworkResources, AbstractResourceRepository appResources, LayoutLog logger) {
        this.myConfiguration = configuration;
        this.myResourceProvider = null;
        this.myLogger = logger;
        this.myFrameworkResources = frameworkResources;
        this.myAppResources = appResources;
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        if (this.myResolver != null) {
            return this.myResolver.resolveResValue(resValue);
        }
        if (this.myLookupChain != null) {
            this.myLookupChain.add(resValue);
        }
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null || resValue instanceof ArrayResourceValue) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.findResValue(value, resValue.isFramework());
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.myLogger != null) {
                this.myLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    public ResourceValue dereference(ResourceValue value) {
        String valueText;
        if (this.myResolver != null) {
            return this.myResolver.dereference(value);
        }
        if (this.myLookupChain != null && !this.myLookupChain.isEmpty() && !this.myLookupChain.get(this.myLookupChain.size() - 1).equals((Object)value)) {
            this.myLookupChain.add(value);
        }
        if ((valueText = value.getValue()) == null) {
            return null;
        }
        ResourceUrl url = ResourceUrl.parse((String)valueText);
        if (url != null && url.hasValidName()) {
            if (url.isTheme()) {
                ResourceResolver resolver = this.getFullResolver();
                if (resolver != null) {
                    return resolver.dereference(value);
                }
                return null;
            }
            return this.findResValue(url);
        }
        return null;
    }

    private ResourceValue findResValue(ResourceUrl url) {
        if (!url.isFramework()) {
            ResourceValue item;
            if (this.myAppResources == null) {
                assert (this.myResourceProvider != null);
                this.myAppResources = this.myResourceProvider.getAppResources();
                if (this.myAppResources == null) {
                    return null;
                }
            }
            if ((item = this.myAppResources.getConfiguredValue(url.type, url.name, this.myConfiguration)) != null) {
                if (this.myLookupChain != null) {
                    this.myLookupChain.add(item);
                }
                return item;
            }
        } else {
            List<ResourceItem> items;
            if (this.myFrameworkResources == null) {
                assert (this.myResourceProvider != null);
                this.myFrameworkResources = this.myResourceProvider.getFrameworkResources();
                if (this.myFrameworkResources == null) {
                    return null;
                }
            }
            if (!(items = this.myFrameworkResources.getResourceItems(ResourceNamespace.ANDROID, url.type, url.name)).isEmpty()) {
                ResourceValue value = items.get(0).getResourceValue();
                if (value != null && this.myLookupChain != null) {
                    this.myLookupChain.add(value);
                }
                return value;
            }
        }
        if (this.myLogger != null) {
            this.myLogger.warning("resources.resolve", "Couldn't resolve resource " + url, null, (Object)url);
        }
        return null;
    }

    public StyleResourceValue getCurrentTheme() {
        ResourceResolver resolver = this.getFullResolver();
        if (resolver != null) {
            return resolver.getCurrentTheme();
        }
        return null;
    }

    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        assert (false);
        return super.getTheme(name, frameworkTheme);
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        assert (false);
        return super.themeIsParentOf(parentTheme, childTheme);
    }

    public ResourceValue findItemInTheme(ResourceReference attr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInTheme(attr) : null;
    }

    public ResourceValue findItemInStyle(StyleResourceValue style, ResourceReference attr) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.findItemInStyle(style, attr) : null;
    }

    public StyleResourceValue getParent(StyleResourceValue style) {
        ResourceResolver resolver = this.getFullResolver();
        return resolver != null ? resolver.getParent(style) : null;
    }

    private ResourceResolver getFullResolver() {
        if (this.myResolver == null) {
            if (this.myResourceProvider == null) {
                return null;
            }
            this.myResolver = this.myResourceProvider.getResolver(true);
            if (this.myResolver != null && this.myLookupChain != null) {
                this.myResolver = this.myResolver.createRecorder(this.myLookupChain);
            }
        }
        return this.myResolver;
    }

    public void setLookupChainList(List<ResourceValue> lookupChain) {
        this.myLookupChain = lookupChain;
    }

    public List<ResourceValue> getLookupChain() {
        return this.myLookupChain;
    }

    public static String getDisplayString(ResourceType type, String name, boolean isFramework, List<ResourceValue> lookupChain) {
        String url = ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework).toString();
        return ResourceItemResolver.getDisplayString(url, lookupChain);
    }

    public static String getDisplayString(String url, List<ResourceValue> lookupChain) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        String prev = url;
        for (ResourceValue element : lookupChain) {
            int end;
            String text;
            String value;
            if (element == null || (value = element.getValue()) == null || (text = value).equals(prev)) continue;
            sb.append(" => ");
            if (!text.startsWith("?") && !text.startsWith("@") && (end = Math.max(text.lastIndexOf(47), text.lastIndexOf(92))) != -1) {
                text = text.substring(end + 1);
            }
            sb.append(text);
            prev = value;
        }
        return sb.toString();
    }

    public static interface ResourceProvider {
        public ResourceResolver getResolver(boolean var1);

        public AbstractResourceRepository getFrameworkResources();

        public AbstractResourceRepository getAppResources();
    }
}

