/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMergerItem
extends DataItem<ResourceFile>
implements Comparable<ResourceMergerItem>,
ResourceItem {
    private final ResourceType mType;
    private final ResourceNamespace mNamespace;
    private Node mValue;
    private String mLibraryName;
    protected ResourceValue mResourceValue;
    private boolean mIgnoredFromDiskMerge = false;

    public ResourceMergerItem(String name, ResourceNamespace namespace, ResourceType type, Node value, String libraryName) {
        super(name);
        Preconditions.checkArgument((type == ResourceType.PUBLIC || !name.isEmpty() ? 1 : 0) != 0, (Object)"Resource name cannot be empty.");
        this.mNamespace = namespace;
        this.mType = type;
        this.mValue = value;
        this.mLibraryName = libraryName;
    }

    @Override
    public ResourceType getType() {
        return this.mType;
    }

    public Node getValue() {
        return this.mValue;
    }

    public String getValueText() {
        return this.mValue != null ? this.mValue.getTextContent() : null;
    }

    @Override
    public String getLibraryName() {
        return this.mLibraryName;
    }

    @Override
    public ResourceNamespace getNamespace() {
        return this.mNamespace;
    }

    public String getQualifiers() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getQualifier on " + this.toString());
        }
        return resourceFile.getQualifiers();
    }

    public DataFile.FileType getSourceType() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getSourceType on " + this.toString());
        }
        return resourceFile.getType();
    }

    @Override
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.mNamespace, this.mType, this.getName());
    }

    void setValue(ResourceMergerItem from) {
        this.mValue = from.mValue;
        this.setTouched();
    }

    @Override
    @NotNull
    public FolderConfiguration getConfiguration() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getConfiguration on " + this.toString());
        }
        return resourceFile.getFolderConfiguration();
    }

    @Override
    @NotNull
    public String getKey() {
        String typeAttribute;
        if (this.getSourceFile() == null) {
            throw new IllegalStateException("ResourceItem.getKey called on object with no ResourceFile: " + this);
        }
        String qualifiers = this.getQualifiers();
        String typeName = this.mType.getName();
        if (this.mType == ResourceType.PUBLIC && this.mValue != null && (typeAttribute = ((Element)this.mValue).getAttribute("type")) != null) {
            typeName = typeName + "_" + typeAttribute;
        }
        if (!qualifiers.isEmpty()) {
            return typeName + "-" + qualifiers + "/" + this.getName();
        }
        return typeName + "/" + this.getName();
    }

    @Override
    protected void wasTouched() {
        this.mResourceValue = null;
    }

    @Override
    public ResourceValue getResourceValue() {
        if (this.mResourceValue == null) {
            if (this.mValue == null) {
                Density density = this.mType == ResourceType.DRAWABLE || this.mType == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                ResourceFile source = (ResourceFile)this.getSourceFile();
                assert (source != null);
                this.mResourceValue = density != null ? new DensityBasedResourceValue(this.mNamespace, this.mType, this.getName(), source.getFile().getAbsolutePath(), density, this.mLibraryName) : new ResourceValue(this.mNamespace, this.mType, this.getName(), source.getFile().getAbsolutePath(), this.mLibraryName);
            } else {
                this.mResourceValue = this.parseXmlToResourceValue();
            }
        }
        return this.mResourceValue;
    }

    @Override
    public PathString getSource() {
        File file = this.getFile();
        return file == null ? null : new PathString(file);
    }

    @Override
    public boolean isFileBased() {
        return this.getSourceType() != DataFile.FileType.XML_VALUES;
    }

    private Density getFolderDensity() {
        DensityQualifier densityQualifier;
        Iterable segments;
        FolderConfiguration config;
        String qualifiers = this.getQualifiers();
        if (!qualifiers.isEmpty() && qualifiers.contains("dpi") && (config = FolderConfiguration.getConfigFromQualifiers(segments = Splitter.on((char)'-').split((CharSequence)qualifiers))) != null && (densityQualifier = config.getDensityQualifier()) != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    public String getXmlString(ResourceType type, boolean system) {
        if (type == ResourceType.ID) {
            return (system ? "@android:+id/" : "@+id/") + "/" + this.getName();
        }
        return (system ? "@android:" : "@") + type.getName() + "/" + this.getName();
    }

    public boolean compareValueWith(ResourceMergerItem resource) {
        if (this.mValue != null && resource.mValue != null) {
            return NodeUtils.compareElementNode(this.mValue, resource.mValue, true);
        }
        return this.mValue == resource.mValue;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getType()).add("status", this.getStatus()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMergerItem other = (ResourceMergerItem)o;
        return this.mType == other.mType && this.mNamespace.equals((Object)other.mNamespace);
    }

    @Override
    public int hashCode() {
        return (31 * super.hashCode() + this.mType.hashCode()) * 31 + this.mNamespace.hashCode();
    }

    private ResourceValue parseXmlToResourceValue() {
        AttrResourceValue value;
        assert (this.mValue != null);
        final NamedNodeMap attributes = this.mValue.getAttributes();
        switch (this.mType) {
            case STYLE: {
                String parent = ResourceMergerItem.getAttributeValue(attributes, "parent");
                value = this.parseStyleValue(new StyleResourceValue(this.mNamespace, this.mType, this.getName(), parent, this.mLibraryName));
                break;
            }
            case DECLARE_STYLEABLE: {
                value = this.parseDeclareStyleable(new DeclareStyleableResourceValue(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName));
                break;
            }
            case ARRAY: {
                ArrayResourceValue arrayValue = new ArrayResourceValue(this.mNamespace, this.mType, this.getName(), this.mLibraryName){

                    protected int getDefaultIndex() {
                        String toolsDefaultIndex = ResourceMergerItem.getAttributeValueNS(attributes, "http://schemas.android.com/tools", "index");
                        if (toolsDefaultIndex != null) {
                            try {
                                return Integer.parseInt(toolsDefaultIndex);
                            }
                            catch (NumberFormatException e) {
                                return super.getDefaultIndex();
                            }
                        }
                        return super.getDefaultIndex();
                    }
                };
                value = this.parseArrayValue(arrayValue);
                break;
            }
            case PLURALS: {
                PluralsResourceValue pluralsResourceValue = new PluralsResourceValue(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName){

                    public String getValue() {
                        String value;
                        String quantity = ResourceMergerItem.getAttributeValueNS(attributes, "http://schemas.android.com/tools", "quantity");
                        if (quantity != null && (value = this.getValue(quantity)) != null) {
                            return value;
                        }
                        return super.getValue();
                    }
                };
                value = this.parsePluralsValue(pluralsResourceValue);
                break;
            }
            case ATTR: {
                value = this.parseAttrValue(new AttrResourceValue(this.mNamespace, this.mType, this.getName(), this.mLibraryName));
                break;
            }
            case STRING: {
                value = this.parseTextValue(new TextResourceValue(this.mNamespace, this.mType, this.getName(), null, null, this.mLibraryName));
                break;
            }
            case ANIMATOR: 
            case DRAWABLE: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case TRANSITION: {
                value = this.parseFileName(new ResourceValue(this.mNamespace, this.mType, this.getName(), this.mLibraryName));
                break;
            }
            default: {
                value = this.parseValue(new ResourceValue(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName));
            }
        }
        value.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(this.mValue));
        return value;
    }

    private static ResourceNamespace.Resolver getNamespaceResolver(final Node node) {
        return new ResourceNamespace.Resolver(){

            public String uriToPrefix(String namespaceUri) {
                return node.lookupPrefix(namespaceUri);
            }

            public String prefixToUri(String namespacePrefix) {
                return node.lookupNamespaceURI(namespacePrefix);
            }
        };
    }

    private static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        Attr attribute = (Attr)attributes.getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private static String getAttributeValueNS(NamedNodeMap attributes, String namespaceURI, String attributeName) {
        Attr attribute = (Attr)attributes.getNamedItemNS(namespaceURI, attributeName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private ResourceValue parseStyleValue(StyleResourceValue styleValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String attributeUrl;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || Strings.isNullOrEmpty((String)(attributeUrl = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "name")))) continue;
            ItemResourceValue resValue = new ItemResourceValue(styleValue.getNamespace(), attributeUrl, ValueXmlHelper.unescapeResourceString(ResourceMergerItem.getTextNode(child.getChildNodes()), false, true), styleValue.getLibraryName());
            resValue.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(child));
            styleValue.addItem(resValue);
        }
        return styleValue;
    }

    private AttrResourceValue parseAttrValue(AttrResourceValue attrValue) {
        return ResourceMergerItem.parseAttrValue(this.mValue, attrValue);
    }

    private static AttrResourceValue parseAttrValue(Node valueNode, AttrResourceValue attrValue) {
        NodeList children = valueNode.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null || (value = ResourceMergerItem.getAttributeValue(attributes, "value")) == null) continue;
            try {
                attrValue.addValue(name, Integer.valueOf(Long.decode(value).intValue()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private ResourceValue parseArrayValue(ArrayResourceValue arrayValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String text = ResourceMergerItem.getTextNode(child.getChildNodes());
            text = ValueXmlHelper.unescapeResourceString(text, false, true);
            arrayValue.addElement(text);
        }
        return arrayValue;
    }

    private ResourceValue parsePluralsValue(PluralsResourceValue value) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String quantity;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (quantity = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "quantity")) == null) continue;
            String text = ResourceMergerItem.getTextNode(child.getChildNodes());
            text = ValueXmlHelper.unescapeResourceString(text, false, true);
            value.addPlural(quantity, text);
        }
        return value;
    }

    private ResourceValue parseDeclareStyleable(DeclareStyleableResourceValue declareStyleable) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null) continue;
            ResourceNamespace namespace = declareStyleable.getNamespace();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                namespace = ResourceNamespace.ANDROID;
            }
            AttrResourceValue attr = ResourceMergerItem.parseAttrValue(child, new AttrResourceValue(namespace, ResourceType.ATTR, name, this.mLibraryName));
            attr.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(child));
            declareStyleable.addValue(attr);
        }
        return declareStyleable;
    }

    private ResourceValue parseValue(ResourceValue value) {
        String text = ResourceMergerItem.getTextNode(this.mValue.getChildNodes());
        value.setValue(ValueXmlHelper.unescapeResourceString(text, false, true));
        return value;
    }

    private ResourceValue parseFileName(ResourceValue value) {
        String text = ResourceMergerItem.getTextNode(this.mValue.getChildNodes()).trim();
        if (!(text.isEmpty() || text.startsWith("@") || text.startsWith("?"))) {
            text = Paths.get(text, new String[0]).toString();
        }
        value.setValue(text);
        return value;
    }

    private static String getTextNode(NodeList children) {
        int n = children.getLength();
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)child;
                    if ("g".equals(element.getLocalName()) && element.getNamespaceURI() != null && element.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:document:")) {
                        if (element.hasAttribute("example")) {
                            String example = element.getAttribute("example");
                            sb.append('(').append(example).append(')');
                            continue block5;
                        }
                        if (element.hasAttribute("id")) {
                            String id = element.getAttribute("id");
                            sb.append('$').append('{').append(id).append('}');
                            continue block5;
                        }
                    }
                    NodeList childNodes = child.getChildNodes();
                    sb.append(ResourceMergerItem.getTextNode(childNodes));
                    continue block5;
                }
                case 3: {
                    sb.append(child.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append(child.getNodeValue());
                }
            }
        }
        return sb.toString();
    }

    private TextResourceValue parseTextValue(TextResourceValue value) {
        NodeList children = this.mValue.getChildNodes();
        String text = ResourceMergerItem.getTextNode(children);
        value.setValue(ValueXmlHelper.unescapeResourceString(text, false, true));
        int length = children.getLength();
        if (length >= 1) {
            boolean haveElementChildrenOrCdata = false;
            for (int i = 0; i < length; ++i) {
                if (children.item(i).getNodeType() != 1 && children.item(i).getNodeType() != 4) continue;
                haveElementChildrenOrCdata = true;
                break;
            }
            if (haveElementChildrenOrCdata) {
                String markupText = ResourceMergerItem.getMarkupText(children);
                value.setRawXmlValue(markupText);
            }
        }
        return value;
    }

    private static String getMarkupText(NodeList children) {
        StringBuilder sb = new StringBuilder();
        int n = children.getLength();
        block5: for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)child;
                    String tagName = element.getTagName();
                    sb.append('<');
                    sb.append(tagName);
                    NamedNodeMap attributes = element.getAttributes();
                    int attributeCount = attributes.getLength();
                    if (attributeCount > 0) {
                        for (int j = 0; j < attributeCount; ++j) {
                            Node attribute = attributes.item(j);
                            sb.append(' ');
                            sb.append(attribute.getNodeName());
                            sb.append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue((StringBuilder)sb, (String)attribute.getNodeValue());
                            sb.append('\"');
                        }
                    }
                    sb.append('>');
                    NodeList childNodes = child.getChildNodes();
                    if (childNodes.getLength() > 0) {
                        sb.append(ResourceMergerItem.getMarkupText(childNodes));
                    }
                    sb.append('<');
                    sb.append('/');
                    sb.append(tagName);
                    sb.append('>');
                    continue block5;
                }
                case 3: {
                    sb.append(child.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append("<![CDATA[");
                    sb.append(child.getNodeValue());
                    sb.append("]]>");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(ResourceMergerItem other) {
        int comp = this.mType.compareTo((Enum)other.mType);
        if (comp != 0) {
            return comp;
        }
        comp = this.mNamespace.compareTo(other.mNamespace);
        if (comp != 0) {
            return comp;
        }
        return this.getName().compareTo(other.getName());
    }

    public void setIgnoredFromDiskMerge(boolean ignored) {
        this.mIgnoredFromDiskMerge = ignored;
    }

    public boolean getIgnoredFromDiskMerge() {
        return this.mIgnoredFromDiskMerge;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, null, "type", this.mType.getName());
    }

    @Override
    Node getDetailsXml(Document document) {
        return NodeUtils.duplicateAndAdoptNode(document, this.mValue);
    }
}

