/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathStringUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB9\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0011\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0000H\u0096\u0002J\u001c\u00109\u001a\u00020\u001f2\b\u0010:\u001a\u0004\u0018\u00010\u00002\b\u0010;\u001a\u0004\u0018\u00010\u0000H\u0002J\b\u0010<\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0007H\u0002J\u0010\u0010?\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0013\u0010@\u001a\u00020\u001f2\b\u00108\u001a\u0004\u0018\u00010AH\u0096\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010B\u001a\u00020\u00002\u0006\u0010D\u001a\u00020EH\u0086\u0002J\b\u0010F\u001a\u00020\u0007H\u0016J\u0006\u0010G\u001a\u00020\u0000J\u000e\u0010H\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000J\u000e\u0010I\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0000J\u000e\u0010J\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0007J\u001a\u0010K\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u00072\b\b\u0002\u0010L\u001a\u00020\u0007H\u0002J\u001c\u0010M\u001a\u0004\u0018\u00010\u00002\u0006\u0010C\u001a\u00020\u00072\b\b\u0002\u0010L\u001a\u00020\u0007H\u0002J\u0016\u0010N\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010P\u001a\u0004\u0018\u00010\fJ\b\u0010Q\u001a\u0004\u0018\u00010\u000eJ\b\u0010R\u001a\u00020\u0005H\u0016R\u0014\u0010\u0016\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u001f8G\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0011\u0010#\u001a\u00020\u001f8G\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0011\u0010$\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0018R\u0011\u0010&\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0013\u0010(\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001bR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001bR\u0013\u00101\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b2\u0010*R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u0005048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/android/ide/common/util/PathString;", "", "filesystem", "Ljava/net/URI;", "path", "", "rootLength", "", "(Ljava/net/URI;Ljava/lang/String;I)V", "filesystemUri", "(Ljava/net/URI;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "startIndex", "suffixEndIndex", "prefixEndIndex", "separator", "", "(Ljava/net/URI;Ljava/lang/String;IIIC)V", "endIndex", "getEndIndex", "()I", "fileName", "getFileName", "()Ljava/lang/String;", "getFilesystemUri", "()Ljava/net/URI;", "hasTrailingSeparator", "", "()Z", "hash", "isAbsolute", "isEmptyPath", "nameCount", "getNameCount", "nativePath", "getNativePath", "parent", "getParent", "()Lcom/android/ide/common/util/PathString;", "parentFileName", "getParentFileName", "portablePath", "getPortablePath", "rawPath", "getRawPath", "root", "getRoot", "segments", "", "getSegments", "()Ljava/util/List;", "compareTo", "other", "compatibleRoots", "root1", "root2", "computeHash", "computeNameStart", "end", "driveName", "equals", "", "get", "index", "range", "Lkotlin/ranges/IntRange;", "hashCode", "normalize", "relativize", "resolve", "segment", "subRange", "length", "subRangeOrNull", "subpath", "beginIndex", "toFile", "toPath", "toString", "sdk-common"})
public final class PathString
implements Comparable<PathString> {
    private int hash;
    @NotNull
    private final URI filesystemUri;
    private final String path;
    private final int startIndex;
    private final int suffixEndIndex;
    private final int prefixEndIndex;
    private final char separator;

    @NotNull
    public final String getRawPath() {
        String string = this.path;
        int n = 0;
        int n2 = this.prefixEndIndex;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        string = this.path;
        n = this.startIndex;
        n2 = this.suffixEndIndex;
        stringBuilder = stringBuilder.append(string4);
        String string5 = string;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string4 = string6;
        return stringBuilder.append(string4).toString();
    }

    @NotNull
    public final String getPortablePath() {
        return StringsKt.replace$default((String)this.getRawPath(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getNativePath() {
        return PathStringUtil.access$withSeparator(this.getRawPath(), File.separatorChar);
    }

    @NotNull
    public String toString() {
        String schemeString = this.filesystemUri.toString();
        String path = this.getRawPath();
        StringBuilder buf = new StringBuilder(schemeString.length() + 1 + path.length());
        String string = schemeString;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schemeString");
        if (StringsKt.endsWith$default((String)string, (String)"///", (boolean)false, (int)2, null)) {
            buf.append(schemeString, 0, schemeString.length() - 1);
        } else {
            buf.append(schemeString);
            if (!StringsKt.endsWith$default((CharSequence)schemeString, (char)'/', (boolean)false, (int)2, null)) {
                buf.append(':');
            }
        }
        buf.append(path);
        String string2 = buf.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buf.toString()");
        return string2;
    }

    @Nullable
    public final File toFile() {
        if (Intrinsics.areEqual((Object)this.filesystemUri.getScheme(), (Object)"file")) {
            return new File(this.getRawPath());
        }
        return null;
    }

    @Nullable
    public final Path toPath() {
        Path path;
        try {
            Path path2 = Paths.get(this.filesystemUri);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(filesystemUri)");
            path = path2.getFileSystem().getPath(this.getRawPath(), new String[0]);
        }
        catch (FileSystemNotFoundException e) {
            path = null;
        }
        catch (IllegalArgumentException e) {
            path = null;
        }
        catch (ProviderNotFoundException e) {
            path = null;
        }
        return path;
    }

    @JvmName(name="isAbsolute")
    public final boolean isAbsolute() {
        return this.prefixEndIndex != 0 && PathStringUtil.access$isSeparator(this.path.charAt(this.prefixEndIndex - 1));
    }

    @NotNull
    public final String getFileName() {
        int end = this.getEndIndex();
        String string = this.path;
        int n = this.computeNameStart(end);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, end);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String segment(int index) {
        String string;
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        block14: {
            void $receiver$iv;
            int n4;
            int n5;
            int n6;
            block13: {
                void $receiver$iv2;
                if (index < 0) {
                    throw (Throwable)new IllegalArgumentException("Negative index: " + index);
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n3 = this.startIndex;
                int result$iv = 0;
                void v0 = $receiver$iv2;
                int n7 = v0.getFirst();
                int n8 = v0.getLast();
                n6 = v0.getStep();
                int n9 = n7;
                int n10 = n8;
                if (n6 > 0 ? n9 <= n10 : n9 >= n10) {
                    while (true) {
                        void item$iv;
                        void it;
                        if (PathStringUtil.access$isSeparator(this.path.charAt((int)(it = item$iv)))) {
                            n5 = separatorCount;
                            separatorCount = n5 + 1;
                        }
                        if (separatorCount >= index) {
                            n4 = result$iv;
                            break block13;
                        }
                        ++result$iv;
                        if (item$iv == n8) break;
                        item$iv += n6;
                    }
                }
                n4 = result$iv;
            }
            n2 = n4;
            subRangeStart = n3 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                throw (Throwable)new IllegalArgumentException("Invalid index " + index + " for path " + this.toString());
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                ++subRangeStart;
            }
            lengthCount = 0;
            IntProgression item$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n3 = subRangeStart;
            int result$iv = 0;
            void v4 = $receiver$iv;
            n6 = v4.getFirst();
            int n11 = v4.getLast();
            n5 = v4.getStep();
            int n12 = n6;
            int n13 = n11;
            if (n5 > 0 ? n12 <= n13 : n12 >= n13) {
                while (true) {
                    void item$iv2;
                    void it;
                    if (PathStringUtil.access$isSeparator(this.path.charAt((int)(it = item$iv2)))) {
                        int n14 = lengthCount;
                        lengthCount = n14 + 1;
                    }
                    if (lengthCount >= 1) {
                        n = result$iv;
                        break block14;
                    }
                    ++result$iv;
                    if (item$iv2 == n11) break;
                    item$iv2 += n5;
                }
            }
            n = result$iv;
        }
        n2 = n;
        int subRangeEnd = n3 + n2;
        if (lengthCount < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        String string2 = string = this.path;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(subRangeStart, subRangeEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final PathString get(int index) {
        return PathString.subRange$default(this, index, 0, 2, null);
    }

    @NotNull
    public final PathString get(@NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        if (range.getStep() != 1) {
            throw (Throwable)new IllegalArgumentException("Step must be 1");
        }
        return this.subRange(range.getStart(), range.getEndInclusive() - range.getStart() + 1);
    }

    @NotNull
    public final PathString subpath(int beginIndex, int endIndex) {
        return this.subRange(beginIndex, endIndex - beginIndex);
    }

    @Nullable
    public final PathString getParent() {
        if (this.getEndIndex() <= this.startIndex) {
            return null;
        }
        int newEnd = this.computeNameStart(this.getEndIndex()) - 1;
        if (newEnd <= this.startIndex) {
            return this.getRoot();
        }
        return new PathString(this.filesystemUri, this.path, this.startIndex, newEnd, this.prefixEndIndex, this.separator);
    }

    @Nullable
    public final String getParentFileName() {
        PathString pathString = this.getParent();
        return pathString != null ? pathString.getFileName() : null;
    }

    @Nullable
    public final PathString getRoot() {
        if (this.prefixEndIndex == 0) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, 0, 0, this.prefixEndIndex, this.separator);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNameCount() {
        int n;
        if (this.getEndIndex() == this.prefixEndIndex) {
            return 0;
        }
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n = 0;
        } else {
            void var2_2;
            int count$iv = 0;
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv = ((IntIterator)iterator).nextInt();
                int it = element$iv;
                if (!PathStringUtil.access$isSeparator(this.path.charAt(it))) continue;
                ++count$iv;
            }
            n = var2_2;
        }
        return n + 1;
    }

    public boolean equals(@Nullable Object other) {
        int i;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.util.PathString");
        }
        PathString cfr_ignored_0 = (PathString)object2;
        if (Intrinsics.areEqual((Object)this.filesystemUri, (Object)((PathString)other).filesystemUri) ^ true) {
            return false;
        }
        int length = this.suffixEndIndex - this.startIndex;
        if (length != ((PathString)other).suffixEndIndex - ((PathString)other).startIndex) {
            return false;
        }
        if (this.prefixEndIndex != ((PathString)other).prefixEndIndex) {
            return false;
        }
        int n = 0;
        int n2 = this.prefixEndIndex;
        while (n < n2) {
            if (this.path.charAt(i) != ((PathString)other).path.charAt(i)) {
                return false;
            }
            ++i;
        }
        n2 = length;
        for (i = 0; i < n2; ++i) {
            if (this.path.charAt(this.startIndex + i) == ((PathString)other).path.charAt(((PathString)other).startIndex + i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    private final int computeHash() {
        int i;
        int result = this.filesystemUri.hashCode();
        int n = 0;
        int n2 = this.prefixEndIndex;
        while (n < n2) {
            result = 31 * result + Character.hashCode(this.path.charAt(i));
            ++i;
        }
        n2 = this.suffixEndIndex;
        for (i = this.startIndex; i < n2; ++i) {
            result = 31 * result + Character.hashCode(this.path.charAt(i));
        }
        return result;
    }

    @NotNull
    public final PathString normalize() {
        Object object;
        boolean absolute = this.isAbsolute();
        ArrayDeque<String> newNames = new ArrayDeque<String>();
        Iterable $receiver$iv = this.getSegments();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                String lastName = (String)newNames.peekLast();
                if (lastName != null && Intrinsics.areEqual((Object)lastName, (Object)"..") ^ true) {
                    newNames.removeLast();
                    continue;
                }
                if (absolute) continue;
                newNames.add(it);
                continue;
            }
            if (!(Intrinsics.areEqual((Object)it, (Object)".") ^ true)) continue;
            newNames.add(it);
        }
        if (this.hasTrailingSeparator()) {
            newNames.addLast("");
        }
        if ((object = this.getRoot()) == null || (object = ((PathString)object).getRawPath()) == null || (object = PathStringUtil.access$withSeparator((String)object, this.separator)) == null) {
            object = "";
        }
        Object rootString = object;
        return new PathString(this.filesystemUri, (String)rootString + CollectionsKt.joinToString$default((Iterable)newNames, (CharSequence)("" + this.separator), null, null, (int)0, null, null, (int)62, null));
    }

    @JvmName(name="hasTrailingSeparator")
    public final boolean hasTrailingSeparator() {
        return this.suffixEndIndex > this.startIndex && PathStringUtil.access$isSeparator(this.path.charAt(this.suffixEndIndex - 1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathString relativize(@NotNull PathString other) {
        int item$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        int n;
        List<String> otherSegments;
        List<String> segments;
        block23: {
            void $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            if (this.isEmptyPath()) {
                return other;
            }
            if (this.isAbsolute() && other.isEmptyPath()) {
                return other;
            }
            PathString otherRoot = other.getRoot();
            if (Intrinsics.areEqual((Object)this.getRoot(), (Object)otherRoot) ^ true) {
                Object convertedRootString;
                Object object;
                Object otherRootString;
                Object object2 = otherRoot;
                if (object2 == null || (object2 = ((PathString)object2).getRawPath()) == null) {
                    object2 = otherRootString = "";
                }
                if ((object = this.getRoot()) == null || (object = ((PathString)object).getRawPath()) == null || (object = PathStringUtil.access$withSeparator((String)object, other.separator)) == null) {
                    object = convertedRootString = "";
                }
                if (Intrinsics.areEqual((Object)otherRootString, (Object)convertedRootString) ^ true) {
                    PathString pathString;
                    int result$iv3;
                    int n2;
                    int it;
                    int n3;
                    int n4;
                    int n5;
                    Object rootString;
                    block21: {
                        void $receiver$iv3;
                        rootString = otherRootString;
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.prefixEndIndex)));
                        n5 = this.prefixEndIndex;
                        int result$iv2 = 0;
                        void v2 = $receiver$iv3;
                        int n6 = v2.getFirst();
                        n4 = v2.getLast();
                        n3 = v2.getStep();
                        int n7 = n6;
                        int n8 = n4;
                        if (n3 > 0 ? n7 <= n8 : n7 >= n8) {
                            while (true) {
                                void item$iv;
                                if (this.path.charAt(it = item$iv) == ':') {
                                    n2 = result$iv2;
                                    break block21;
                                }
                                ++result$iv2;
                                if (item$iv == n4) break;
                                item$iv += n3;
                            }
                        }
                        n2 = result$iv2;
                    }
                    int n9 = n2;
                    int afterDriveSeparator = n5 - n9;
                    if (afterDriveSeparator > 0) {
                        int firstDifference;
                        String $receiver$iv4;
                        block22: {
                            int n10;
                            IntProgression result$iv2 = (IntProgression)RangesKt.until((int)0, (int)Math.min(afterDriveSeparator, other.prefixEndIndex));
                            result$iv3 = 0;
                            void v6 = $receiver$iv4;
                            n4 = v6.getFirst();
                            n3 = v6.getLast();
                            it = v6.getStep();
                            int n11 = n4;
                            int n12 = n3;
                            if (it > 0 ? n11 <= n12 : n11 >= n12) {
                                while (true) {
                                    void item$iv;
                                    void it2;
                                    if (this.path.charAt((int)(it2 = item$iv)) != other.path.charAt((int)it2)) {
                                        n10 = result$iv3;
                                        break block22;
                                    }
                                    ++result$iv3;
                                    if (item$iv == n3) break;
                                    item$iv += it;
                                }
                            }
                            n10 = firstDifference = result$iv3;
                        }
                        if (firstDifference >= afterDriveSeparator) {
                            $receiver$iv4 = other.path;
                            result$iv3 = other.prefixEndIndex;
                            String string = $receiver$iv4;
                            if (string == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string2 = string.substring(afterDriveSeparator, result$iv3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            rootString = string2;
                        }
                    }
                    String firstDifference = other.path;
                    int $receiver$iv4 = other.startIndex;
                    result$iv3 = other.suffixEndIndex;
                    StringBuilder stringBuilder = new StringBuilder().append((String)rootString);
                    URI uRI = this.filesystemUri;
                    PathString pathString2 = pathString;
                    PathString pathString3 = pathString;
                    String string = firstDifference;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string.substring($receiver$iv4, result$iv3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = string3;
                    pathString2(uRI, stringBuilder.append(string4).toString(), ((String)rootString).length());
                    return pathString3;
                }
            }
            segments = this.getSegments();
            otherSegments = other.getSegments();
            Collection afterDriveSeparator = segments;
            int n13 = 0;
            int n14 = afterDriveSeparator.size();
            afterDriveSeparator = otherSegments;
            int n15 = afterDriveSeparator.size();
            afterDriveSeparator = (IntProgression)RangesKt.until((int)n13, (int)Math.min(n14, n15));
            int result$iv = 0;
            void v15 = $receiver$iv2;
            int $receiver$iv4 = v15.getFirst();
            int result$iv3 = v15.getLast();
            int n16 = v15.getStep();
            int n17 = $receiver$iv4;
            int n18 = result$iv3;
            if (n16 > 0 ? n17 <= n18 : n17 >= n18) {
                while (true) {
                    void item$iv;
                    void it;
                    if (Intrinsics.areEqual((Object)segments.get((int)(it = item$iv)), (Object)otherSegments.get((int)it)) ^ true) {
                        n = result$iv;
                        break block23;
                    }
                    ++result$iv;
                    if (item$iv == result$iv3) break;
                    item$iv += n16;
                }
            }
            n = result$iv;
        }
        int commonPrefixLength = n;
        Iterable item$iv = $receiver$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)segments.size());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int $i$a$1$countUntil = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            String string = "..";
            collection.add(string);
        }
        $receiver$iv = (Iterable)RangesKt.until((int)commonPrefixLength, (int)otherSegments.size());
        Collection collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            int it = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection2 = destination$iv$iv;
            String string = otherSegments.get(it);
            collection2.add(string);
        }
        List list = (List)destination$iv$iv;
        List newSegments = CollectionsKt.plus((Collection)collection, (Iterable)list);
        String sepString = "" + other.separator;
        String finalString = CollectionsKt.joinToString$default((Iterable)newSegments, (CharSequence)sepString, null, null, (int)0, null, null, (int)62, null) + (other.hasTrailingSeparator() && !newSegments.isEmpty() ? sepString : "");
        return new PathString(this.filesystemUri, finalString, 0, finalString.length(), 0, this.separator);
    }

    @JvmName(name="isEmptyPath")
    public final boolean isEmptyPath() {
        return this.prefixEndIndex == 0 && this.startIndex == this.suffixEndIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PathString resolve(@NotNull PathString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        PathString otherRoot = other.getRoot();
        if (this.isEmptyPath()) {
            return other;
        }
        if (other.isAbsolute()) {
            if (otherRoot != null && otherRoot.prefixEndIndex == 1) {
                int n;
                String $receiver$iv;
                int n2;
                block12: {
                    IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.prefixEndIndex)));
                    n2 = this.prefixEndIndex;
                    int result$iv = 0;
                    void v0 = $receiver$iv;
                    int n3 = v0.getFirst();
                    int n4 = v0.getLast();
                    int n5 = v0.getStep();
                    int n6 = n3;
                    int n7 = n4;
                    if (n5 > 0 ? n6 <= n7 : n6 >= n7) {
                        while (true) {
                            void item$iv;
                            void it;
                            if (this.path.charAt((int)(it = item$iv)) == ':') {
                                n = result$iv;
                                break block12;
                            }
                            ++result$iv;
                            if (item$iv == n4) break;
                            item$iv += n5;
                        }
                    }
                    n = result$iv;
                }
                int n8 = n;
                int indexOfDriveSeparator = n2 - n8;
                if (indexOfDriveSeparator > 0) {
                    PathString pathString;
                    $receiver$iv = this.path;
                    int n9 = 0;
                    StringBuilder stringBuilder = new StringBuilder();
                    URI uRI = this.filesystemUri;
                    PathString pathString2 = pathString;
                    PathString pathString3 = pathString;
                    String string = $receiver$iv;
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = string.substring(n9, indexOfDriveSeparator);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string3 = string2;
                    pathString2(uRI, stringBuilder.append(string3).append(PathStringUtil.access$withSeparator(other.getRawPath(), this.separator)).toString(), indexOfDriveSeparator + 1);
                    return pathString3;
                }
            }
            return other;
        }
        if (otherRoot != null && !this.compatibleRoots(this.getRoot(), otherRoot)) {
            return other;
        }
        if (other.isEmptyPath() || other.startIndex == other.suffixEndIndex) {
            return this;
        }
        String $receiver$iv = other.path;
        int n = other.startIndex;
        int n10 = other.suffixEndIndex;
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string.substring(n, n10);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String otherRelPath = PathStringUtil.access$withSeparator(string4, this.separator);
        String path = this.getRawPath();
        if (this.startIndex < this.suffixEndIndex && !PathStringUtil.access$isSeparator(path.charAt(this.suffixEndIndex - 1))) {
            path = path + this.separator;
        }
        path = path + otherRelPath;
        return new PathString(this.filesystemUri, path, this.prefixEndIndex, path.length(), this.prefixEndIndex, this.separator);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull PathString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int schemeResult = this.filesystemUri.compareTo(other.filesystemUri);
        if (schemeResult != 0) {
            return schemeResult;
        }
        int otherPrefixEndIndex = other.prefixEndIndex;
        int n = 0;
        int n2 = Math.min(otherPrefixEndIndex, this.prefixEndIndex);
        while (n < n2) {
            void i;
            int cmpResult = Intrinsics.compare((int)this.path.charAt((int)i), (int)other.path.charAt((int)i));
            if (cmpResult != 0) {
                return cmpResult;
            }
            ++i;
        }
        if (otherPrefixEndIndex != this.prefixEndIndex) {
            return Intrinsics.compare((int)this.prefixEndIndex, (int)otherPrefixEndIndex);
        }
        int length = this.suffixEndIndex - this.startIndex;
        int otherLength = other.suffixEndIndex - other.startIndex;
        int min = Math.min(length, otherLength);
        int n3 = 0;
        int n4 = min;
        while (n3 < n4) {
            void i;
            int cmpResult = Intrinsics.compare((int)this.path.charAt(this.startIndex + i), (int)other.path.charAt(other.startIndex + i));
            if (cmpResult != 0) {
                return cmpResult;
            }
            ++i;
        }
        return Intrinsics.compare((int)length, (int)otherLength);
    }

    private final boolean compatibleRoots(PathString root1, PathString root2) {
        if (Intrinsics.areEqual((Object)root1, (Object)root2)) {
            return true;
        }
        if (root1 == null || root2 == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.driveName(root1.getRawPath()), (Object)this.driveName(root2.getRawPath()));
    }

    private final String driveName(String rawPath) {
        String string = rawPath;
        int n = 0;
        int n2 = PathStringUtil.countUntil$default(rawPath, ':', 0, false, 6, null);
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        return string5;
    }

    /*
     * WARNING - void declaration
     */
    private final PathString subRangeOrNull(int index, int length) {
        int n;
        int lengthCount;
        int subRangeStart;
        int n2;
        int n3;
        block14: {
            void $receiver$iv;
            int n4;
            int n5;
            int n6;
            block13: {
                void $receiver$iv2;
                if (index < 0 || length < 0) {
                    return null;
                }
                if (length == 0) {
                    return new PathString(this.filesystemUri, "");
                }
                int separatorCount = 0;
                IntProgression intProgression = (IntProgression)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
                n3 = this.startIndex;
                int result$iv = 0;
                void v0 = $receiver$iv2;
                int n7 = v0.getFirst();
                int n8 = v0.getLast();
                n6 = v0.getStep();
                int n9 = n7;
                int n10 = n8;
                if (n6 > 0 ? n9 <= n10 : n9 >= n10) {
                    while (true) {
                        void item$iv;
                        void it;
                        if (PathStringUtil.access$isSeparator(this.path.charAt((int)(it = item$iv)))) {
                            n5 = separatorCount;
                            separatorCount = n5 + 1;
                        }
                        if (separatorCount >= index) {
                            n4 = result$iv;
                            break block13;
                        }
                        ++result$iv;
                        if (item$iv == n8) break;
                        item$iv += n6;
                    }
                }
                n4 = result$iv;
            }
            n2 = n4;
            subRangeStart = n3 + n2;
            if (subRangeStart >= this.getEndIndex() - 1) {
                return null;
            }
            if (PathStringUtil.access$isSeparator(this.path.charAt(subRangeStart))) {
                ++subRangeStart;
            }
            lengthCount = 0;
            IntProgression item$iv = (IntProgression)RangesKt.until((int)subRangeStart, (int)this.getEndIndex());
            n3 = subRangeStart;
            int result$iv = 0;
            void v4 = $receiver$iv;
            n6 = v4.getFirst();
            int n11 = v4.getLast();
            n5 = v4.getStep();
            int n12 = n6;
            int n13 = n11;
            if (n5 > 0 ? n12 <= n13 : n12 >= n13) {
                while (true) {
                    void item$iv2;
                    void it;
                    if (PathStringUtil.access$isSeparator(this.path.charAt((int)(it = item$iv2)))) {
                        int n14 = lengthCount;
                        lengthCount = n14 + 1;
                    }
                    if (lengthCount >= length) {
                        n = result$iv;
                        break block14;
                    }
                    ++result$iv;
                    if (item$iv2 == n11) break;
                    item$iv2 += n5;
                }
            }
            n = result$iv;
        }
        n2 = n;
        int subRangeEnd = n3 + n2;
        if (lengthCount < length - 1) {
            return null;
        }
        return new PathString(this.filesystemUri, this.path, subRangeStart, subRangeEnd, 0, this.separator);
    }

    static /* bridge */ /* synthetic */ PathString subRangeOrNull$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRangeOrNull(n, n2);
    }

    private final PathString subRange(int index, int length) {
        PathString pathString = this.subRangeOrNull(index, length);
        if (pathString == null) {
            throw (Throwable)new IllegalArgumentException("beginIndex " + index + " and suffixEndIndex " + (index + length) + " are out of range for path " + this.toString());
        }
        return pathString;
    }

    static /* bridge */ /* synthetic */ PathString subRange$default(PathString pathString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return pathString.subRange(n, n2);
    }

    private final int getEndIndex() {
        return this.hasTrailingSeparator() ? this.suffixEndIndex - 1 : this.suffixEndIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final int computeNameStart(int end) {
        int n;
        int n2;
        block3: {
            void var3_4;
            void $receiver$iv;
            IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)this.startIndex, (int)end)));
            n2 = end;
            int result$iv = 0;
            void v0 = $receiver$iv;
            int n3 = v0.getFirst();
            int n4 = v0.getLast();
            int n5 = v0.getStep();
            int n6 = n3;
            int n7 = n4;
            if (n5 > 0 ? n6 <= n7 : n6 >= n7) {
                while (true) {
                    void item$iv;
                    void it;
                    if (PathStringUtil.access$isSeparator(this.path.charAt((int)(it = item$iv)))) {
                        n = result$iv;
                        break block3;
                    }
                    ++result$iv;
                    if (item$iv == n4) break;
                    item$iv += n5;
                }
            }
            n = var3_4;
        }
        void var11_9 = n;
        return n2 - var11_9;
    }

    private final List<String> getSegments() {
        ArrayList<String> result = new ArrayList<String>();
        int lastSegment = this.startIndex;
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)this.startIndex, (int)this.getEndIndex());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            int element$iv = ((IntIterator)iterator).nextInt();
            int it = element$iv;
            if (!PathStringUtil.access$isSeparator(this.path.charAt(it))) continue;
            String string2 = this.path;
            int n = lastSegment;
            ArrayList<String> arrayList = result;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n, it), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            arrayList.add(string);
            lastSegment = it + 1;
        }
        if (lastSegment < this.getEndIndex()) {
            String string = this.path;
            int n = lastSegment;
            int n2 = this.getEndIndex();
            ArrayList<String> arrayList = result;
            String string4 = string;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string6 = string5;
            arrayList.add(string6);
        }
        return result;
    }

    @NotNull
    public final URI getFilesystemUri() {
        return this.filesystemUri;
    }

    private PathString(URI filesystemUri, String path, int startIndex, int suffixEndIndex, int prefixEndIndex, char separator) {
        this.filesystemUri = filesystemUri;
        this.path = path;
        this.startIndex = startIndex;
        this.suffixEndIndex = suffixEndIndex;
        this.prefixEndIndex = prefixEndIndex;
        this.separator = separator;
    }

    /* synthetic */ PathString(URI uRI, String string, int n, int n2, int n3, char c, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(uRI, string, n, n2, n3, c);
    }

    private PathString(URI filesystem, String path, int rootLength) {
        this(filesystem, path, rootLength, path.length(), rootLength, PathStringUtil.access$detectSeparator(path));
    }

    public PathString(@NotNull URI filesystemUri, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)filesystemUri, (String)"filesystemUri");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(filesystemUri, path, PathStringUtil.access$prefixLength(path));
    }

    public PathString(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(PathStringUtil.getDefaultFilesystemUri(), path);
    }

    public PathString(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        URI uRI = PathStringUtil.getDefaultFilesystemUri();
        String string = path.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path.path");
        this(uRI, string);
    }

    public PathString(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileSystem fileSystem = path.getFileSystem();
        FileSystem fileSystem2 = path.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem2, (String)"path.fileSystem");
        URI uRI = fileSystem.getPath(fileSystem2.getSeparator(), new String[0]).toUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"path.fileSystem.getPath(\u2026System.separator).toUri()");
        this(uRI, ((Object)path).toString());
    }
}

