/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import java.util.Objects;

public final class IdeFilterData
extends IdeModel
implements FilterData {
    private static final long serialVersionUID = 1L;
    private final String myIdentifier;
    private final String myFilterType;
    private final int myHashCode;

    public IdeFilterData(FilterData data, ModelCache modelCache) {
        super(data, modelCache);
        this.myIdentifier = data.getIdentifier();
        this.myFilterType = data.getFilterType();
        this.myHashCode = this.calculateHashCode();
    }

    public String getIdentifier() {
        return this.myIdentifier;
    }

    public String getFilterType() {
        return this.myFilterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeFilterData)) {
            return false;
        }
        IdeFilterData data = (IdeFilterData)o;
        return Objects.equals(this.myIdentifier, data.myIdentifier) && Objects.equals(this.myFilterType, data.myFilterType);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myIdentifier, this.myFilterType);
    }

    public String toString() {
        return "IdeFilterData{myIdentifier='" + this.myIdentifier + '\'' + ", myFilterType='" + this.myFilterType + '\'' + "}";
    }
}

