/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantAbi;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeArtifact;
import com.android.ide.common.gradle.model.IdeNativeSettings;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IdeNativeVariantAbi
extends IdeModel
implements NativeVariantAbi {
    private static final long serialVersionUID = 1L;
    private final List<File> myBuildFiles;
    private final Collection<NativeArtifact> myArtifacts;
    private final Collection<NativeToolchain> myToolChains;
    private final Collection<NativeSettings> mySettings;
    private final Map<String, String> myFileExtensions;
    private final int myHashCode;

    public IdeNativeVariantAbi(NativeVariantAbi variantAbi) {
        this(variantAbi, new ModelCache());
    }

    public IdeNativeVariantAbi(NativeVariantAbi variantAbi, ModelCache modelCache) {
        super(variantAbi, modelCache);
        this.myBuildFiles = ImmutableList.copyOf((Collection)variantAbi.getBuildFiles());
        this.myArtifacts = IdeNativeVariantAbi.copy(variantAbi.getArtifacts(), modelCache, (K artifact) -> new IdeNativeArtifact((NativeArtifact)artifact, modelCache));
        this.myToolChains = IdeNativeVariantAbi.copy(variantAbi.getToolChains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySettings = IdeNativeVariantAbi.copy(variantAbi.getSettings(), modelCache, (K settings) -> new IdeNativeSettings((NativeSettings)settings, modelCache));
        this.myFileExtensions = ImmutableMap.copyOf((Map)variantAbi.getFileExtensions());
        this.myHashCode = this.calculateHashCode();
    }

    public Collection<File> getBuildFiles() {
        return this.myBuildFiles;
    }

    public Collection<NativeArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    public Collection<NativeToolchain> getToolChains() {
        return this.myToolChains;
    }

    public Collection<NativeSettings> getSettings() {
        return this.mySettings;
    }

    public Map<String, String> getFileExtensions() {
        return this.myFileExtensions;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myBuildFiles, this.myArtifacts, this.myToolChains, this.mySettings, this.myFileExtensions);
    }

    public String toString() {
        return "IdeNativeVariantAbi{myBuildFiles=" + this.myBuildFiles + ", myArtifacts=" + this.myArtifacts + ", myToolChains=" + this.myToolChains + ", mySettings=" + this.mySettings + ", myFileExtensions=" + this.myFileExtensions + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeVariantAbi)) {
            return false;
        }
        IdeNativeVariantAbi that = (IdeNativeVariantAbi)o;
        return Objects.equals(this.myBuildFiles, that.myBuildFiles) && Objects.equals(this.myArtifacts, that.myArtifacts) && Objects.equals(this.myToolChains, that.myToolChains) && Objects.equals(this.mySettings, that.mySettings) && Objects.equals(this.myFileExtensions, that.myFileExtensions);
    }
}

