/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ArrayResourceValueImpl;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValueImpl;
import com.android.ide.common.rendering.api.PluralsResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValueImpl;
import com.android.ide.common.rendering.api.StyleableResourceValueImpl;
import com.android.ide.common.rendering.api.TextResourceValueImpl;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataItem;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.utils.HashCodes;
import com.android.utils.XmlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMergerItem
extends DataItem<ResourceFile>
implements Comparable<ResourceMergerItem>,
ResourceItem {
    public static final String ATTR_DESCRIPTION = "_description";
    public static final String ATTR_GROUP_NAME = "_groupName";
    private final ResourceType mType;
    private final ResourceNamespace mNamespace;
    private Node mValue;
    private String mLibraryName;
    protected ResourceValue mResourceValue;
    private boolean mIgnoredFromDiskMerge = false;

    public ResourceMergerItem(String name, ResourceNamespace namespace, ResourceType type, Node value, String libraryName) {
        super(name);
        Preconditions.checkArgument((type == ResourceType.PUBLIC || !name.isEmpty() ? 1 : 0) != 0, (Object)"Resource name cannot be empty.");
        this.mNamespace = namespace;
        this.mType = type;
        this.mValue = value;
        this.mLibraryName = libraryName;
    }

    @Override
    public ResourceType getType() {
        return this.mType;
    }

    public Node getValue() {
        return this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueText() {
        if (this.mValue == null) {
            return null;
        }
        Document document = this.mValue.getOwnerDocument();
        synchronized (document) {
            return this.mValue.getTextContent();
        }
    }

    @Override
    public String getLibraryName() {
        return this.mLibraryName;
    }

    @Override
    public ResourceNamespace getNamespace() {
        return this.mNamespace;
    }

    public String getQualifiers() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getQualifier on " + this.toString());
        }
        return resourceFile.getQualifiers();
    }

    public DataFile.FileType getSourceType() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getSourceType on " + this.toString());
        }
        return resourceFile.getType();
    }

    @Override
    public ResourceReference getReferenceToSelf() {
        return new ResourceReference(this.mNamespace, this.mType, this.getName());
    }

    void setValue(ResourceMergerItem from) {
        this.mValue = from.mValue;
        this.setTouched();
    }

    @Override
    public FolderConfiguration getConfiguration() {
        ResourceFile resourceFile = (ResourceFile)this.getSourceFile();
        if (resourceFile == null) {
            throw new RuntimeException("Cannot call getConfiguration on " + this.toString());
        }
        return resourceFile.getFolderConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKey() {
        if (this.getSourceFile() == null) {
            throw new IllegalStateException("ResourceItem.getKey called on object with no ResourceFile: " + this);
        }
        String qualifiers = this.getQualifiers();
        String typeName = this.mType.getName();
        if (this.mType == ResourceType.PUBLIC && this.mValue != null) {
            String typeAttribute;
            Document document = this.mValue.getOwnerDocument();
            synchronized (document) {
                typeAttribute = ((Element)this.mValue).getAttribute("type");
            }
            if (typeAttribute != null) {
                typeName = typeName + "_" + typeAttribute;
            }
        }
        if (!qualifiers.isEmpty()) {
            return typeName + "-" + qualifiers + "/" + this.getName();
        }
        return typeName + "/" + this.getName();
    }

    @Override
    protected void wasTouched() {
        this.mResourceValue = null;
    }

    @Override
    public ResourceValue getResourceValue() {
        if (this.mResourceValue == null) {
            if (this.mValue == null) {
                Density density = this.mType == ResourceType.DRAWABLE || this.mType == ResourceType.MIPMAP ? this.getFolderDensity() : null;
                ResourceFile source = (ResourceFile)this.getSourceFile();
                assert (source != null);
                this.mResourceValue = density != null ? new DensityBasedResourceValueImpl(this.mNamespace, this.mType, this.getName(), source.getFile().getAbsolutePath(), density, this.mLibraryName) : new ResourceValueImpl(this.mNamespace, this.mType, this.getName(), source.getFile().getAbsolutePath(), this.mLibraryName);
            } else {
                this.mResourceValue = this.parseXmlToResourceValue();
            }
        }
        return this.mResourceValue;
    }

    @Override
    public PathString getSource() {
        File file = this.getFile();
        return file == null ? null : new PathString(file);
    }

    @Override
    public boolean isFileBased() {
        return this.getSourceType() != DataFile.FileType.XML_VALUES;
    }

    private Density getFolderDensity() {
        DensityQualifier densityQualifier;
        Iterable segments;
        FolderConfiguration config;
        String qualifiers = this.getQualifiers();
        if (!qualifiers.isEmpty() && qualifiers.contains("dpi") && (config = FolderConfiguration.getConfigFromQualifiers(segments = Splitter.on((char)'-').split((CharSequence)qualifiers))) != null && (densityQualifier = config.getDensityQualifier()) != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    public String getXmlString(ResourceType type, boolean system) {
        if (type == ResourceType.ID) {
            return (system ? "@android:+id/" : "@+id/") + "/" + this.getName();
        }
        return (system ? "@android:" : "@") + type.getName() + "/" + this.getName();
    }

    public boolean compareValueWith(ResourceMergerItem resource) {
        if (this.mValue != null && resource.mValue != null) {
            return NodeUtils.compareElementNode(this.mValue, resource.mValue, true);
        }
        return this.mValue == resource.mValue;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("namespace", (Object)this.getNamespace()).add("type", (Object)this.getType()).add("status", this.getStatus()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMergerItem other = (ResourceMergerItem)o;
        return this.mType == other.mType && this.mNamespace.equals((Object)other.mNamespace);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)this.mType.hashCode(), (int)this.mNamespace.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceValue parseXmlToResourceValue() {
        ResourceValue value;
        assert (this.mValue != null);
        Document document = this.mValue.getOwnerDocument();
        if (document == null) {
            value = this.doParseXmlToResourceValue();
        } else {
            Document document2 = document;
            synchronized (document2) {
                value = this.doParseXmlToResourceValue();
            }
        }
        value.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(this.mValue));
        return value;
    }

    private ResourceValue doParseXmlToResourceValue() {
        final NamedNodeMap attributes = this.mValue.getAttributes();
        switch (this.mType) {
            case STYLE: {
                String parent = ResourceMergerItem.getAttributeValue(attributes, "parent");
                return this.parseStyleValue(new StyleResourceValueImpl(this.mNamespace, this.mType, this.getName(), parent, this.mLibraryName));
            }
            case STYLEABLE: {
                return this.parseDeclareStyleable(new StyleableResourceValueImpl(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName));
            }
            case ARRAY: {
                ArrayResourceValueImpl arrayValue = new ArrayResourceValueImpl(this.mNamespace, this.mType, this.getName(), this.mLibraryName){

                    protected int getDefaultIndex() {
                        String toolsDefaultIndex = ResourceMergerItem.getAttributeValueNS(attributes, "http://schemas.android.com/tools", "index");
                        if (toolsDefaultIndex != null) {
                            try {
                                return Integer.parseInt(toolsDefaultIndex);
                            }
                            catch (NumberFormatException e) {
                                return super.getDefaultIndex();
                            }
                        }
                        return super.getDefaultIndex();
                    }
                };
                return this.parseArrayValue(arrayValue);
            }
            case PLURALS: {
                PluralsResourceValueImpl pluralsResourceValue = new PluralsResourceValueImpl(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName){

                    public String getValue() {
                        String value;
                        String quantity = ResourceMergerItem.getAttributeValueNS(attributes, "http://schemas.android.com/tools", "quantity");
                        if (quantity != null && (value = this.getValue(quantity)) != null) {
                            return value;
                        }
                        return super.getValue();
                    }
                };
                return this.parsePluralsValue(pluralsResourceValue);
            }
            case ATTR: {
                return this.parseAttrValue(new AttrResourceValueImpl(this.mNamespace, this.mType, this.getName(), this.mLibraryName));
            }
            case STRING: {
                return this.parseTextValue(new TextResourceValueImpl(this.mNamespace, this.mType, this.getName(), null, null, this.mLibraryName));
            }
            case ANIMATOR: 
            case DRAWABLE: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case TRANSITION: {
                return this.parseFileName(new ResourceValueImpl(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName));
            }
        }
        return this.parseValue(new ResourceValueImpl(this.mNamespace, this.mType, this.getName(), null, this.mLibraryName));
    }

    private static ResourceNamespace.Resolver getNamespaceResolver(final Node node) {
        return new ResourceNamespace.Resolver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String uriToPrefix(String namespaceUri) {
                Document document = node.getOwnerDocument();
                if (document == null) {
                    return node.lookupPrefix(namespaceUri);
                }
                Document document2 = document;
                synchronized (document2) {
                    return node.lookupPrefix(namespaceUri);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String prefixToUri(String namespacePrefix) {
                Document document = node.getOwnerDocument();
                if (document == null) {
                    return node.lookupNamespaceURI(namespacePrefix);
                }
                Document document2 = document;
                synchronized (document2) {
                    return node.lookupNamespaceURI(namespacePrefix);
                }
            }
        };
    }

    private static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        Attr attribute = (Attr)attributes.getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private static String getAttributeValueNS(NamedNodeMap attributes, String namespaceUri, String attributeName) {
        Attr attribute = (Attr)attributes.getNamedItemNS(namespaceUri, attributeName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private StyleResourceValueImpl parseStyleValue(StyleResourceValueImpl styleValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String attributeUrl;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || Strings.isNullOrEmpty((String)(attributeUrl = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "name")))) continue;
            StyleItemResourceValueImpl resValue = new StyleItemResourceValueImpl(styleValue.getNamespace(), attributeUrl, ValueXmlHelper.unescapeResourceString(ResourceMergerItem.getTextNode(child.getChildNodes()), false, true), styleValue.getLibraryName());
            resValue.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(child));
            styleValue.addItem((StyleItemResourceValue)resValue);
        }
        return styleValue;
    }

    private AttrResourceValueImpl parseAttrValue(AttrResourceValueImpl attrValue) {
        return ResourceMergerItem.parseAttrValue(this.mValue, attrValue);
    }

    private static AttrResourceValueImpl parseAttrValue(Node valueNode, AttrResourceValueImpl attrValue) {
        NamedNodeMap attributes = valueNode.getAttributes();
        String description = ResourceMergerItem.getDescription(valueNode);
        attrValue.setDescription(description);
        String groupName = ResourceMergerItem.getAttributeValue(attributes, ATTR_GROUP_NAME);
        if (groupName != null) {
            attrValue.setGroupName(groupName);
        }
        EnumSet<AttributeFormat> formats = EnumSet.noneOf(AttributeFormat.class);
        String formatString = ResourceMergerItem.getAttributeValue(attributes, "format");
        if (formatString != null) {
            formats.addAll(AttributeFormat.parse((String)formatString));
        }
        NodeList children = valueNode.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tagName = ((Element)child).getTagName();
            if ("enum".equals(tagName)) {
                formats.add(AttributeFormat.ENUM);
            } else if ("flag".equals(tagName)) {
                formats.add(AttributeFormat.FLAGS);
            }
            NamedNodeMap childAttributes = child.getAttributes();
            String name = ResourceMergerItem.getAttributeValue(childAttributes, "name");
            if (name == null) continue;
            description = ResourceMergerItem.getDescription(child);
            Integer numericValue = null;
            String value = ResourceMergerItem.getAttributeValue(childAttributes, "value");
            if (value != null) {
                try {
                    numericValue = Long.decode(value).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            attrValue.addValue(name, numericValue, description);
        }
        attrValue.setFormats(formats);
        return attrValue;
    }

    private static String getDescription(Node node) {
        String description = ResourceMergerItem.getAttributeValue(node.getAttributes(), ATTR_DESCRIPTION);
        if (description == null) {
            description = XmlUtils.getPreviousCommentText((Node)node);
        }
        return description;
    }

    private ArrayResourceValueImpl parseArrayValue(ArrayResourceValueImpl arrayValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String text = ResourceMergerItem.getTextNode(child.getChildNodes());
            if ((text = ValueXmlHelper.unescapeResourceString(text, false, true)) == null) continue;
            arrayValue.addElement(text);
        }
        return arrayValue;
    }

    private PluralsResourceValueImpl parsePluralsValue(PluralsResourceValueImpl value) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String quantity;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (quantity = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "quantity")) == null) continue;
            String text = ResourceMergerItem.getTextNode(child.getChildNodes());
            text = ValueXmlHelper.unescapeResourceString(text, false, true);
            value.addPlural(quantity, text);
        }
        return value;
    }

    private StyleableResourceValueImpl parseDeclareStyleable(StyleableResourceValueImpl declareStyleable) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceMergerItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null) continue;
            ResourceNamespace namespace = declareStyleable.getNamespace();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                namespace = ResourceNamespace.ANDROID;
            }
            AttrResourceValueImpl attr = ResourceMergerItem.parseAttrValue(child, new AttrResourceValueImpl(namespace, ResourceType.ATTR, name, this.mLibraryName));
            attr.setNamespaceResolver(ResourceMergerItem.getNamespaceResolver(child));
            declareStyleable.addValue((AttrResourceValue)attr);
        }
        return declareStyleable;
    }

    private ResourceValueImpl parseValue(ResourceValueImpl value) {
        String text = ResourceMergerItem.getTextNode(this.mValue.getChildNodes());
        value.setValue(ValueXmlHelper.unescapeResourceString(text, false, true));
        return value;
    }

    private ResourceValueImpl parseFileName(ResourceValueImpl value) {
        String text = ResourceMergerItem.getTextNode(this.mValue.getChildNodes()).trim();
        if (!(text.isEmpty() || text.startsWith("@") || text.startsWith("?"))) {
            text = Paths.get(text, new String[0]).toString();
        }
        value.setValue(text);
        return value;
    }

    private static String getTextNode(NodeList children) {
        int n = children.getLength();
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)child;
                    if ("g".equals(element.getLocalName()) && element.getNamespaceURI() != null && element.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:document:")) {
                        if (element.hasAttribute("example")) {
                            String example = element.getAttribute("example");
                            sb.append('(').append(example).append(')');
                            continue block5;
                        }
                        if (element.hasAttribute("id")) {
                            String id = element.getAttribute("id");
                            sb.append('$').append('{').append(id).append('}');
                            continue block5;
                        }
                    }
                    NodeList childNodes = child.getChildNodes();
                    sb.append(ResourceMergerItem.getTextNode(childNodes));
                    continue block5;
                }
                case 3: {
                    sb.append(child.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append(child.getNodeValue());
                }
            }
        }
        return sb.toString();
    }

    private TextResourceValueImpl parseTextValue(TextResourceValueImpl value) {
        NodeList children = this.mValue.getChildNodes();
        String text = ResourceMergerItem.getTextNode(children);
        value.setValue(ValueXmlHelper.unescapeResourceString(text, false, true));
        int length = children.getLength();
        if (length >= 1) {
            boolean haveElementChildrenOrCdata = false;
            for (int i = 0; i < length; ++i) {
                if (children.item(i).getNodeType() != 1 && children.item(i).getNodeType() != 4) continue;
                haveElementChildrenOrCdata = true;
                break;
            }
            if (haveElementChildrenOrCdata) {
                String markupText = ResourceMergerItem.getMarkupText(children);
                value.setRawXmlValue(markupText);
            }
        }
        return value;
    }

    private static String getMarkupText(NodeList children) {
        StringBuilder sb = new StringBuilder();
        int n = children.getLength();
        block5: for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)child;
                    String tagName = element.getTagName();
                    sb.append('<');
                    sb.append(tagName);
                    NamedNodeMap attributes = element.getAttributes();
                    int attributeCount = attributes.getLength();
                    if (attributeCount > 0) {
                        for (int j = 0; j < attributeCount; ++j) {
                            Node attribute = attributes.item(j);
                            sb.append(' ');
                            sb.append(attribute.getNodeName());
                            sb.append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue((StringBuilder)sb, (String)attribute.getNodeValue());
                            sb.append('\"');
                        }
                    }
                    sb.append('>');
                    NodeList childNodes = child.getChildNodes();
                    if (childNodes.getLength() > 0) {
                        sb.append(ResourceMergerItem.getMarkupText(childNodes));
                    }
                    sb.append('<');
                    sb.append('/');
                    sb.append(tagName);
                    sb.append('>');
                    continue block5;
                }
                case 3: {
                    sb.append(child.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append("<![CDATA[");
                    sb.append(child.getNodeValue());
                    sb.append("]]>");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(ResourceMergerItem other) {
        int comp = this.mType.compareTo((Enum)other.mType);
        if (comp != 0) {
            return comp;
        }
        comp = this.mNamespace.compareTo(other.mNamespace);
        if (comp != 0) {
            return comp;
        }
        return this.getName().compareTo(other.getName());
    }

    public void setIgnoredFromDiskMerge(boolean ignored) {
        this.mIgnoredFromDiskMerge = ignored;
    }

    public boolean getIgnoredFromDiskMerge() {
        return this.mIgnoredFromDiskMerge;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, null, "type", this.mType.getName());
    }

    @Override
    Node getDetailsXml(Document document) {
        return NodeUtils.duplicateAndAdoptNode(document, this.mValue);
    }
}

