/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeLibraries;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.BuildFolderPaths;
import com.android.ide.common.gradle.model.level2.IdeAndroidLibrary;
import com.android.ide.common.gradle.model.level2.IdeJavaLibrary;
import com.android.ide.common.gradle.model.level2.IdeModuleLibrary;
import com.android.utils.FileUtils;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class IdeLibraryFactory {
    IdeLibraryFactory() {
    }

    Library create(Library library, ModelCache modelCache) {
        if (library.getType() == 1) {
            File folder = library.getFolder();
            return new IdeAndroidLibrary(library, modelCache, library.getArtifactAddress(), library.getFolder(), IdeLibraryFactory.getFullPath(folder, library.getManifest()), IdeLibraryFactory.getFullPath(folder, library.getJarFile()), IdeLibraryFactory.getFullPath(folder, (String)Preconditions.checkNotNull((Object)IdeLibraryFactory.defaultValueIfNotPresent(() -> ((Library)library).getCompileJarFile(), library.getJarFile()))), IdeLibraryFactory.getFullPath(folder, library.getResFolder()), library.getResStaticLibrary(), IdeLibraryFactory.getFullPath(folder, library.getAssetsFolder()), (Collection<String>)IdeLibraryFactory.getLocalJars(library, folder), IdeLibraryFactory.getFullPath(folder, library.getJniFolder()), IdeLibraryFactory.getFullPath(folder, library.getAidlFolder()), IdeLibraryFactory.getFullPath(folder, library.getRenderscriptFolder()), IdeLibraryFactory.getFullPath(folder, library.getProguardRules()), IdeLibraryFactory.getFullPath(folder, library.getLintJar()), IdeLibraryFactory.getFullPath(folder, library.getExternalAnnotations()), IdeLibraryFactory.getFullPath(folder, library.getPublicResources()), library.getArtifact(), library.getSymbolFile());
        }
        if (library.getType() == 2) {
            return new IdeJavaLibrary(library.getArtifactAddress(), library.getArtifact(), modelCache, library);
        }
        if (library.getType() == 3) {
            return new IdeModuleLibrary(library, library.getArtifactAddress(), modelCache);
        }
        throw new UnsupportedOperationException("Unknown library type " + library.getType());
    }

    private static ImmutableList<String> getLocalJars(Library library, File libraryFolderPath) {
        return (ImmutableList)library.getLocalJars().stream().map(jar -> IdeLibraryFactory.getFullPath(libraryFolderPath, jar)).collect(ImmutableCollectors.toImmutableList());
    }

    Library create(AndroidLibrary androidLibrary, BuildFolderPaths moduleBuildDirs, ModelCache modelCache) {
        if (androidLibrary.getProject() != null && !IdeLibraries.isLocalAarModule(androidLibrary, moduleBuildDirs)) {
            return new IdeModuleLibrary(androidLibrary, IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary), modelCache);
        }
        return new IdeAndroidLibrary(androidLibrary, modelCache, IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary), androidLibrary.getFolder(), androidLibrary.getManifest().getPath(), androidLibrary.getJarFile().getPath(), ((File)Preconditions.checkNotNull((Object)IdeLibraryFactory.defaultValueIfNotPresent(() -> ((AndroidLibrary)androidLibrary).getCompileJarFile(), androidLibrary.getJarFile()))).getPath(), androidLibrary.getResFolder().getPath(), IdeLibraryFactory.defaultValueIfNotPresent(() -> ((AndroidLibrary)androidLibrary).getResStaticLibrary(), null), androidLibrary.getAssetsFolder().getPath(), androidLibrary.getLocalJars().stream().map(File::getPath).collect(Collectors.toList()), androidLibrary.getJniFolder().getPath(), androidLibrary.getAidlFolder().getPath(), androidLibrary.getRenderscriptFolder().getPath(), androidLibrary.getProguardRules().getPath(), androidLibrary.getLintJar().getPath(), androidLibrary.getExternalAnnotations().getPath(), androidLibrary.getPublicResources().getPath(), androidLibrary.getBundle(), IdeLibraryFactory.getSymbolFilePath(androidLibrary));
    }

    private static String getFullPath(File libraryFolderPath, String fileName) {
        return FileUtils.join((File)libraryFolderPath, (String[])new String[]{fileName}).getPath();
    }

    private static String getSymbolFilePath(AndroidLibrary androidLibrary) {
        try {
            return androidLibrary.getSymbolFile().getPath();
        }
        catch (UnsupportedOperationException e) {
            return new File(androidLibrary.getFolder(), "R.txt").getPath();
        }
    }

    protected static <T> T defaultValueIfNotPresent(Supplier<T> propertyInvoker, T defaultValue) {
        try {
            return propertyInvoker.get();
        }
        catch (UnsupportedOperationException ignored) {
            return defaultValue;
        }
    }

    Library create(JavaLibrary javaLibrary, ModelCache modelCache) {
        String project = IdeLibraryFactory.getProject(javaLibrary);
        if (project != null) {
            return new IdeModuleLibrary(javaLibrary, IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary), modelCache);
        }
        return new IdeJavaLibrary(IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary), javaLibrary.getJarFile(), modelCache, javaLibrary);
    }

    private static String getProject(JavaLibrary javaLibrary) {
        try {
            return javaLibrary.getProject();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    static Library create(String projectPath, String artifactAddress, ModelCache modelCache, String buildId) {
        return new IdeModuleLibrary(projectPath, artifactAddress, modelCache, buildId);
    }
}

