/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u0001:\u0004\u001e\u001f !B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001d\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/android/ide/common/symbols/Symbol;", "", "()V", "canonicalName", "", "getCanonicalName", "()Ljava/lang/String;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "intValue", "", "getIntValue", "()I", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "name", "getName", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getValue", "AttributeSymbol", "Companion", "NormalSymbol", "StyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "sdk-common"})
public abstract class Symbol {
    @JvmField
    @NotNull
    public static final ImmutableList<String> NO_CHILDREN;
    public static final Companion Companion;

    @NotNull
    public abstract ResourceVisibility getResourceVisibility();

    @NotNull
    public abstract ResourceType getResourceType();

    @NotNull
    public abstract String getCanonicalName();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getValue();

    public abstract int getIntValue();

    @NotNull
    public abstract SymbolJavaType getJavaType();

    @NotNull
    public abstract ImmutableList<String> getChildren();

    private Symbol() {
    }

    static {
        Companion = new Companion(null);
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        NO_CHILDREN = immutableList;
    }

    public /* synthetic */ Symbol(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition) {
        return Companion.createAndValidateSymbol(resourceType, name, idProvider, isMaybeDefinition);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
        return com.android.ide.common.symbols.Symbol$Companion.createAndValidateSymbol$default(Companion, resourceType, name, idProvider, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition) {
        return Companion.createAndValidateSymbol(resourceType, name, value, isMaybeDefinition);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
        return com.android.ide.common.symbols.Symbol$Companion.createAndValidateSymbol$default(Companion, resourceType, name, value, false, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final StyleableSymbol createAndValidateStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children) {
        return Companion.createAndValidateStyleableSymbol(name, values, children);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J;\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\b\u0010'\u001a\u00020\u0005H\u0016J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001J\b\u0010)\u001a\u00020\u0005H\u0016R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "", "intValue", "", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "(Lcom/android/resources/ResourceType;Ljava/lang/String;ILcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getCanonicalName", "()Ljava/lang/String;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "getIntValue", "()I", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getName", "getResourceType", "()Lcom/android/resources/ResourceType;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getValue", "hashCode", "toString", "sdk-common"})
    public static final class NormalSymbol
    extends Symbol {
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final String name;
        private final int intValue;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return SymbolJavaType.INT;
        }

        @Override
        @NotNull
        public String getValue() {
            return "0x" + Integer.toHexString(this.getIntValue());
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            throw (Throwable)new UnsupportedOperationException("Only styleables have children.");
        }

        @NotNull
        public String toString() {
            int n = this.getIntValue();
            int n2 = 16;
            StringBuilder stringBuilder = new StringBuilder().append(this.getResourceVisibility()).append(' ').append(this.getResourceType()).append(' ').append(this.getCanonicalName()).append(" = 0x");
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string2 = string;
            return stringBuilder.append(string2).toString();
        }

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @JvmOverloads
        public NormalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            super(null);
            this.resourceType = resourceType;
            this.name = name;
            this.intValue = intValue;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
            Preconditions.checkArgument((this.getResourceType() != ResourceType.STYLEABLE ? 1 : 0) != 0, (String)"Internal Error: Styleables must be represented by StyleableSymbol.", (Object[])new Object[0]);
            Preconditions.checkArgument((this.getResourceType() != ResourceType.ATTR ? 1 : 0) != 0, (String)"Internal Error: Attributes must be represented by AttributeSymbol.", (Object[])new Object[0]);
        }

        @JvmOverloads
        public /* synthetic */ NormalSymbol(ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n2 & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            this(resourceType, string, n, resourceVisibility, string2);
        }

        @JvmOverloads
        public NormalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility) {
            this(resourceType, name, intValue, resourceVisibility, null, 16, null);
        }

        @JvmOverloads
        public NormalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue) {
            this(resourceType, name, intValue, null, null, 24, null);
        }

        @NotNull
        public final ResourceType component1() {
            return this.getResourceType();
        }

        @NotNull
        public final String component2() {
            return this.getName();
        }

        public final int component3() {
            return this.getIntValue();
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.getResourceVisibility();
        }

        @NotNull
        public final String component5() {
            return this.getCanonicalName();
        }

        @NotNull
        public final NormalSymbol copy(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            return new NormalSymbol(resourceType, name, intValue, resourceVisibility, canonicalName);
        }

        @NotNull
        public static /* synthetic */ NormalSymbol copy$default(NormalSymbol normalSymbol, ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                resourceType = normalSymbol.getResourceType();
            }
            if ((n2 & 2) != 0) {
                string = normalSymbol.getName();
            }
            if ((n2 & 4) != 0) {
                n = normalSymbol.getIntValue();
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = normalSymbol.getResourceVisibility();
            }
            if ((n2 & 0x10) != 0) {
                string2 = normalSymbol.getCanonicalName();
            }
            return normalSymbol.copy(resourceType, string, n, resourceVisibility, string2);
        }

        public int hashCode() {
            ResourceType resourceType = this.getResourceType();
            String string = this.getName();
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            String string2 = this.getCanonicalName();
            return ((((resourceType != null ? resourceType.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Integer.hashCode(this.getIntValue())) * 31 + (resourceVisibility != null ? resourceVisibility.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NormalSymbol)) break block3;
                    NormalSymbol normalSymbol = (NormalSymbol)object;
                    if (!Intrinsics.areEqual((Object)this.getResourceType(), (Object)normalSymbol.getResourceType()) || !Intrinsics.areEqual((Object)this.getName(), (Object)normalSymbol.getName()) || !(this.getIntValue() == normalSymbol.getIntValue()) || !Intrinsics.areEqual((Object)this.getResourceVisibility(), (Object)normalSymbol.getResourceVisibility()) || !Intrinsics.areEqual((Object)this.getCanonicalName(), (Object)normalSymbol.getCanonicalName())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J;\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00072\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\b\u0010*\u001a\u00020\u0003H\u0016J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\b\u0010,\u001a\u00020\u0003H\u0016R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "name", "", "intValue", "", "isMaybeDefinition", "", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "(Ljava/lang/String;IZLcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getCanonicalName", "()Ljava/lang/String;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "getIntValue", "()I", "()Z", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getName", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "typeWithMaybeDef", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "getValue", "hashCode", "toString", "sdk-common"})
    public static final class AttributeSymbol
    extends Symbol {
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final SymbolJavaType javaType;
        private final String typeWithMaybeDef;
        @NotNull
        private final String name;
        private final int intValue;
        private final boolean isMaybeDefinition;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return this.javaType;
        }

        @Override
        @NotNull
        public String getValue() {
            return "0x" + Integer.toHexString(this.getIntValue());
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            throw (Throwable)new UnsupportedOperationException("Attributes cannot have children.");
        }

        @NotNull
        public String toString() {
            int n = this.getIntValue();
            int n2 = 16;
            StringBuilder stringBuilder = new StringBuilder().append(this.getResourceVisibility()).append(' ').append(this.typeWithMaybeDef).append(' ').append(this.getCanonicalName()).append(" = 0x");
            String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string2 = string;
            return stringBuilder.append(string2).toString();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        public final boolean isMaybeDefinition() {
            return this.isMaybeDefinition;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @JvmOverloads
        public AttributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            super(null);
            this.name = name;
            this.intValue = intValue;
            this.isMaybeDefinition = isMaybeDefinition;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
            this.resourceType = ResourceType.ATTR;
            this.javaType = SymbolJavaType.INT;
            this.typeWithMaybeDef = this.getResourceType() + (this.isMaybeDefinition ? "?" : "");
        }

        @JvmOverloads
        public /* synthetic */ AttributeSymbol(String string, int n, boolean bl, ResourceVisibility resourceVisibility, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n2 & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            this(string, n, bl, resourceVisibility, string2);
        }

        @JvmOverloads
        public AttributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility) {
            this(name, intValue, isMaybeDefinition, resourceVisibility, null, 16, null);
        }

        @JvmOverloads
        public AttributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition) {
            this(name, intValue, isMaybeDefinition, null, null, 24, null);
        }

        @JvmOverloads
        public AttributeSymbol(@NotNull String name, int intValue) {
            this(name, intValue, false, null, null, 28, null);
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        public final int component2() {
            return this.getIntValue();
        }

        public final boolean component3() {
            return this.isMaybeDefinition;
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.getResourceVisibility();
        }

        @NotNull
        public final String component5() {
            return this.getCanonicalName();
        }

        @NotNull
        public final AttributeSymbol copy(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            return new AttributeSymbol(name, intValue, isMaybeDefinition, resourceVisibility, canonicalName);
        }

        @NotNull
        public static /* synthetic */ AttributeSymbol copy$default(AttributeSymbol attributeSymbol, String string, int n, boolean bl, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = attributeSymbol.getName();
            }
            if ((n2 & 2) != 0) {
                n = attributeSymbol.getIntValue();
            }
            if ((n2 & 4) != 0) {
                bl = attributeSymbol.isMaybeDefinition;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = attributeSymbol.getResourceVisibility();
            }
            if ((n2 & 0x10) != 0) {
                string2 = attributeSymbol.getCanonicalName();
            }
            return attributeSymbol.copy(string, n, bl, resourceVisibility, string2);
        }

        public int hashCode() {
            String string = this.getName();
            int n = ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.getIntValue())) * 31;
            int n2 = this.isMaybeDefinition ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            String string2 = this.getCanonicalName();
            return ((n + n2) * 31 + (resourceVisibility != null ? resourceVisibility.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AttributeSymbol)) break block3;
                    AttributeSymbol attributeSymbol = (AttributeSymbol)object;
                    if (!Intrinsics.areEqual((Object)this.getName(), (Object)attributeSymbol.getName()) || !(this.getIntValue() == attributeSymbol.getIntValue()) || !(this.isMaybeDefinition == attributeSymbol.isMaybeDefinition) || !Intrinsics.areEqual((Object)this.getResourceVisibility(), (Object)attributeSymbol.getResourceVisibility()) || !Intrinsics.areEqual((Object)this.getCanonicalName(), (Object)attributeSymbol.getCanonicalName())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003JG\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\b\u0010)\u001a\u00020\u0003H\u0016J\t\u0010*\u001a\u00020\u0006H\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "name", "", "values", "Lcom/google/common/collect/ImmutableList;", "", "children", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableList;Lcom/google/common/collect/ImmutableList;Lcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getCanonicalName", "()Ljava/lang/String;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "intValue", "getIntValue", "()I", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getName", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getValues", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getValue", "hashCode", "toString", "sdk-common"})
    public static final class StyleableSymbol
    extends Symbol {
        @NotNull
        private final String name;
        @NotNull
        private final ImmutableList<Integer> values;
        @NotNull
        private final ImmutableList<String> children;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return ResourceType.STYLEABLE;
        }

        @Override
        public int getIntValue() {
            throw (Throwable)new UnsupportedOperationException("Styleables have no int value");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getValue() {
            StringBuilder stringBuilder;
            StringBuilder $receiver = stringBuilder = new StringBuilder(this.values.size() * 12 + 2);
            boolean bl = false;
            $receiver.append("{ ");
            int n = 0;
            int n2 = this.values.size();
            while (n < n2) {
                void i;
                if (i != false) {
                    $receiver.append(", ");
                }
                $receiver.append("0x");
                Object object = this.values.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"values[i]");
                $receiver.append(Integer.toHexString(((Number)object).intValue()));
                ++i;
            }
            $receiver.append(" }");
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(values.siz\u2026             }.toString()");
            return string;
        }

        @Override
        @NotNull
        public SymbolJavaType getJavaType() {
            return SymbolJavaType.INT_LIST;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final ImmutableList<Integer> getValues() {
            return this.values;
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            return this.children;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @JvmOverloads
        public StyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            super(null);
            this.name = name;
            this.values = values;
            this.children = children;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
        }

        @JvmOverloads
        public /* synthetic */ StyleableSymbol(String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            this(string, (ImmutableList<Integer>)immutableList, (ImmutableList<String>)immutableList2, resourceVisibility, string2);
        }

        @JvmOverloads
        public StyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility) {
            this(name, values, children, resourceVisibility, null, 16, null);
        }

        @JvmOverloads
        public StyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children) {
            this(name, values, children, null, null, 24, null);
        }

        @NotNull
        public final String component1() {
            return this.getName();
        }

        @NotNull
        public final ImmutableList<Integer> component2() {
            return this.values;
        }

        @NotNull
        public final ImmutableList<String> component3() {
            return this.getChildren();
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.getResourceVisibility();
        }

        @NotNull
        public final String component5() {
            return this.getCanonicalName();
        }

        @NotNull
        public final StyleableSymbol copy(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            Intrinsics.checkParameterIsNotNull((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
            return new StyleableSymbol(name, values, children, resourceVisibility, canonicalName);
        }

        @NotNull
        public static /* synthetic */ StyleableSymbol copy$default(StyleableSymbol styleableSymbol, String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = styleableSymbol.getName();
            }
            if ((n & 2) != 0) {
                immutableList = styleableSymbol.values;
            }
            if ((n & 4) != 0) {
                immutableList2 = styleableSymbol.getChildren();
            }
            if ((n & 8) != 0) {
                resourceVisibility = styleableSymbol.getResourceVisibility();
            }
            if ((n & 0x10) != 0) {
                string2 = styleableSymbol.getCanonicalName();
            }
            return styleableSymbol.copy(string, immutableList, immutableList2, resourceVisibility, string2);
        }

        @NotNull
        public String toString() {
            return "StyleableSymbol(name=" + this.getName() + ", values=" + this.values + ", children=" + this.getChildren() + ", resourceVisibility=" + this.getResourceVisibility() + ", canonicalName=" + this.getCanonicalName() + ")";
        }

        public int hashCode() {
            String string = this.getName();
            ImmutableList<Integer> immutableList = this.values;
            ImmutableList<String> immutableList2 = this.getChildren();
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            String string2 = this.getCanonicalName();
            return ((((string != null ? string.hashCode() : 0) * 31 + (immutableList != null ? immutableList.hashCode() : 0)) * 31 + (immutableList2 != null ? immutableList2.hashCode() : 0)) * 31 + (resourceVisibility != null ? resourceVisibility.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StyleableSymbol)) break block3;
                    StyleableSymbol styleableSymbol = (StyleableSymbol)object;
                    if (!Intrinsics.areEqual((Object)this.getName(), (Object)styleableSymbol.getName()) || !Intrinsics.areEqual(this.values, styleableSymbol.values) || !Intrinsics.areEqual(this.getChildren(), styleableSymbol.getChildren()) || !Intrinsics.areEqual((Object)this.getResourceVisibility(), (Object)styleableSymbol.getResourceVisibility()) || !Intrinsics.areEqual((Object)this.getCanonicalName(), (Object)styleableSymbol.getCanonicalName())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0007J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/ide/common/symbols/Symbol$Companion;", "", "()V", "NO_CHILDREN", "Lcom/google/common/collect/ImmutableList;", "", "createAndValidateStyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "name", "values", "", "children", "", "createAndValidateSymbol", "Lcom/android/ide/common/symbols/Symbol;", "resourceType", "Lcom/android/resources/ResourceType;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "isMaybeDefinition", "", "value", "validateSymbol", "", "sdk-common"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
            return this.createAndValidateSymbol(resourceType, name, idProvider.next(resourceType), isMaybeDefinition);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* synthetic */ Symbol createAndValidateSymbol$default(Companion companion, ResourceType resourceType, String string, IdProvider idProvider, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.createAndValidateSymbol(resourceType, string, idProvider, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
            return com.android.ide.common.symbols.Symbol$Companion.createAndValidateSymbol$default(this, resourceType, name, idProvider, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.validateSymbol(name, resourceType);
            return resourceType == ResourceType.ATTR ? (Symbol)new AttributeSymbol(name, value, isMaybeDefinition, null, null, 24, null) : (Symbol)new NormalSymbol(resourceType, name, value, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* synthetic */ Symbol createAndValidateSymbol$default(Companion companion, ResourceType resourceType, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            return companion.createAndValidateSymbol(resourceType, string, n, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createAndValidateSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
            return com.android.ide.common.symbols.Symbol$Companion.createAndValidateSymbol$default(this, resourceType, name, value, false, 8, null);
        }

        @JvmStatic
        @NotNull
        public final StyleableSymbol createAndValidateStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(values, (String)"values");
            Intrinsics.checkParameterIsNotNull(children, (String)"children");
            this.validateSymbol(name, ResourceType.STYLEABLE);
            String string = SymbolUtils.canonicalizeValueResourceName(name);
            ImmutableList immutableList = ImmutableList.copyOf((Collection)children);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(children)");
            ImmutableList immutableList2 = immutableList;
            ResourceVisibility resourceVisibility = null;
            ImmutableList<Integer> immutableList3 = values;
            String string2 = string;
            return new StyleableSymbol(name, immutableList3, immutableList2, resourceVisibility, string2, 8, null);
        }

        @JvmStatic
        @NotNull
        public static /* synthetic */ StyleableSymbol createAndValidateStyleableSymbol$default(Companion companion, String string, ImmutableList immutableList, List list, int n, Object object) {
            if ((n & 4) != 0) {
                ImmutableList immutableList2 = ImmutableList.of();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"ImmutableList.of()");
                list = (List)immutableList2;
            }
            return companion.createAndValidateStyleableSymbol(string, (ImmutableList<Integer>)immutableList, list);
        }

        private final void validateSymbol(String name, ResourceType resourceType) {
            try {
                ValueResourceNameValidator.validate(name, resourceType, null);
            }
            catch (MergingException e) {
                throw (Throwable)new IllegalArgumentException("Validation of a resource with name '" + name + "' and type " + '\'' + resourceType.getName() + "' failed.'", e);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

