/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantInfo;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeArtifact;
import com.android.ide.common.gradle.model.IdeNativeSettings;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.IdeNativeVariantInfo;
import com.android.ide.common.gradle.model.ModelCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IdeNativeAndroidProjectImpl
extends IdeModel
implements IdeNativeAndroidProject {
    private static final long serialVersionUID = 1L;
    private final String myModelVersion;
    private final String myName;
    private final List<File> myBuildFiles;
    private final Map<String, NativeVariantInfo> myVariantInfos;
    private final Collection<NativeArtifact> myArtifacts;
    private final Collection<NativeToolchain> myToolChains;
    private final Collection<NativeSettings> mySettings;
    private final Map<String, String> myFileExtensions;
    private final Collection<String> myBuildSystems;
    private final int myApiVersion;
    private final int myHashCode;

    public IdeNativeAndroidProjectImpl(NativeAndroidProject project) {
        this(project, new ModelCache());
    }

    @VisibleForTesting
    IdeNativeAndroidProjectImpl(NativeAndroidProject project, ModelCache modelCache) {
        super(project, modelCache);
        this.myModelVersion = project.getModelVersion();
        this.myApiVersion = project.getApiVersion();
        this.myName = project.getName();
        this.myBuildFiles = ImmutableList.copyOf((Collection)project.getBuildFiles());
        this.myVariantInfos = IdeNativeAndroidProjectImpl.copyVariantInfos(project, modelCache);
        this.myArtifacts = IdeNativeAndroidProjectImpl.copy(project.getArtifacts(), modelCache, (K artifact) -> new IdeNativeArtifact((NativeArtifact)artifact, modelCache));
        this.myToolChains = IdeNativeAndroidProjectImpl.copy(project.getToolChains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySettings = IdeNativeAndroidProjectImpl.copy(project.getSettings(), modelCache, (K settings) -> new IdeNativeSettings((NativeSettings)settings, modelCache));
        this.myFileExtensions = ImmutableMap.copyOf((Map)project.getFileExtensions());
        this.myBuildSystems = IdeNativeAndroidProjectImpl.copyBuildSystems(project);
        this.myHashCode = this.calculateHashCode();
    }

    private static Map<String, NativeVariantInfo> copyVariantInfos(NativeAndroidProject project, ModelCache modelCache) {
        try {
            return IdeNativeAndroidProjectImpl.copy(project.getVariantInfos(), modelCache, (V variantInfo) -> new IdeNativeVariantInfo(variantInfo.getAbiNames(), variantInfo.getBuildRootFolderMap()));
        }
        catch (UnsupportedOperationException e) {
            return Maps.newHashMap();
        }
    }

    private static Collection<String> copyBuildSystems(NativeAndroidProject project) {
        try {
            return ImmutableList.copyOf((Collection)project.getBuildSystems());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public String getModelVersion() {
        return this.myModelVersion;
    }

    public int getApiVersion() {
        return this.myApiVersion;
    }

    public String getName() {
        return this.myName;
    }

    public Map<String, NativeVariantInfo> getVariantInfos() {
        return this.myVariantInfos;
    }

    public Collection<File> getBuildFiles() {
        return this.myBuildFiles;
    }

    public Collection<NativeArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    public Collection<NativeToolchain> getToolChains() {
        return this.myToolChains;
    }

    public Collection<NativeSettings> getSettings() {
        return this.mySettings;
    }

    public Map<String, String> getFileExtensions() {
        return this.myFileExtensions;
    }

    public Collection<String> getBuildSystems() {
        if (this.myBuildSystems != null) {
            return this.myBuildSystems;
        }
        throw new UnsupportedOperationException("Unsupported method: NativeAndroidProject.getBuildSystems()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeAndroidProjectImpl)) {
            return false;
        }
        IdeNativeAndroidProjectImpl project = (IdeNativeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myBuildFiles, project.myBuildFiles) && Objects.equals(this.myVariantInfos, project.myVariantInfos) && Objects.equals(this.myArtifacts, project.myArtifacts) && Objects.equals(this.myToolChains, project.myToolChains) && Objects.equals(this.mySettings, project.mySettings) && Objects.equals(this.myFileExtensions, project.myFileExtensions) && Objects.equals(this.myBuildSystems, project.myBuildSystems);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myName, this.myBuildFiles, this.myVariantInfos, this.myArtifacts, this.myToolChains, this.mySettings, this.myFileExtensions, this.myBuildSystems, this.myApiVersion);
    }

    public String toString() {
        return "IdeNativeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myBuildFiles=" + this.myBuildFiles + ", myArtifacts=" + this.myArtifacts + ", myToolChains=" + this.myToolChains + ", mySettings=" + this.mySettings + ", myFileExtensions=" + this.myFileExtensions + ", myBuildSystems=" + this.myBuildSystems + ", myApiVersion=" + this.myApiVersion + "}";
    }

    public static class FactoryImpl
    implements IdeNativeAndroidProject.Factory {
        @Override
        public IdeNativeAndroidProject create(NativeAndroidProject project) {
            return new IdeNativeAndroidProjectImpl(project);
        }
    }
}

