/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.ProjectSyncIssues;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.builder.model.ViewBindingOptions;
import com.android.ide.common.gradle.model.IdeAaptOptions;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeBuildTypeContainer;
import com.android.ide.common.gradle.model.IdeJavaCompileOptions;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeToolchain;
import com.android.ide.common.gradle.model.IdeProductFlavorContainer;
import com.android.ide.common.gradle.model.IdeSigningConfig;
import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.IdeVariantImpl;
import com.android.ide.common.gradle.model.IdeViewBindingOptions;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;

public final class IdeAndroidProjectImpl
extends IdeModel
implements IdeAndroidProject {
    private static final long serialVersionUID = 7L;
    private final String myModelVersion;
    private final String myName;
    private final ProductFlavorContainer myDefaultConfig;
    private final Collection<BuildTypeContainer> myBuildTypes;
    private final Collection<ProductFlavorContainer> myProductFlavors;
    private final Collection<SyncIssue> mySyncIssues;
    private final Collection<Variant> myVariants;
    private final Collection<String> myVariantNames;
    private final String myDefaultVariant;
    private final Collection<String> myFlavorDimensions;
    private final String myCompileTarget;
    private final Collection<String> myBootClassPath;
    private final Collection<NativeToolchain> myNativeToolchains;
    private final Collection<SigningConfig> mySigningConfigs;
    private final IdeLintOptions myLintOptions;
    private final Collection<String> myUnresolvedDependencies;
    private final JavaCompileOptions myJavaCompileOptions;
    private final AaptOptions myAaptOptions;
    private final File myBuildFolder;
    private final Collection<String> myDynamicFeatures;
    private final ViewBindingOptions myViewBindingOptions;
    private final GradleVersion myParsedModelVersion;
    private final String myBuildToolsVersion;
    private final String myResourcePrefix;
    private final String myGroupId;
    private final boolean mySupportsPluginGeneration;
    private final int myApiVersion;
    private final int myProjectType;
    private final boolean myBaseSplit;
    private final int myHashCode;

    public IdeAndroidProjectImpl(AndroidProject project, IdeDependenciesFactory dependenciesFactory, Collection<Variant> variants, ProjectSyncIssues syncIssues) {
        this(project, new ModelCache(), dependenciesFactory, variants, syncIssues);
    }

    @VisibleForTesting
    IdeAndroidProjectImpl(AndroidProject project, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, Collection<Variant> variants, ProjectSyncIssues syncIssues) {
        super(project, modelCache);
        this.myModelVersion = project.getModelVersion();
        this.myParsedModelVersion = GradleVersion.tryParse(this.myModelVersion);
        this.myName = project.getName();
        this.myDefaultConfig = modelCache.computeIfAbsent(project.getDefaultConfig(), container -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildTypes = IdeAndroidProjectImpl.copy(project.getBuildTypes(), modelCache, (K container) -> new IdeBuildTypeContainer((BuildTypeContainer)container, modelCache));
        this.myProductFlavors = IdeAndroidProjectImpl.copy(project.getProductFlavors(), modelCache, (K container) -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildToolsVersion = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getBuildToolsVersion(), null);
        Collection issues = syncIssues == null ? project.getSyncIssues() : syncIssues.getSyncIssues();
        this.mySyncIssues = new ArrayList<SyncIssue>(IdeAndroidProjectImpl.copy(issues, modelCache, (K issue) -> new IdeSyncIssue((SyncIssue)issue, modelCache)));
        Collection variantsToCopy = variants != null ? variants : project.getVariants();
        this.myVariants = new ArrayList<Variant>(IdeAndroidProjectImpl.copy(variantsToCopy, modelCache, (K variant) -> new IdeVariantImpl((Variant)variant, modelCache, dependenciesFactory, this.myParsedModelVersion)));
        this.myVariantNames = (Collection)Objects.requireNonNull(IdeAndroidProjectImpl.copyNewPropertyWithDefault(() -> ImmutableList.copyOf((Collection)project.getVariantNames()), () -> IdeAndroidProjectImpl.computeVariantNames(this.myVariants)));
        this.myDefaultVariant = IdeAndroidProjectImpl.copyNewPropertyWithDefault(() -> ((AndroidProject)project).getDefaultVariant(), () -> IdeAndroidProjectImpl.getDefaultVariant(this.myVariantNames));
        this.myFlavorDimensions = IdeAndroidProjectImpl.copyNewProperty(() -> ImmutableList.copyOf((Collection)project.getFlavorDimensions()), Collections.emptyList());
        this.myCompileTarget = project.getCompileTarget();
        this.myBootClassPath = ImmutableList.copyOf((Collection)project.getBootClasspath());
        this.myNativeToolchains = IdeAndroidProjectImpl.copy(project.getNativeToolchains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySigningConfigs = IdeAndroidProjectImpl.copy(project.getSigningConfigs(), modelCache, (K config) -> new IdeSigningConfig((SigningConfig)config, modelCache));
        this.myLintOptions = modelCache.computeIfAbsent(project.getLintOptions(), options -> new IdeLintOptions((LintOptions)options, modelCache, this.myParsedModelVersion));
        this.myUnresolvedDependencies = ImmutableSet.copyOf((Collection)project.getUnresolvedDependencies());
        this.myJavaCompileOptions = modelCache.computeIfAbsent(project.getJavaCompileOptions(), options -> new IdeJavaCompileOptions((JavaCompileOptions)options, modelCache));
        this.myAaptOptions = modelCache.computeIfAbsent(project.getAaptOptions(), options -> new IdeAaptOptions((AaptOptions)options, modelCache));
        this.myBuildFolder = project.getBuildFolder();
        this.myResourcePrefix = project.getResourcePrefix();
        this.myApiVersion = project.getApiVersion();
        this.myProjectType = IdeAndroidProjectImpl.getProjectType(project, this.myParsedModelVersion);
        this.mySupportsPluginGeneration = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getPluginGeneration(), null) != null;
        this.myBaseSplit = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).isBaseSplit(), false);
        this.myDynamicFeatures = ImmutableList.copyOf((Collection)((Collection)IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getDynamicFeatures(), ImmutableList.of())));
        this.myViewBindingOptions = IdeAndroidProjectImpl.copyNewProperty(() -> new IdeViewBindingOptions(project.getViewBindingOptions(), modelCache), null);
        this.myGroupId = this.myParsedModelVersion != null && this.myParsedModelVersion.isAtLeast(3, 6, 0, "alpha", 5, false) ? project.getGroupId() : null;
        this.myHashCode = this.calculateHashCode();
    }

    private static ImmutableList<String> computeVariantNames(Collection<Variant> variants) {
        return (ImmutableList)variants.stream().map(Variant::getName).collect(ImmutableList.toImmutableList());
    }

    private static int getProjectType(AndroidProject project, GradleVersion modelVersion) {
        if (modelVersion != null && modelVersion.isAtLeast(2, 3, 0)) {
            return project.getProjectType();
        }
        return project.isLibrary() ? 1 : 0;
    }

    @VisibleForTesting
    static String getDefaultVariant(Collection<String> variantNames) {
        if (variantNames.isEmpty()) {
            return null;
        }
        if (variantNames.contains("debug")) {
            return "debug";
        }
        ImmutableSortedSet sortedNames = ImmutableSortedSet.copyOf(variantNames);
        for (String variantName : sortedNames) {
            if (!variantName.endsWith("Debug")) continue;
            return variantName;
        }
        return (String)sortedNames.first();
    }

    @Override
    public GradleVersion getParsedModelVersion() {
        return this.myParsedModelVersion;
    }

    @Override
    public String getModelVersion() {
        return this.myModelVersion;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public ProductFlavorContainer getDefaultConfig() {
        return this.myDefaultConfig;
    }

    @Override
    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.myBuildTypes;
    }

    @Override
    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.myProductFlavors;
    }

    @Override
    public String getBuildToolsVersion() {
        if (this.myBuildToolsVersion != null) {
            return this.myBuildToolsVersion;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidProject.getBuildToolsVersion()");
    }

    @Override
    public Collection<SyncIssue> getSyncIssues() {
        return ImmutableList.copyOf(this.mySyncIssues);
    }

    @Override
    public Collection<Variant> getVariants() {
        return ImmutableList.copyOf(this.myVariants);
    }

    @Override
    public Collection<String> getVariantNames() {
        return this.myVariantNames;
    }

    @Override
    public String getDefaultVariant() {
        return this.myDefaultVariant;
    }

    @Override
    public Collection<String> getFlavorDimensions() {
        return this.myFlavorDimensions;
    }

    @Override
    public String getCompileTarget() {
        return this.myCompileTarget;
    }

    @Override
    public Collection<String> getBootClasspath() {
        return this.myBootClassPath;
    }

    @Override
    public AaptOptions getAaptOptions() {
        return this.myAaptOptions;
    }

    @Override
    public Collection<SigningConfig> getSigningConfigs() {
        return this.mySigningConfigs;
    }

    @Override
    public IdeLintOptions getLintOptions() {
        return this.myLintOptions;
    }

    @Override
    @Deprecated
    public Collection<String> getUnresolvedDependencies() {
        return this.myUnresolvedDependencies;
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.myJavaCompileOptions;
    }

    @Override
    public File getBuildFolder() {
        return this.myBuildFolder;
    }

    @Override
    public String getResourcePrefix() {
        return this.myResourcePrefix;
    }

    @Override
    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Override
    public int getProjectType() {
        return this.myProjectType;
    }

    @Override
    public boolean isBaseSplit() {
        return this.myBaseSplit;
    }

    @Override
    public Collection<String> getDynamicFeatures() {
        return this.myDynamicFeatures;
    }

    @Override
    public ViewBindingOptions getViewBindingOptions() {
        return this.myViewBindingOptions;
    }

    @Override
    public String getGroupId() {
        return this.myGroupId;
    }

    @Override
    public void forEachVariant(Consumer<IdeVariant> action) {
        for (Variant variant : this.myVariants) {
            action.accept((IdeVariant)variant);
        }
    }

    @Override
    public void addVariants(Collection<Variant> variants, IdeDependenciesFactory factory) {
        ModelCache modelCache = new ModelCache();
        for (Variant variant : variants) {
            this.myVariants.add(new IdeVariantImpl(variant, modelCache, factory, this.myParsedModelVersion));
        }
    }

    @Override
    public void addSyncIssues(Collection<SyncIssue> syncIssues) {
        ModelCache modelCache = new ModelCache();
        HashSet<SyncIssue> currentSyncIssues = new HashSet<SyncIssue>(this.mySyncIssues);
        for (SyncIssue issue : syncIssues) {
            IdeSyncIssue newSyncIssue = new IdeSyncIssue(issue, modelCache);
            if (currentSyncIssues.contains(newSyncIssue)) continue;
            this.mySyncIssues.add(newSyncIssue);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidProjectImpl)) {
            return false;
        }
        IdeAndroidProjectImpl project = (IdeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && this.myProjectType == project.myProjectType && this.myBaseSplit == project.myBaseSplit && this.mySupportsPluginGeneration == project.mySupportsPluginGeneration && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myParsedModelVersion, project.myParsedModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myDefaultConfig, project.myDefaultConfig) && Objects.equals(this.myBuildTypes, project.myBuildTypes) && Objects.equals(this.myProductFlavors, project.myProductFlavors) && Objects.equals(this.myBuildToolsVersion, project.myBuildToolsVersion) && Objects.equals(this.mySyncIssues, project.mySyncIssues) && Objects.equals(this.myVariants, project.myVariants) && Objects.equals(this.myVariantNames, project.myVariantNames) && Objects.equals(this.myDefaultVariant, project.myDefaultVariant) && Objects.equals(this.myFlavorDimensions, project.myFlavorDimensions) && Objects.equals(this.myCompileTarget, project.myCompileTarget) && Objects.equals(this.myBootClassPath, project.myBootClassPath) && Objects.equals(this.myNativeToolchains, project.myNativeToolchains) && Objects.equals(this.mySigningConfigs, project.mySigningConfigs) && Objects.equals(this.myLintOptions, project.myLintOptions) && Objects.equals(this.myUnresolvedDependencies, project.myUnresolvedDependencies) && Objects.equals(this.myJavaCompileOptions, project.myJavaCompileOptions) && Objects.equals(this.myAaptOptions, project.myAaptOptions) && Objects.equals(this.myBuildFolder, project.myBuildFolder) && Objects.equals(this.myResourcePrefix, project.myResourcePrefix) && Objects.equals(this.myDynamicFeatures, project.myDynamicFeatures) && Objects.equals(this.myViewBindingOptions, project.myViewBindingOptions) && Objects.equals(this.myGroupId, project.myGroupId);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myParsedModelVersion, this.myName, this.myDefaultConfig, this.myBuildTypes, this.myProductFlavors, this.myBuildToolsVersion, this.mySyncIssues, this.myVariants, this.myVariantNames, this.myDefaultVariant, this.myFlavorDimensions, this.myCompileTarget, this.myBootClassPath, this.myNativeToolchains, this.mySigningConfigs, this.myLintOptions, this.myUnresolvedDependencies, this.myJavaCompileOptions, this.myBuildFolder, this.myResourcePrefix, this.myApiVersion, this.myProjectType, this.mySupportsPluginGeneration, this.myAaptOptions, this.myBaseSplit, this.myDynamicFeatures, this.myViewBindingOptions, this.myGroupId);
    }

    public String toString() {
        return "IdeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myDefaultConfig=" + this.myDefaultConfig + ", myBuildTypes=" + this.myBuildTypes + ", myProductFlavors=" + this.myProductFlavors + ", myBuildToolsVersion='" + this.myBuildToolsVersion + '\'' + ", mySyncIssues=" + this.mySyncIssues + ", myVariants=" + this.myVariants + ", myVariantNames=" + this.myVariantNames + ", myDefaultVariant=" + this.myDefaultVariant + ", myFlavorDimensions=" + this.myFlavorDimensions + ", myCompileTarget='" + this.myCompileTarget + '\'' + ", myBootClassPath=" + this.myBootClassPath + ", myNativeToolchains=" + this.myNativeToolchains + ", mySigningConfigs=" + this.mySigningConfigs + ", myLintOptions=" + this.myLintOptions + ", myUnresolvedDependencies=" + this.myUnresolvedDependencies + ", myJavaCompileOptions=" + this.myJavaCompileOptions + ", myBuildFolder=" + this.myBuildFolder + ", myResourcePrefix='" + this.myResourcePrefix + '\'' + ", myApiVersion=" + this.myApiVersion + ", myProjectType=" + this.myProjectType + ", mySupportsPluginGeneration=" + this.mySupportsPluginGeneration + ", myAaptOptions=" + this.myAaptOptions + ", myBaseSplit=" + this.myBaseSplit + ", myDynamicFeatures=" + this.myDynamicFeatures + ", myViewBindingOptions=" + this.myViewBindingOptions + ", myGroupId=" + this.myGroupId + "}";
    }
}

