/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParseException;
import com.android.ide.common.symbols.ResourceExtraXmlParser;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.ResourceValuesXmlParser;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.io.File;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a2\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a,\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007\u001a@\u0010\u0018\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a8\u0006!"}, d2={"addIfNotExisting", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "getNameWithoutExtensions", "", "filename", "parseResourceDirectory", "resourceDirectory", "Ljava/io/File;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "parseResourceSourceSetDirectory", "directory", "tablePackage", "shouldBeParsed", "", "directoryName", "parseAarZipEntry", "errorHandler", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "name", "content", "Lkotlin/Function0;", "Ljava/io/InputStream;", "sdk-common"})
@JvmName(name="ResourceDirectoryParser")
public final class ResourceDirectoryParser {
    @NotNull
    public static final SymbolTable parseResourceSourceSetDirectory(@NotNull File directory, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols, @Nullable String tablePackage) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!directory.isDirectory()", (Object[])new Object[0]);
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        Object[] objectArray = directory.listFiles();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] $this$sortedBy$iv = objectArray;
        boolean $i$f$sortedBy = false;
        Object object = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                bl2 = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List resourceDirectories = ArraysKt.sortedWith((Object[])object, (Comparator)comparator);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (Throwable)new ResourceDirectoryParseException("Failed to instantiate DOM parser", e);
        }
        Object documentBuilder = object;
        Iterator iterator = resourceDirectories.iterator();
        while (iterator.hasNext()) {
            File resourceDirectory;
            File file = resourceDirectory = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"resourceDirectory");
            if (!file.isDirectory()) {
                throw (Throwable)new ResourceDirectoryParseException('\'' + resourceDirectory.getAbsolutePath() + "' is not a directory");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder, (String)"documentBuilder");
            ResourceDirectoryParser.parseResourceDirectory(resourceDirectory, builder, idProvider, (DocumentBuilder)documentBuilder, platformAttrSymbols);
        }
        if (tablePackage != null) {
            builder.tablePackage(tablePackage);
        }
        return builder.build();
    }

    public static /* synthetic */ SymbolTable parseResourceSourceSetDirectory$default(File file, IdProvider idProvider, SymbolTable symbolTable, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return ResourceDirectoryParser.parseResourceSourceSetDirectory(file, idProvider, symbolTable, string);
    }

    private static final void parseResourceDirectory(File resourceDirectory, SymbolTable.Builder builder, IdProvider idProvider, DocumentBuilder documentBuilder, SymbolTable platformAttrSymbols) {
        boolean bl = resourceDirectory.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = resourceDirectory.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceDirectory.name");
        if (!ResourceDirectoryParser.shouldBeParsed(string)) {
            return;
        }
        String directoryName = resourceDirectory.getName();
        ResourceFolderType folderResourceType = ResourceFolderType.getFolderType((String)directoryName);
        Object[] objectArray = resourceDirectory.listFiles();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        Object[] $this$sortedBy$iv = objectArray;
        boolean $i$f$sortedBy = false;
        Object[] objectArray2 = $this$sortedBy$iv;
        boolean bl5 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)file.getName());
                bl2 = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                String string = file2.getName();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        };
        List resourceFiles = ArraysKt.sortedWith((Object[])objectArray2, (Comparator)comparator);
        Iterator iterator = resourceFiles.iterator();
        while (iterator.hasNext()) {
            ResourceType resourceType;
            String fileName;
            File maybeResourceFile;
            File file = maybeResourceFile = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"maybeResourceFile");
            if (file.isDirectory()) continue;
            if (!maybeResourceFile.isFile()) {
                throw (Throwable)new ResourceDirectoryParseException('\'' + maybeResourceFile.getAbsolutePath() + "' is not a file nor directory");
            }
            if (folderResourceType == ResourceFolderType.VALUES) {
                Document domTree = null;
                try {
                    Document document = documentBuilder.parse(maybeResourceFile);
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(maybeResourceFile)");
                    domTree = document;
                    SymbolTable parsedXml = ResourceValuesXmlParser.parseValuesResource(domTree, idProvider, platformAttrSymbols);
                    ImmutableCollection immutableCollection = parsedXml.getSymbols().values();
                    Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"parsedXml.symbols.values()");
                    Iterable $this$forEach$iv = (Iterable)immutableCollection;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Symbol s = (Symbol)element$iv;
                        boolean bl6 = false;
                        Symbol symbol = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                        ResourceDirectoryParser.addIfNotExisting(builder, symbol);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw (Throwable)new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
                }
            }
            try {
                ResourceFolderType resourceFolderType = folderResourceType;
                if (resourceFolderType == null) {
                    Intrinsics.throwNpe();
                }
                FileResourceNameValidator.validate(maybeResourceFile, resourceFolderType);
            }
            catch (MergingException e) {
                throw (Throwable)new ResourceDirectoryParseException("Failed file name validation for file " + maybeResourceFile.getAbsolutePath(), e);
            }
            String string2 = fileName = maybeResourceFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileName");
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(string2);
            ResourceType resourceType2 = resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType2, (String)"resourceType");
            ResourceDirectoryParser.addIfNotExisting(builder, Symbol.Companion.createAndValidateSymbol$default(Symbol.Companion, resourceType2, symbolName, idProvider, false, 8, null));
            if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) || !SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
            try {
                Document domTree;
                Document document = domTree = documentBuilder.parse(maybeResourceFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"domTree");
                SymbolTable extraSymbols = ResourceExtraXmlParser.parseResourceForInlineResources(document, idProvider);
                ImmutableCollection immutableCollection = extraSymbols.getSymbols().values();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"extraSymbols.symbols.values()");
                Iterable $this$forEach$iv = (Iterable)immutableCollection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Symbol s = (Symbol)element$iv;
                    boolean bl7 = false;
                    Symbol symbol = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                    ResourceDirectoryParser.addIfNotExisting(builder, symbol);
                }
            }
            catch (Exception e) {
                throw (Throwable)new ResourceDirectoryParseException("Failed to parse XML file '" + maybeResourceFile.getAbsolutePath() + '\'', e);
            }
        }
    }

    public static final boolean shouldBeParsed(@NotNull String directoryName) {
        Intrinsics.checkParameterIsNotNull((Object)directoryName, (String)"directoryName");
        if (!StringsKt.contains$default((CharSequence)directoryName, (char)'-', (boolean)false, (int)2, null)) {
            return true;
        }
        List configs = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)directoryName, (char)'-', null, (int)2, null), (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null);
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigFromQualifiers(configs.iterator());
        if (folderConfiguration == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)folderConfiguration, (String)"FolderConfiguration.getC\u2026erator()) ?: return false");
        FolderConfiguration config = folderConfiguration;
        return config.getLocaleQualifier() == null;
    }

    public static final void parseAarZipEntry(@NotNull SymbolTable.Builder $this$parseAarZipEntry, @NotNull DocumentBuilder documentBuilder, @NotNull Function1<? super Exception, Unit> errorHandler, @NotNull String name, @NotNull Function0<? extends InputStream> content) {
        block16: {
            SymbolTable e4;
            Document element$iv2;
            ResourceType resourceType;
            ResourceFolderType folderResourceType;
            int lastSlashPosition;
            block15: {
                SymbolTable e22;
                Document document;
                Intrinsics.checkParameterIsNotNull((Object)$this$parseAarZipEntry, (String)"$this$parseAarZipEntry");
                Intrinsics.checkParameterIsNotNull((Object)documentBuilder, (String)"documentBuilder");
                Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(content, (String)"content");
                if (!StringsKt.startsWith$default((String)name, (String)"res/", (boolean)false, (int)2, null)) {
                    return;
                }
                int firstSlashPosition = StringsKt.indexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null);
                lastSlashPosition = StringsKt.lastIndexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (lastSlashPosition == firstSlashPosition) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': Invalid resource path."));
                    return;
                }
                String string = name;
                int n = firstSlashPosition + 1;
                boolean bl = false;
                String string2 = string.substring(n, lastSlashPosition);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String directoryName = string2;
                if (!ResourceDirectoryParser.shouldBeParsed(directoryName)) {
                    return;
                }
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)directoryName);
                if (resourceFolderType == null) {
                    SymbolTable.Builder builder = $this$parseAarZipEntry;
                    bl = false;
                    boolean bl2 = false;
                    SymbolTable.Builder $this$run = builder;
                    boolean bl3 = false;
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': Invalid resource directory name '" + directoryName + '\''));
                    return;
                }
                folderResourceType = resourceFolderType;
                if (folderResourceType != ResourceFolderType.VALUES) break block15;
                try {
                    Document document2 = documentBuilder.parse((InputStream)content.invoke());
                    Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"documentBuilder.parse(content())");
                    document = document2;
                }
                catch (SAXParseException e22) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e22));
                    return;
                }
                Document domTree = document;
                try {
                    e22 = ResourceValuesXmlParser.parseValuesResource(domTree, IdProvider.Companion.constant(), null);
                }
                catch (ResourceValuesXmlParseException e3) {
                    errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e3));
                    return;
                }
                SymbolTable parsedXml = e22;
                ImmutableCollection immutableCollection = parsedXml.getSymbols().values();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"parsedXml.symbols.values()");
                Iterable $this$forEach$iv = (Iterable)immutableCollection;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Symbol s = (Symbol)element$iv2;
                    boolean bl4 = false;
                    Symbol symbol = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                    ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, symbol);
                }
                break block16;
            }
            String parsedXml = name;
            int $this$forEach$iv = lastSlashPosition + 1;
            boolean $i$f$forEach = false;
            String string = parsedXml.substring($this$forEach$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String fileName = string;
            String error = FileResourceNameValidator.getErrorTextForFileResource(fileName, folderResourceType);
            if (error != null) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + "': " + error));
                return;
            }
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
            ResourceType resourceType2 = resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderResourceType);
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType2, (String)"resourceType");
            ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, Symbol.Companion.createAndValidateSymbol$default(Symbol.Companion, resourceType2, symbolName, IdProvider.Companion.constant(), false, 8, null));
            if (!FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderResourceType) || !SdkUtils.endsWithIgnoreCase((String)fileName, (String)".xml")) break block16;
            try {
                Document document = documentBuilder.parse((InputStream)content.invoke());
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(content())");
                element$iv2 = document;
            }
            catch (SAXParseException e4) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e4));
                return;
            }
            Document domTree = element$iv2;
            try {
                e4 = ResourceExtraXmlParser.parseResourceForInlineResources(domTree, IdProvider.Companion.constant());
            }
            catch (ResourceValuesXmlParseException e5) {
                errorHandler.invoke((Object)new ResourceDirectoryParseException("Error parsing '" + name + '\'', e5));
                return;
            }
            SymbolTable extraSymbols = e4;
            ImmutableCollection immutableCollection = extraSymbols.getSymbols().values();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"extraSymbols.symbols.values()");
            Iterable $this$forEach$iv2 = (Iterable)immutableCollection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                Symbol s = (Symbol)element$iv3;
                boolean bl = false;
                Symbol symbol = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"s");
                ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, symbol);
            }
        }
    }

    private static final String getNameWithoutExtensions(String filename) {
        String string;
        int dotIndex = StringsKt.indexOf$default((CharSequence)filename, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex > 0) {
            String string2 = filename;
            int n = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, dotIndex);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = filename;
        }
        return string;
    }

    private static final void addIfNotExisting(SymbolTable.Builder builder, Symbol symbol) {
        if (!builder.contains(symbol)) {
            builder.add(symbol);
        }
    }
}

