/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PathParser {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    private PathParser() {
    }

    private static void extract(String s, int start, boolean flagMode, ExtractFloatResult result2) {
        int currentIndex;
        boolean foundSeparator = false;
        result2.mExplicitSeparator = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    result2.mExplicitSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    break;
                }
                case '.': {
                    if (secondDot) {
                        foundSeparator = true;
                        break;
                    }
                    secondDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator || flagMode && currentIndex > start) break;
        }
        result2.mEndPosition = currentIndex;
    }

    private static float[] getFloats(String s) {
        char command = s.charAt(0);
        if (command == 'z' || command == 'Z') {
            return EMPTY_FLOAT_ARRAY;
        }
        try {
            boolean arcCommand = command == 'a' || command == 'A';
            float[] results = new float[s.length()];
            int count = 0;
            int startPosition = 1;
            ExtractFloatResult result2 = new ExtractFloatResult();
            int totalLength = s.length();
            while (startPosition < totalLength) {
                boolean flagMode = arcCommand && (count % 7 == 3 || count % 7 == 4);
                PathParser.extract(s, startPosition, flagMode, result2);
                int endPosition = result2.mEndPosition;
                if (startPosition < endPosition) {
                    results[count++] = Float.parseFloat(s.substring(startPosition, endPosition));
                }
                if (result2.mExplicitSeparator) {
                    startPosition = endPosition + 1;
                    continue;
                }
                startPosition = endPosition;
            }
            return Arrays.copyOfRange(results, 0, count);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error in parsing \"" + s + "\"", e);
        }
    }

    private static void addNode(List<VdPath.Node> list, char cmd, float[] val) {
        list.add(new VdPath.Node(cmd, val));
    }

    private static int nextStart(String s, int end) {
        while (end < s.length()) {
            char c = s.charAt(end);
            if (((c - 65) * (c - 90) <= 0 || (c - 97) * (c - 122) <= 0) && c != 'e' && c != 'E') {
                return end;
            }
            ++end;
        }
        return end;
    }

    public static VdPath.Node[] parsePath(String value) {
        value = value.trim();
        ArrayList<VdPath.Node> list = new ArrayList<VdPath.Node>();
        int start = 0;
        int end = 1;
        while (end < value.length()) {
            end = PathParser.nextStart(value, end);
            String s = value.substring(start, end);
            float[] val = PathParser.getFloats(s);
            char currentCommand = s.charAt(0);
            if (start == 0 && currentCommand != 'M' && currentCommand != 'm') {
                PathParser.addNode(list, 'M', new float[2]);
            }
            PathParser.addNode(list, currentCommand, val);
            start = end++;
        }
        if (end - start == 1 && start < value.length()) {
            PathParser.addNode(list, value.charAt(start), EMPTY_FLOAT_ARRAY);
        }
        return list.toArray(new VdPath.Node[0]);
    }

    private static class ExtractFloatResult {
        private int mEndPosition;
        private boolean mExplicitSeparator;

        private ExtractFloatResult() {
        }
    }
}

