/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.gradle.model.IdeModel;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class IdeSyncIssue
implements SyncIssue,
Serializable {
    private static final long serialVersionUID = 3L;
    private final String myMessage;
    private final String myData;
    private final List<String> myMultiLineMessage;
    private final int mySeverity;
    private final int myType;
    private final int myHashCode;

    public IdeSyncIssue() {
        this.myMessage = "";
        this.myData = "";
        this.myMultiLineMessage = null;
        this.mySeverity = 0;
        this.myType = 0;
        this.myHashCode = 0;
    }

    public IdeSyncIssue(SyncIssue issue) {
        this.myMessage = issue.getMessage();
        this.myMultiLineMessage = IdeModel.copyNewProperty(() -> ((SyncIssue)issue).getMultiLineMessage(), null);
        this.myData = issue.getData();
        this.mySeverity = issue.getSeverity();
        this.myType = issue.getType();
        this.myHashCode = this.calculateHashCode();
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getData() {
        return this.myData;
    }

    public int getSeverity() {
        return this.mySeverity;
    }

    public int getType() {
        return this.myType;
    }

    public List<String> getMultiLineMessage() {
        return this.myMultiLineMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSyncIssue)) {
            return false;
        }
        IdeSyncIssue issue = (IdeSyncIssue)o;
        return this.mySeverity == issue.mySeverity && this.myType == issue.myType && Objects.equals(this.myMessage, issue.myMessage) && Objects.equals(this.myMultiLineMessage, issue.myMultiLineMessage) && Objects.equals(this.myData, issue.myData);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myMessage, this.myMultiLineMessage, this.myData, this.mySeverity, this.myType);
    }

    public String toString() {
        return "IdeSyncIssue{myMessage='" + this.myMessage + '\'' + ", myData='" + this.myData + '\'' + ", mySeverity=" + this.mySeverity + ", myType=" + this.myType + "}";
    }
}

