/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.utils.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

final class StringResourceEscapeUtils {
    static final String STRING_ELEMENT_NAME = "string";
    private static final Pattern DECIMAL_REFERENCE = Pattern.compile("&#(\\p{Digit}+);");
    private static final String DECIMAL_ESCAPE = "___D";
    private static final Pattern HEXADECIMAL_REFERENCE = Pattern.compile("&#x(\\p{XDigit}+);");
    private static final String HEXADECIMAL_ESCAPE = "___X";
    private static final Pattern ESCAPED_DECIMAL_REFERENCE = Pattern.compile("___D(\\p{Digit}+);");
    private static final Pattern ESCAPED_HEXADECIMAL_REFERENCE = Pattern.compile("___X(\\p{XDigit}+);");

    StringResourceEscapeUtils() {
    }

    static SAXParserFactory createSaxParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        XmlUtils.configureSaxFactory((SAXParserFactory)factory, (boolean)false, (boolean)false);
        return factory;
    }

    static void parse(String string, SAXParserFactory factory, ContentHandler handler) throws SAXException {
        XMLReader reader;
        try {
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)factory);
            reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
        string = "<string>" + string + "</" + STRING_ELEMENT_NAME + '>';
        try {
            reader.parse(new InputSource(new StringReader(string)));
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    static String escapeCharacterReferences(String xml) {
        xml = DECIMAL_REFERENCE.matcher(xml).replaceAll("___D$1;");
        xml = HEXADECIMAL_REFERENCE.matcher(xml).replaceAll("___X$1;");
        return xml;
    }

    static String unescapeCharacterReferences(String xml) {
        xml = ESCAPED_DECIMAL_REFERENCE.matcher(xml).replaceAll("&#$1;");
        xml = ESCAPED_HEXADECIMAL_REFERENCE.matcher(xml).replaceAll("&#x$1;");
        return xml;
    }
}

