/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.ResourceValuesXmlParser$WhenMappings;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a@\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a8\u0006\u001d"}, d2={"getMandatoryAttr", "", "element", "Lorg/w3c/dom/Element;", "attrName", "parseAttr", "", "attr", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "name", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "enumSymbols", "", "Lcom/android/ide/common/symbols/Symbol;", "isMaybeDefinition", "", "parseChild", "", "child", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "parseDeclareStyleable", "declareStyleable", "styleableName", "parseValuesResource", "xmlDocument", "Lorg/w3c/dom/Document;", "sdk-common"})
@JvmName(name="ResourceValuesXmlParser")
public final class ResourceValuesXmlParser {
    @NotNull
    public static final SymbolTable parseValuesResource(@NotNull Document xmlDocument, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols) {
        Intrinsics.checkParameterIsNotNull((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        Element element = xmlDocument.getDocumentElement();
        if (element == null) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document does not have a root element.");
        }
        Element root = element;
        if (Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources") ^ true) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document root is not 'resources'");
        }
        if (root.getNamespaceURI() != null) {
            throw (Throwable)new ResourceValuesXmlParseException("XML document root has a namespace");
        }
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        ArrayList enumSymbols = new ArrayList();
        for (Node current = root.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            ResourceValuesXmlParser.parseChild((Element)current, builder, idProvider, enumSymbols, platformAttrSymbols);
        }
        Iterator iterator = enumSymbols.iterator();
        while (iterator.hasNext()) {
            Symbol enumSymbol;
            Symbol symbol = enumSymbol = (Symbol)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)symbol, (String)"enumSymbol");
            if (builder.contains(symbol)) continue;
            builder.add(enumSymbol);
        }
        return builder.build();
    }

    private static final void parseChild(Element child, SymbolTable.Builder builder, IdProvider idProvider, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        if (Intrinsics.areEqual((Object)child.getTagName(), (Object)"eat-comment")) {
            return;
        }
        ResourceType resourceType = ResourceType.fromXmlTag((Node)child);
        if (resourceType == null) {
            throw (Throwable)new ResourceValuesXmlParseException("Unknown resource value XML element '" + XmlUtils.toXml((Node)child) + '\'');
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2 == ResourceType.PUBLIC) {
            return;
        }
        String name = ResourceValuesXmlParser.getMandatoryAttr(child, "name");
        switch (ResourceValuesXmlParser$WhenMappings.$EnumSwitchMapping$0[resourceType2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                builder.add(Symbol.Companion.createAndValidateSymbol$default(Symbol.Companion, resourceType2, name, idProvider, false, 8, null));
                break;
            }
            case 22: {
                ResourceValuesXmlParser.parseDeclareStyleable(child, idProvider, name, builder, enumSymbols, platformAttrSymbols);
                break;
            }
            case 23: {
                ResourceValuesXmlParser.parseAttr(child, idProvider, name, builder, enumSymbols, false);
                break;
            }
            case 24: {
                String string = "Already checked above.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            default: {
                throw (Throwable)new ResourceValuesXmlParseException("Unknown resource value XML element '" + XmlUtils.toXml((Node)child) + '\'');
            }
        }
    }

    private static final void parseDeclareStyleable(Element declareStyleable, IdProvider idProvider, String styleableName, SymbolTable.Builder builder, List<Symbol> enumSymbols, SymbolTable platformAttrSymbols) {
        ImmutableList.Builder attrNames = new ImmutableList.Builder();
        ImmutableList.Builder attrValues = ImmutableList.builder();
        Node attrNode = declareStyleable.getFirstChild();
        while (attrNode != null) {
            int n;
            if (attrNode.getNodeType() != 1) {
                attrNode = attrNode.getNextSibling();
                continue;
            }
            Element attrElement = (Element)attrNode;
            String tagName = attrElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = attrElement.getAttribute("type");
            }
            if (Intrinsics.areEqual((Object)tagName, (Object)ResourceType.ATTR.getName()) ^ true || attrElement.getNamespaceURI() != null) {
                if (Intrinsics.areEqual((Object)tagName, (Object)"eat-comment")) {
                    attrNode = ((Element)attrNode).getNextSibling();
                    continue;
                }
                throw (Throwable)new ResourceValuesXmlParseException("Illegal type under declare-styleable: was <" + tagName + ">, only accepted is " + "<attr>");
            }
            String attrName = ResourceValuesXmlParser.getMandatoryAttr(attrElement, "name");
            if (StringsKt.startsWith$default((String)attrName, (String)"android:", (boolean)false, (int)2, null)) {
                if (platformAttrSymbols == null) {
                    n = -1;
                } else {
                    Symbol attrSymbol;
                    String realAttrName;
                    String string = attrName;
                    int n2 = SdkConstants.ANDROID_NS_NAME_PREFIX_LEN;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                    if ((Symbol)platformAttrSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)realAttrName) == null) {
                        throw (Throwable)new ResourceValuesXmlParseException("Unknown android attribute '" + attrName + "' under '" + styleableName);
                    }
                    n = attrSymbol.getIntValue();
                }
            } else {
                n = ResourceValuesXmlParser.parseAttr(attrElement, idProvider, attrName, builder, enumSymbols, true);
            }
            int attrValue = n;
            attrNames.add((Object)attrName);
            attrValues.add((Object)attrValue);
            attrNode = ((Element)attrNode).getNextSibling();
        }
        ImmutableList immutableList = attrValues.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"attrValues.build()");
        ImmutableList immutableList2 = attrNames.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"attrNames.build()");
        builder.add(Symbol.Companion.createAndValidateStyleableSymbol(styleableName, (ImmutableList<Integer>)immutableList, (List)immutableList2));
    }

    private static final int parseAttr(Element attr, IdProvider idProvider, String name, SymbolTable.Builder builder, List<Symbol> enumSymbols, boolean isMaybeDefinition) {
        Node enumNode = attr.getFirstChild();
        while (enumNode != null) {
            if (enumNode.getNodeType() != 1) {
                enumNode = enumNode.getNextSibling();
                continue;
            }
            Element enumElement = (Element)enumNode;
            String tagName = enumElement.getTagName();
            if (Intrinsics.areEqual((Object)tagName, (Object)"item")) {
                tagName = enumElement.getAttribute("type");
            }
            if (Intrinsics.areEqual((Object)tagName, (Object)"enum") ^ true || enumElement.getNamespaceURI() != null) {
                enumNode = ((Element)enumNode).getNextSibling();
                continue;
            }
            Symbol newEnum = Symbol.Companion.createAndValidateSymbol$default(Symbol.Companion, ResourceType.ID, ResourceValuesXmlParser.getMandatoryAttr(enumElement, "name"), idProvider, false, 8, null);
            enumSymbols.add(newEnum);
            enumNode = ((Element)enumNode).getNextSibling();
        }
        Symbol newAttr = Symbol.Companion.createAndValidateSymbol(ResourceType.ATTR, name, idProvider, isMaybeDefinition);
        if (!builder.contains(newAttr)) {
            builder.add(newAttr);
            return newAttr.getIntValue();
        }
        if (!isMaybeDefinition) {
            Symbol symbol = builder.get(newAttr);
            if (symbol == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.ide.common.symbols.Symbol.AttributeSymbol");
            }
            if (((Symbol.AttributeSymbol)symbol).isMaybeDefinition()) {
                Symbol symbol2 = builder.remove(newAttr.getResourceType(), newAttr.getCanonicalName());
                if (symbol2 == null) {
                    Intrinsics.throwNpe();
                }
                Symbol old = symbol2;
                builder.add(new Symbol.AttributeSymbol(newAttr.getCanonicalName(), old.getIntValue(), false, null, null, 24, null));
            }
        }
        Symbol symbol = builder.get(newAttr);
        if (symbol == null) {
            Intrinsics.throwNpe();
        }
        return symbol.getIntValue();
    }

    private static final String getMandatoryAttr(Element element, String attrName) {
        Attr attr = element.getAttributeNodeNS(null, attrName);
        if (attr == null) {
            throw (Throwable)new ResourceValuesXmlParseException("Element '" + element.getTagName() + "' should have attribute '" + attrName + '\'');
        }
        Attr attr2 = attr;
        String string = attr2.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attr.value");
        return string;
    }
}

