/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.StringResourceContentHandler;
import com.android.ide.common.resources.StringResourceEscapeUtils;
import com.android.ide.common.resources.StringResourceUnescaperCharacterHandler;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class StringResourceUnescaper {
    private final SAXParserFactory mFactory = StringResourceEscapeUtils.createSaxParserFactory();

    public String unescapeCharacterData(String xml) {
        if (xml.isEmpty()) {
            return "";
        }
        xml = StringResourceEscapeUtils.escapeCharacterReferences(xml);
        xml = StringResourceUnescaper.unescapeLeadingQuestionMarkOrAtSign(xml);
        StringBuilder builder = new StringBuilder(xml.length());
        try {
            StringResourceEscapeUtils.parse(xml, this.mFactory, StringResourceUnescaper.newContentHandler(builder));
        }
        catch (SAXException exception) {
            throw new IllegalArgumentException(xml, exception);
        }
        xml = builder.toString();
        xml = StringResourceEscapeUtils.unescapeCharacterReferences(xml);
        return xml;
    }

    private static String unescapeLeadingQuestionMarkOrAtSign(String xml) {
        if (xml.startsWith("\\?") || xml.startsWith("\\@")) {
            return xml.substring(1);
        }
        return xml;
    }

    private static ContentHandler newContentHandler(StringBuilder builder) {
        StringResourceUnescaperCharacterHandler handler = new StringResourceUnescaperCharacterHandler();
        return new StringResourceContentHandler(builder, handler);
    }
}

