/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.NetworkCache;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 ,2\u00020\u0001:\u0003+,-B1\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001aJ*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ:\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\b\b\u0002\u0010\u001c\u001a\u00020\bJ2\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u0010\u001a\u00020\fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u001fJ\u0018\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002J4\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001dH\u0002J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\fH\u0014J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%2\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "useNetwork", "", "(Ljava/nio/file/Path;IIZ)V", "packageMap", "", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "findArtifact", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "groupId", "artifactId", "findCompileDependencies", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "version", "Lcom/android/ide/common/repository/GradleVersion;", "findVersion", "dependency", "filter", "Ljava/util/function/Predicate;", "predicate", "allowPreview", "Lkotlin/Function1;", "getArtifacts", "", "getGroups", "getPackageMap", "getSnapshotVersionFilter", "getVersions", "readDefaultData", "Ljava/io/InputStream;", "relative", "readMasterIndex", "", "stream", "map", "ArtifactInfo", "Companion", "PackageInfo", "sdk-common"})
public abstract class GoogleMavenRepository
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, PackageInfo> packageMap;
    @NotNull
    public static final String MAVEN_GOOGLE_CACHE_DIR_KEY = "maven.google";

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean useNetwork) {
        super(GoogleMavenRepositoryKt.GMAVEN_BASE_URL, MAVEN_GOOGLE_CACHE_DIR_KEY, cacheDir, networkTimeoutMs, cacheExpiryHours, useNetwork);
    }

    public /* synthetic */ GoogleMavenRepository(Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            path = null;
        }
        if ((n3 & 2) != 0) {
            n = 3000;
        }
        if ((n3 & 4) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(7L);
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        this(path, n, n2, bl);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter2) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        return this.findVersion(dependency, filter2, dependency.isPreview());
    }

    public static /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, GradleCoordinate gradleCoordinate, Predicate predicate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 2) != 0) {
            predicate = null;
        }
        return googleMavenRepository.findVersion(gradleCoordinate, predicate);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> predicate, boolean allowPreview) {
        Function1 filter2;
        Function1 function1;
        Object object;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        String string = dependency.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.groupId");
        String groupId = string;
        String string2 = dependency.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dependency.artifactId");
        String artifactId = string2;
        GradleVersion version = dependency.getVersion();
        if (dependency.acceptsGreaterRevisions()) {
            object = dependency.getRevision();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dependency.revision");
            String string3 = object;
            object = new char[1];
            object[0] = 43;
            String prefix = StringsKt.trimEnd((String)string3, (char[])object);
            function1 = predicate != null ? (Function1)new Function1<GradleVersion, Boolean>(predicate, prefix){
                final /* synthetic */ Predicate<GradleVersion> $predicate;
                final /* synthetic */ String $prefix;
                {
                    this.$predicate = $predicate;
                    this.$prefix = $prefix;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull GradleVersion v) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    if (this.$predicate.test(v)) {
                        String string = v.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v.toString()");
                        if (StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null)) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            } : (Function1)new Function1<GradleVersion, Boolean>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    String string = v.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v.toString()");
                    return StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null);
                }
            };
        } else {
            function1 = filter2 = predicate != null ? (Function1)new Function1<GradleVersion, Boolean>(predicate){
                final /* synthetic */ Predicate<GradleVersion> $predicate;
                {
                    this.$predicate = $predicate;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return this.$predicate.test(v);
                }
            } : (Function1)null;
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"androidx.work") && version != null && (version.getMajor() == 1 || version.getMajor() == 2 && version.getMinor() <= 6)) {
            object = this.findArtifact(groupId, artifactId);
            if (object == null) {
                return null;
            }
            Object artifactInfo = object;
            Function1<GradleVersion, Boolean> snapshotFilter = this.getSnapshotVersionFilter(version, null);
            GradleVersion gradleVersion = (GradleVersion)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(((ArtifactInfo)artifactInfo).getGradleVersions(), (Function1)((Function1)new Function1<GradleVersion, Boolean>((Function1<? super GradleVersion, Boolean>)filter2){
                final /* synthetic */ Function1<GradleVersion, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return !(v.getMajor() == 2 && v.getMinor() == 7 && v.isPreview() || this.$filter != null && (Boolean)this.$filter.invoke((Object)v) == false);
                }
            })), (Function1)((Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
            })), (Function1)((Function1)new Function1<GradleVersion, Boolean>(snapshotFilter){
                final /* synthetic */ Function1<GradleVersion, Boolean> $snapshotFilter;
                {
                    this.$snapshotFilter = $snapshotFilter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Boolean)this.$snapshotFilter.invoke((Object)it);
                }
            })));
            if (gradleVersion != null) {
                GradleVersion gradleVersion2 = gradleVersion;
                boolean bl = false;
                boolean bl2 = false;
                GradleVersion it = gradleVersion2;
                boolean bl3 = false;
                return it;
            }
        }
        Function1<GradleVersion, Boolean> compositeFilter = this.getSnapshotVersionFilter(version, (Function1<? super GradleVersion, Boolean>)filter2);
        return this.findVersion(groupId, artifactId, compositeFilter, allowPreview);
    }

    public static /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, GradleCoordinate gradleCoordinate, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(gradleCoordinate, predicate, bl);
    }

    private final Function1<GradleVersion, Boolean> getSnapshotVersionFilter(GradleVersion version, Function1<? super GradleVersion, Boolean> filter2) {
        return (Function1)new Function1<GradleVersion, Boolean>(version, filter2){
            final /* synthetic */ GradleVersion $version;
            final /* synthetic */ Function1<GradleVersion, Boolean> $filter;
            {
                this.$version = $version;
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GradleVersion candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                boolean snapshot = candidate.isSnapshot() ? false : (this.$version != null && this.$version.isSnapshot() ? candidate.isAtLeast(this.$version.getMajor(), this.$version.getMinor(), this.$version.getMicro()) && (!candidate.isPreview() || candidate.getMajor() > this.$version.getMajor() || candidate.getMinor() > this.$version.getMinor() || candidate.getMicro() > this.$version.getMicro()) : true);
                return snapshot && (this.$filter == null || (Boolean)this.$filter.invoke((Object)candidate) != false);
            }
        };
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<GradleVersion> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return this.findVersion(groupId, artifactId, (Function1<? super GradleVersion, Boolean>)((Function1)new Function1<GradleVersion, Boolean>(filter2){
            final /* synthetic */ Predicate<GradleVersion> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GradleVersion it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Predicate<GradleVersion> predicate = this.$filter;
                return !(predicate == null ? false : !predicate.test(it));
            }
        }), allowPreview);
    }

    public static /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Predicate predicate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, predicate, bl);
    }

    @Nullable
    public final GradleVersion findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Function1<? super GradleVersion, Boolean> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return null;
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2.findVersion(filter2, allowPreview);
    }

    public static /* synthetic */ GradleVersion findVersion$default(GoogleMavenRepository googleMavenRepository, String string, String string2, Function1 function1, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return googleMavenRepository.findVersion(string, string2, (Function1<? super GradleVersion, Boolean>)function1, bl);
    }

    @NotNull
    public final Set<String> getGroups() {
        return CollectionsKt.toSet((Iterable)this.getPackageMap().keySet());
    }

    @NotNull
    public final Set<String> getArtifacts(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Object object = this.getPackageMap().get(groupId);
        object = object == null ? null : ((PackageInfo)object).artifacts();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = SetsKt.emptySet();
        }
        return object2;
    }

    @NotNull
    public final Set<GradleVersion> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getGradleVersions());
    }

    @NotNull
    public final List<GradleCoordinate> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull GradleVersion version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return CollectionsKt.emptyList();
        }
        PackageInfo packageInfo2 = packageInfo;
        ArtifactInfo artifactInfo = packageInfo2.findArtifact(artifactId);
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2 == null ? CollectionsKt.emptyList() : artifactInfo2.findCompileDependencies(version, packageInfo2);
    }

    private final ArtifactInfo findArtifact(String groupId, String artifactId) {
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return null;
        }
        PackageInfo packageInfo2 = packageInfo;
        return packageInfo2.findArtifact(artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, PackageInfo> getPackageMap() {
        if (this.packageMap == null) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)28);
            InputStream inputStream = this.findData("master-index.xml");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
                    this.readMasterIndex(it, map);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            this.packageMap = map;
        }
        Map<String, PackageInfo> map = this.packageMap;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @Override
    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        return GoogleMavenRepository.class.getResourceAsStream(Intrinsics.stringPlus((String)"/versions-offline/", (Object)relative));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMasterIndex(InputStream stream, Map<String, PackageInfo> map) {
        try {
            Closeable closeable = stream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl3 = false;
                KXmlParser parser = new KXmlParser();
                parser.setInput(it, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType == 3 && parser.getDepth() > 1) {
                        String tag = parser.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
                        PackageInfo packageInfo = new PackageInfo(tag);
                        Map<String, PackageInfo> map2 = map;
                        String string = tag;
                        boolean bl4 = false;
                        map2.put(string, packageInfo);
                        continue;
                    }
                    if (eventType == 2) continue;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException e) {
            this.error(e, null);
        }
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours) {
        this(cacheDir, networkTimeoutMs, cacheExpiryHours, false, 8, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs) {
        this(cacheDir, networkTimeoutMs, 0, false, 12, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir) {
        this(cacheDir, 0, 0, false, 14, null);
    }

    @JvmOverloads
    public GoogleMavenRepository() {
        this(null, 0, 0, false, 15, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$Companion;", "", "()V", "MAVEN_GOOGLE_CACHE_DIR_KEY", "", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cJ(\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u0016J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"J\t\u0010#\u001a\u00020$H\u00d6\u0001J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cH\u0002J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R-\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "", "id", "", "versions", "(Ljava/lang/String;Ljava/lang/String;)V", "dependencyInfo", "Ljava/util/HashMap;", "Lcom/android/ide/common/repository/GradleVersion;", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "getDependencyInfo", "()Ljava/util/HashMap;", "dependencyInfo$delegate", "Lkotlin/Lazy;", "getId", "()Ljava/lang/String;", "getVersions", "component1", "component2", "copy", "equals", "", "other", "findCompileDependencies", "version", "packageInfo", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "findVersion", "filter", "Lkotlin/Function1;", "allowPreview", "getGradleVersions", "Lkotlin/sequences/Sequence;", "hashCode", "", "loadCompileDependencies", "toString", "sdk-common"})
    private static final class ArtifactInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String versions;
        @NotNull
        private final Lazy dependencyInfo$delegate;

        public ArtifactInfo(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            this.id = id;
            this.versions = versions;
            this.dependencyInfo$delegate = LazyKt.lazy((Function0)dependencyInfo.2.INSTANCE);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersions() {
            return this.versions;
        }

        private final HashMap<GradleVersion, List<GradleCoordinate>> getDependencyInfo() {
            Lazy lazy = this.dependencyInfo$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (HashMap)lazy.getValue();
        }

        @NotNull
        public final Sequence<GradleVersion> getGradleVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)this.versions, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getGradleVersions.1.INSTANCE));
        }

        @Nullable
        public final GradleVersion findVersion(@Nullable Function1<? super GradleVersion, Boolean> filter2, boolean allowPreview) {
            return (GradleVersion)SequencesKt.maxOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(this.getGradleVersions(), (Function1)((Function1)new Function1<GradleVersion, Boolean>(filter2){
                final /* synthetic */ Function1<GradleVersion, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$filter == null || (Boolean)this.$filter.invoke((Object)it) != false;
                }
            })), (Function1)((Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allowPreview || !it.isPreview();
                }
            })));
        }

        public static /* synthetic */ GradleVersion findVersion$default(ArtifactInfo artifactInfo, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return artifactInfo.findVersion((Function1<? super GradleVersion, Boolean>)function1, bl);
        }

        @NotNull
        public final List<GradleCoordinate> findCompileDependencies(@NotNull GradleVersion version, @NotNull PackageInfo packageInfo) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)packageInfo, (String)"packageInfo");
            List<GradleCoordinate> list = this.getDependencyInfo().get(version);
            return list == null ? this.loadCompileDependencies(version, packageInfo) : list;
        }

        private final List<GradleCoordinate> loadCompileDependencies(GradleVersion version, PackageInfo packageInfo) {
            if (this.findVersion((Function1<? super GradleVersion, Boolean>)((Function1)new Function1<GradleVersion, Boolean>(version){
                final /* synthetic */ GradleVersion $version;
                {
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull GradleVersion it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$version);
                }
            }), true) == null) {
                return CollectionsKt.emptyList();
            }
            List<GradleCoordinate> dependencies = packageInfo.loadCompileDependencies(this.id, version);
            Map map = this.getDependencyInfo();
            boolean bl = false;
            map.put(version, dependencies);
            return dependencies;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versions;
        }

        @NotNull
        public final ArtifactInfo copy(@NotNull String id, @NotNull String versions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)versions, (String)"versions");
            return new ArtifactInfo(id, versions);
        }

        public static /* synthetic */ ArtifactInfo copy$default(ArtifactInfo artifactInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = artifactInfo.id;
            }
            if ((n & 2) != 0) {
                string2 = artifactInfo.versions;
            }
            return artifactInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ArtifactInfo(id=" + this.id + ", versions=" + this.versions + ')';
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.versions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactInfo)) {
                return false;
            }
            ArtifactInfo artifactInfo = (ArtifactInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)artifactInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.versions, (Object)artifactInfo.versions);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0003J\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "", "pkg", "", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Ljava/lang/String;)V", "artifacts", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getArtifacts", "()Ljava/util/Map;", "artifacts$delegate", "Lkotlin/Lazy;", "getPkg", "()Ljava/lang/String;", "", "check", "", "item", "name", "findArtifact", "id", "initializeIndex", "map", "", "loadCompileDependencies", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "version", "Lcom/android/ide/common/repository/GradleVersion;", "readCompileDependenciesFromPomFile", "stream", "Ljava/io/InputStream;", "file", "readCompileDependency", "parser", "Lorg/kxml2/io/KXmlParser;", "readGroupData", "sdk-common"})
    private final class PackageInfo {
        @NotNull
        private final String pkg;
        @NotNull
        private final Lazy artifacts$delegate;

        public PackageInfo(String pkg) {
            Intrinsics.checkNotNullParameter((Object)GoogleMavenRepository.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            this.pkg = pkg;
            this.artifacts$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HashMap<String, ArtifactInfo>>(this){
                final /* synthetic */ PackageInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final HashMap<String, ArtifactInfo> invoke() {
                    HashMap<String, ArtifactInfo> map = new HashMap<String, ArtifactInfo>();
                    PackageInfo.access$initializeIndex(this.this$0, map);
                    return map;
                }
            }));
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        private final Map<String, ArtifactInfo> getArtifacts() {
            Lazy lazy = this.artifacts$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (Map)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> artifacts() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getArtifacts().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArtifactInfo artifactInfo = (ArtifactInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getId();
                collection.add(string);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final ArtifactInfo findArtifact(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.getArtifacts().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<GradleCoordinate> loadCompileDependencies(@NotNull String id, @NotNull GradleVersion version) {
            List<GradleCoordinate> list;
            InputStream stream;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            String file = StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + id + '/' + version + '/' + id + '-' + version + ".pom";
            InputStream inputStream = stream = GoogleMavenRepository.this.findData(file);
            if (inputStream == null) {
                list = null;
            } else {
                Closeable closeable = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    List<GradleCoordinate> list2 = this.readCompileDependenciesFromPomFile(stream, file);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            List<GradleCoordinate> list3 = list;
            return list3 == null ? CollectionsKt.emptyList() : list3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeIndex(Map<String, ArtifactInfo> map) {
            InputStream stream = GoogleMavenRepository.this.findData(Intrinsics.stringPlus((String)StringsKt.replace$default((String)this.pkg, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)"/group-index.xml"));
            InputStream inputStream = stream;
            if (inputStream != null) {
                Closeable closeable = inputStream;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    this.readGroupData(stream, map);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        private final void readGroupData(InputStream stream, Map<String, ArtifactInfo> map) {
            try {
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType != 2) continue;
                    String artifactId = parser.getName();
                    String versions = parser.getAttributeValue(null, "versions");
                    if (versions == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
                    ArtifactInfo artifactInfo = new ArtifactInfo(artifactId, versions);
                    Map<String, ArtifactInfo> map2 = map;
                    String string = artifactId;
                    boolean bl = false;
                    map2.put(string, artifactInfo);
                }
            }
            catch (XmlPullParserException parser) {
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, null);
            }
        }

        private final List<GradleCoordinate> readCompileDependenciesFromPomFile(InputStream stream, String file) {
            List list;
            try {
                boolean bl = false;
                List dependencies = new ArrayList();
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    GradleCoordinate dependency;
                    int eventType = parser.getEventType();
                    if (eventType != 2 || !Intrinsics.areEqual((Object)parser.getName(), (Object)"dependency") || (dependency = this.readCompileDependency(parser)) == null) continue;
                    dependencies.add(dependency);
                }
            }
            catch (XmlPullParserException e) {
                list = CollectionsKt.emptyList();
            }
            catch (Exception e) {
                GoogleMavenRepository.this.error(e, Intrinsics.stringPlus((String)"Problem reading POM file: ", (Object)file));
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final GradleCoordinate readCompileDependency(KXmlParser parser) {
            String groupId = "";
            String artifactId = "";
            String version = "";
            String scope = "";
            block16: while (parser.next() != 1) {
                int n = parser.getEventType();
                switch (n) {
                    case 2: {
                        String string = parser.getName();
                        if (string == null) continue block16;
                        int n2 = -1;
                        switch (string.hashCode()) {
                            case 293428218: {
                                if (string.equals("groupId")) {
                                    n2 = 1;
                                }
                                break;
                            }
                            case 109264468: {
                                if (string.equals("scope")) {
                                    n2 = 2;
                                }
                                break;
                            }
                            case 240640653: {
                                if (string.equals("artifactId")) {
                                    n2 = 3;
                                }
                                break;
                            }
                            case 351608024: {
                                if (string.equals("version")) {
                                    n2 = 4;
                                }
                                break;
                            }
                        }
                        switch (n2) {
                            case 1: {
                                String string2 = parser.nextText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.nextText()");
                                groupId = string2;
                                break;
                            }
                            case 3: {
                                String string2 = parser.nextText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.nextText()");
                                artifactId = string2;
                                break;
                            }
                            case 4: {
                                String string2 = parser.nextText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.nextText()");
                                version = string2;
                                break;
                            }
                            case 2: {
                                String string2 = parser.nextText();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.nextText()");
                                scope = string2;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual((Object)parser.getName(), (Object)"dependency")) continue block16;
                        this.check(groupId, "groupId");
                        this.check(artifactId, "artifactId");
                        this.check(version, "version");
                        return Intrinsics.areEqual((Object)scope, (Object)"compile") ? new GradleCoordinate(groupId, artifactId, version) : null;
                    }
                }
            }
            throw new RuntimeException("Unexpected end of file");
        }

        private final void check(String item, String name) {
            CharSequence charSequence = item;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw new RuntimeException("Missing " + name + " field");
            }
        }

        public static final /* synthetic */ void access$initializeIndex(PackageInfo $this, Map map) {
            $this.initializeIndex(map);
        }
    }
}

