/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.io.CancellableFileIo;
import com.android.repository.io.FileOpUtils;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;

public class MavenRepositories {
    private static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    private MavenRepositories() {
    }

    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, Path repository, Predicate<GradleVersion> filter2, boolean allowPreview) {
        Path versionDir = MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId);
        Path[] versions = FileOpUtils.listFiles((Path)versionDir);
        GradleCoordinate maxVersion = null;
        for (Path dir : versions) {
            GradleCoordinate gc;
            if (!CancellableFileIo.isDirectory((Path)dir, (LinkOption[])new LinkOption[0]) || (gc = GradleCoordinate.parseCoordinateString(groupId + ":" + artifactId + ":" + dir.getFileName())) == null || !allowPreview && MavenRepositories.isPreview(gc) || maxVersion != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(gc, maxVersion) <= 0 || !MavenRepositories.applyVersionPredicate(gc.getRevision(), filter2)) continue;
            maxVersion = gc;
        }
        return maxVersion;
    }

    private static boolean applyVersionPredicate(String revision, Predicate<GradleVersion> predicate) {
        if (predicate == null) {
            return true;
        }
        GradleVersion version = GradleVersion.tryParse(revision);
        return version != null && predicate.test(version);
    }

    public static GradleVersion getHighestVersion(Path versionDir, Predicate<GradleVersion> filter2, boolean allowPreview) {
        Path[] versionDirs = FileOpUtils.listFiles((Path)versionDir);
        GradleVersion maxVersion = null;
        for (Path dir : versionDirs) {
            GradleVersion version;
            String name;
            if (!CancellableFileIo.isDirectory((Path)dir, (LinkOption[])new LinkOption[0]) || (name = dir.getFileName().toString()).isEmpty() || !Character.isDigit(name.charAt(0)) || (version = GradleVersion.tryParse(name)) == null || !allowPreview && (version.isPreview() || filter2 != null && !filter2.test(version)) || maxVersion != null && version.compareTo(maxVersion) <= 0) continue;
            maxVersion = version;
        }
        return maxVersion;
    }

    public static boolean isPreview(GradleCoordinate coordinate) {
        if (coordinate.isPreview()) {
            return true;
        }
        return "com.google.android.gms".equals(coordinate.getGroupId()) && "play-services".equals(coordinate.getArtifactId()) && "5.2.08".equals(coordinate.getRevision());
    }

    public static boolean isAndroidX(String groupId) {
        return groupId.startsWith("androidx.");
    }

    public static Path getArtifactIdDirectory(Path repository, String groupId, String artifactId) {
        return repository.resolve(groupId.replace('.', File.separatorChar) + File.separator + artifactId);
    }

    public static Path getArtifactDirectory(Path repository, GradleCoordinate coordinate) {
        Path artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repository, coordinate.getGroupId(), coordinate.getArtifactId());
        return artifactIdDirectory.resolve(coordinate.getRevision());
    }

    public static Path getMavenMetadataFile(Path repository, String groupId, String artifactId) {
        return MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId).resolve(MAVEN_METADATA_FILE_NAME);
    }
}

