/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.gradle.VersionRange;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.KnownVersionStability;
import com.android.ide.common.repository.KnownVersionStabilityKt;
import com.google.common.base.Joiner;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public final class GradleCoordinate {
    private static final String NONE = "NONE";
    @Deprecated
    public static final String PREVIEW_ID = "rc";
    @Deprecated
    public static final PlusComponent PLUS_REV = new PlusComponent();
    @Deprecated
    public static final int PLUS_REV_VALUE = -1;
    private final String mGroupId;
    private final String mArtifactId;
    private final ArtifactType mArtifactType;
    private final List<RevisionComponent> mRevisions = new ArrayList<RevisionComponent>(3);
    private static final Pattern MAVEN_PATTERN = Pattern.compile("([\\w\\d\\.-]+):([\\w\\d\\.-]+):([^:@]+)(@[\\w-]+)?");
    @Deprecated
    public static final Comparator<GradleCoordinate> COMPARE_PLUS_LOWER = new GradleCoordinateComparator(-1);
    @Deprecated
    public static final Comparator<GradleCoordinate> COMPARE_PLUS_HIGHER = new GradleCoordinateComparator(1);

    @Deprecated
    public GradleCoordinate(String groupId, String artifactId, RevisionComponent ... revisions) {
        this(groupId, artifactId, Arrays.asList(revisions), null);
    }

    @Deprecated
    public GradleCoordinate(String groupId, String artifactId, String revision) {
        this(groupId, artifactId, GradleCoordinate.parseRevisionNumber(revision), null);
    }

    @Deprecated
    public GradleCoordinate(String groupId, String artifactId, int ... revisions) {
        this(groupId, artifactId, GradleCoordinate.createComponents(revisions), null);
    }

    @Deprecated
    private static List<RevisionComponent> createComponents(int[] revisions) {
        ArrayList<RevisionComponent> result2 = new ArrayList<RevisionComponent>(revisions.length);
        for (int revision : revisions) {
            if (revision == -1) {
                result2.add(PLUS_REV);
                continue;
            }
            result2.add(new NumberComponent(revision));
        }
        return result2;
    }

    @Deprecated
    public GradleCoordinate(String groupId, String artifactId, List<RevisionComponent> revisions, ArtifactType type) {
        this.mGroupId = groupId;
        this.mArtifactId = artifactId;
        this.mRevisions.addAll(revisions);
        this.mArtifactType = type;
    }

    @Deprecated
    public static GradleCoordinate parseCoordinateString(String coordinateString) {
        Matcher matcher = MAVEN_PATTERN.matcher(coordinateString);
        if (!matcher.matches()) {
            return null;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String revision = matcher.group(3);
        String typeString = matcher.group(4);
        ArtifactType type = null;
        if (typeString != null) {
            type = ArtifactType.getArtifactType(typeString.substring(1));
        }
        List<RevisionComponent> revisions = GradleCoordinate.parseRevisionNumber(revision);
        return new GradleCoordinate(groupId, artifactId, revisions, type);
    }

    @Deprecated
    public static GradleCoordinate parseVersionOnly(String revision) {
        return new GradleCoordinate(NONE, NONE, GradleCoordinate.parseRevisionNumber(revision), null);
    }

    @Deprecated
    public static List<RevisionComponent> parseRevisionNumber(String revision) {
        ArrayList<RevisionComponent> components = new ArrayList<RevisionComponent>();
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < revision.length(); ++i2) {
            char c = revision.charAt(i2);
            if (c == '.') {
                GradleCoordinate.flushBuffer(components, buffer, true);
                continue;
            }
            if (c == '+') {
                if (buffer.length() > 0) {
                    GradleCoordinate.flushBuffer(components, buffer, true);
                }
                components.add(PLUS_REV);
                break;
            }
            if (c == '-') {
                GradleCoordinate.flushBuffer(components, buffer, false);
                int last = components.size() - 1;
                if (last == -1) {
                    components.add(ListComponent.of(new NumberComponent(0)));
                    continue;
                }
                if (components.get(last) instanceof ListComponent) continue;
                components.set(last, ListComponent.of((RevisionComponent)components.get(last)));
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0 || components.isEmpty()) {
            GradleCoordinate.flushBuffer(components, buffer, true);
        }
        return components;
    }

    private static void flushBuffer(List<RevisionComponent> components, StringBuilder buffer, boolean closeList) {
        RevisionComponent newComponent;
        if (buffer.length() == 0) {
            newComponent = new NumberComponent(0);
        } else {
            String string = buffer.toString();
            try {
                int number = Integer.parseInt(string);
                newComponent = string.length() > 1 && string.charAt(0) == '0' ? new PaddedNumberComponent(number, string) : new NumberComponent(number);
            }
            catch (NumberFormatException e) {
                newComponent = new StringComponent(string);
            }
        }
        buffer.setLength(0);
        if (!components.isEmpty() && components.get(components.size() - 1) instanceof ListComponent) {
            ListComponent component = (ListComponent)components.get(components.size() - 1);
            if (!component.mClosed) {
                component.add(newComponent);
                if (closeList) {
                    component.mClosed = true;
                }
                return;
            }
        }
        components.add(newComponent);
    }

    public String toString() {
        Object s = String.format(Locale.US, "%s:%s:%s", this.mGroupId, this.mArtifactId, this.getRevision());
        if (this.mArtifactType != null) {
            s = (String)s + "@" + this.mArtifactType.toString();
        }
        return s;
    }

    public String getGroupId() {
        return this.mGroupId;
    }

    public String getArtifactId() {
        return this.mArtifactId;
    }

    @Deprecated
    public ArtifactType getArtifactType() {
        return this.mArtifactType;
    }

    @Deprecated
    public String getId() {
        if (this.mGroupId == null || this.mArtifactId == null) {
            return null;
        }
        return String.format("%s:%s", this.mGroupId, this.mArtifactId);
    }

    @Deprecated
    public ArtifactType getType() {
        return this.mArtifactType;
    }

    @Deprecated
    public boolean acceptsGreaterRevisions() {
        return !this.mRevisions.isEmpty() && this.mRevisions.get(this.mRevisions.size() - 1) == PLUS_REV;
    }

    @Deprecated
    public String getRevision() {
        StringBuilder revision = new StringBuilder();
        for (RevisionComponent component : this.mRevisions) {
            if (revision.length() > 0) {
                revision.append('.');
            }
            revision.append(component.toString());
        }
        return revision.toString();
    }

    private String getPrefix() {
        StringBuilder prefix = new StringBuilder();
        for (RevisionComponent component : this.mRevisions) {
            if (component == PLUS_REV) break;
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(component.toString());
        }
        if (prefix.length() == 0) {
            prefix.append("dev");
        }
        return prefix.toString();
    }

    public Version getLowerBoundVersion() {
        if (this.acceptsGreaterRevisions()) {
            return Version.prefixInfimum(this.getPrefix());
        }
        return Version.parse(this.getRevision());
    }

    public Version getUpperBoundVersion() {
        if (this.acceptsGreaterRevisions()) {
            return Version.prefixInfimum(this.getPrefix()).nextPrefix();
        }
        return Version.parse(this.getRevision());
    }

    @Deprecated
    public GradleVersion getVersion() {
        return GradleVersion.tryParse(this.getRevision());
    }

    public VersionRange getVersionRange() {
        String revision = this.getRevision();
        if (this.acceptsGreaterRevisions()) {
            return VersionRange.parse(revision);
        }
        Version version = Version.parse(this.getRevision());
        Component component = new Component(this.mGroupId, this.mArtifactId, version);
        KnownVersionStability stability = KnownVersionStabilityKt.getStability(component);
        return new VersionRange((Range<Version>)Range.closedOpen((Comparable)version, (Comparable)stability.expiration(version)));
    }

    @Deprecated
    public boolean isPreview() {
        return !this.mRevisions.isEmpty() && this.mRevisions.get(this.mRevisions.size() - 1).isPreview();
    }

    @Deprecated
    public int getMajorVersion() {
        return this.mRevisions.isEmpty() ? Integer.MIN_VALUE : this.mRevisions.get(0).asInteger();
    }

    @Deprecated
    public int getMinorVersion() {
        return this.mRevisions.size() < 2 ? Integer.MIN_VALUE : this.mRevisions.get(1).asInteger();
    }

    @Deprecated
    public int getMicroVersion() {
        return this.mRevisions.size() < 3 ? Integer.MIN_VALUE : this.mRevisions.get(2).asInteger();
    }

    @Deprecated
    public boolean isSameArtifact(GradleCoordinate o) {
        return o.mGroupId.equals(this.mGroupId) && o.mArtifactId.equals(this.mArtifactId);
    }

    @Deprecated
    public boolean matches(GradleCoordinate pattern) {
        if (!this.isSameArtifact(pattern)) {
            return false;
        }
        Iterator<RevisionComponent> thisRev = this.mRevisions.iterator();
        for (RevisionComponent thatRev : pattern.mRevisions) {
            if (thatRev instanceof PlusComponent) {
                return true;
            }
            if (!thisRev.hasNext() && thatRev.asInteger() != 0) {
                return false;
            }
            if (!thisRev.hasNext() || thatRev.equals(thisRev.next())) continue;
            return false;
        }
        while (thisRev.hasNext()) {
            if (thisRev.next().asInteger() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleCoordinate that = (GradleCoordinate)o;
        if (!this.mRevisions.equals(that.mRevisions)) {
            return false;
        }
        if (!this.mArtifactId.equals(that.mArtifactId)) {
            return false;
        }
        if (!this.mGroupId.equals(that.mGroupId)) {
            return false;
        }
        return Objects.equals((Object)this.mArtifactType, (Object)that.mArtifactType);
    }

    public int hashCode() {
        int result2 = this.mGroupId.hashCode();
        result2 = 31 * result2 + this.mArtifactId.hashCode();
        for (RevisionComponent component : this.mRevisions) {
            result2 = 31 * result2 + component.hashCode();
        }
        if (this.mArtifactType != null) {
            result2 = 31 * result2 + this.mArtifactType.hashCode();
        }
        return result2;
    }

    @Deprecated
    public static enum ArtifactType {
        POM("pom"),
        JAR("jar"),
        MAVEN_PLUGIN("maven-plugin"),
        EJB("ejb"),
        WAR("war"),
        EAR("ear"),
        RAR("rar"),
        PAR("par"),
        AAR("aar");

        private final String mId;

        private ArtifactType(String id) {
            this.mId = id;
        }

        @Deprecated
        public static ArtifactType getArtifactType(String name) {
            if (name != null) {
                for (ArtifactType type : ArtifactType.values()) {
                    if (!type.mId.equalsIgnoreCase(name)) continue;
                    return type;
                }
            }
            return null;
        }

        public String toString() {
            return this.mId;
        }
    }

    @Deprecated
    private static class PlusComponent
    extends RevisionComponent {
        private PlusComponent() {
        }

        public String toString() {
            return "+";
        }

        @Override
        public int asInteger() {
            return -1;
        }

        @Override
        public boolean isPreview() {
            return false;
        }

        @Override
        public int compareTo(RevisionComponent o) {
            throw new UnsupportedOperationException("Please use a specific comparator that knows how to handle +");
        }
    }

    @Deprecated
    public static class NumberComponent
    extends RevisionComponent {
        private final int mNumber;

        public NumberComponent(int number) {
            this.mNumber = number;
        }

        public String toString() {
            return Integer.toString(this.mNumber);
        }

        @Override
        public int asInteger() {
            return this.mNumber;
        }

        @Override
        public boolean isPreview() {
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof NumberComponent && ((NumberComponent)o).mNumber == this.mNumber;
        }

        public int hashCode() {
            return this.mNumber;
        }

        @Override
        public int compareTo(RevisionComponent o) {
            if (o instanceof NumberComponent) {
                return this.mNumber - ((NumberComponent)o).mNumber;
            }
            if (o instanceof StringComponent) {
                return 1;
            }
            if (o instanceof ListComponent) {
                return 1;
            }
            return 0;
        }
    }

    @Deprecated
    public static abstract class RevisionComponent
    implements Comparable<RevisionComponent> {
        public abstract int asInteger();

        public abstract boolean isPreview();
    }

    @Deprecated
    public static class ListComponent
    extends RevisionComponent {
        private final List<RevisionComponent> mItems = new ArrayList<RevisionComponent>();
        private boolean mClosed = false;

        public static ListComponent of(RevisionComponent ... components) {
            ListComponent result2 = new ListComponent();
            for (RevisionComponent component : components) {
                result2.add(component);
            }
            return result2;
        }

        public void add(RevisionComponent component) {
            this.mItems.add(component);
        }

        @Override
        public int asInteger() {
            return 0;
        }

        @Override
        public boolean isPreview() {
            return !this.mItems.isEmpty() && this.mItems.get(this.mItems.size() - 1).isPreview();
        }

        @Override
        public int compareTo(RevisionComponent o) {
            if (o instanceof NumberComponent) {
                return -1;
            }
            if (o instanceof StringComponent) {
                return 1;
            }
            if (o instanceof ListComponent) {
                ListComponent rhs = (ListComponent)o;
                for (int i2 = 0; i2 < this.mItems.size() && i2 < rhs.mItems.size(); ++i2) {
                    int rc = this.mItems.get(i2).compareTo(rhs.mItems.get(i2));
                    if (rc == 0) continue;
                    return rc;
                }
                return this.mItems.size() - rhs.mItems.size();
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof ListComponent && ((ListComponent)o).mItems.equals(this.mItems);
        }

        public int hashCode() {
            return this.mItems.hashCode();
        }

        public String toString() {
            return Joiner.on((String)"-").join(this.mItems);
        }
    }

    @Deprecated
    public static class PaddedNumberComponent
    extends NumberComponent {
        private final String mString;

        public PaddedNumberComponent(int number, String string) {
            super(number);
            this.mString = string;
        }

        @Override
        public String toString() {
            return this.mString;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PaddedNumberComponent && ((PaddedNumberComponent)o).mString.equals(this.mString);
        }

        @Override
        public int hashCode() {
            return this.mString.hashCode();
        }
    }

    @Deprecated
    public static class StringComponent
    extends RevisionComponent {
        private final String mString;

        public StringComponent(String string) {
            this.mString = string;
        }

        public String toString() {
            return this.mString;
        }

        @Override
        public int asInteger() {
            return 0;
        }

        @Override
        public boolean isPreview() {
            return this.mString.startsWith(GradleCoordinate.PREVIEW_ID) || this.mString.startsWith("alpha") || this.mString.startsWith("beta") || this.mString.equals("SNAPSHOT");
        }

        public boolean equals(Object o) {
            return o instanceof StringComponent && ((StringComponent)o).mString.equals(this.mString);
        }

        public int hashCode() {
            return this.mString.hashCode();
        }

        @Override
        public int compareTo(RevisionComponent o) {
            if (o instanceof NumberComponent) {
                return -1;
            }
            if (o instanceof StringComponent) {
                return this.mString.compareTo(((StringComponent)o).mString);
            }
            if (o instanceof ListComponent) {
                return -1;
            }
            return 0;
        }
    }

    private static class GradleCoordinateComparator
    implements Comparator<GradleCoordinate> {
        private final int mPlusResult;

        private GradleCoordinateComparator(int plusResult) {
            this.mPlusResult = plusResult;
        }

        @Override
        public int compare(GradleCoordinate a, GradleCoordinate b) {
            if (!a.isSameArtifact(b)) {
                return a.mArtifactId.compareTo(b.mArtifactId);
            }
            int sizeA = a.mRevisions.size();
            int sizeB = b.mRevisions.size();
            int common = Math.min(sizeA, sizeB);
            for (int i2 = 0; i2 < common; ++i2) {
                RevisionComponent revision1 = a.mRevisions.get(i2);
                RevisionComponent revision2 = b.mRevisions.get(i2);
                if (revision1 instanceof PlusComponent && revision2 instanceof PlusComponent) {
                    return 0;
                }
                if (revision1 instanceof PlusComponent) {
                    return this.mPlusResult;
                }
                if (revision2 instanceof PlusComponent) {
                    return -this.mPlusResult;
                }
                int delta = revision1.compareTo(revision2);
                if (delta == 0) continue;
                return delta;
            }
            if (sizeA != sizeB) {
                int returnValueIfNonZero;
                int to;
                int from;
                List<RevisionComponent> revisionList;
                if (sizeA < sizeB) {
                    revisionList = b.mRevisions;
                    from = sizeA;
                    to = sizeB;
                    returnValueIfNonZero = -1;
                } else {
                    revisionList = a.mRevisions;
                    from = sizeB;
                    to = sizeA;
                    returnValueIfNonZero = 1;
                }
                for (int i3 = from; i3 < to; ++i3) {
                    RevisionComponent revision = revisionList.get(i3);
                    if (revision instanceof NumberComponent) {
                        if (revision.asInteger() == 0) continue;
                        return returnValueIfNonZero;
                    }
                    return returnValueIfNonZero;
                }
            }
            return 0;
        }
    }
}

