/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.SymbolJavaType;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u0001:\n\u001f !\"#$%&'(B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\rH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u0082\u0001\u0003)*+\u00a8\u0006,"}, d2={"Lcom/android/ide/common/symbols/Symbol;", "", "<init>", "()V", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "canonicalName", "", "getCanonicalName", "()Ljava/lang/String;", "name", "getName", "getValue", "intValue", "", "getIntValue", "()I", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "Companion", "NormalSymbol", "NormalSymbolImpl", "BasicNormalSymbol", "AttributeSymbol", "AttributeSymbolImpl", "BasicAttributeSymbol", "StyleableSymbol", "StyleableSymbolImpl", "BasicStyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "sdk-common"})
public abstract class Symbol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final ImmutableList<String> NO_CHILDREN;

    private Symbol() {
    }

    @NotNull
    public abstract ResourceVisibility getResourceVisibility();

    @NotNull
    public abstract ResourceType getResourceType();

    @NotNull
    public abstract String getCanonicalName();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getValue();

    public abstract int getIntValue();

    @NotNull
    public abstract SymbolJavaType getJavaType();

    @NotNull
    public abstract ImmutableList<String> getChildren();

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition, boolean validation) {
        return Companion.createSymbol(resourceType, name, idProvider, isMaybeDefinition, validation);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition, boolean validation) {
        return Companion.createSymbol(resourceType, name, value, isMaybeDefinition, validation);
    }

    @JvmStatic
    @NotNull
    public static final StyleableSymbol createStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children, boolean validation) {
        return Companion.createStyleableSymbol(name, values, children, validation);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
        return Companion.normalSymbol(resourceType, name, intValue, resourceVisibility, canonicalName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
        return Companion.attributeSymbol(name, intValue, isMaybeDefinition, resourceVisibility, canonicalName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
        return Companion.styleableSymbol(name, values, children, resourceVisibility, canonicalName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition) {
        return Companion.createSymbol(resourceType, name, idProvider, isMaybeDefinition);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
        return Companion.createSymbol(resourceType, name, idProvider);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition) {
        return Companion.createSymbol(resourceType, name, value, isMaybeDefinition);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
        return Companion.createSymbol(resourceType, name, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility) {
        return Companion.normalSymbol(resourceType, name, intValue, resourceVisibility);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue) {
        return Companion.normalSymbol(resourceType, name, intValue);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name) {
        return Companion.normalSymbol(resourceType, name);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility) {
        return Companion.attributeSymbol(name, intValue, isMaybeDefinition, resourceVisibility);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition) {
        return Companion.attributeSymbol(name, intValue, isMaybeDefinition);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AttributeSymbol attributeSymbol(@NotNull String name, int intValue) {
        return Companion.attributeSymbol(name, intValue);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AttributeSymbol attributeSymbol(@NotNull String name) {
        return Companion.attributeSymbol(name);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility) {
        return Companion.styleableSymbol(name, values, children, resourceVisibility);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children) {
        return Companion.styleableSymbol(name, values, children);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<String> children) {
        return Companion.styleableSymbol(name, children);
    }

    public /* synthetic */ Symbol(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
        NO_CHILDREN = immutableList;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "<init>", "()V", "isMaybeDefinition", "", "()Z", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getValue", "", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "toString", "sdk-common"})
    public static abstract class AttributeSymbol
    extends Symbol {
        public AttributeSymbol() {
            super(null);
        }

        public abstract boolean isMaybeDefinition();

        @Override
        @NotNull
        public final ResourceType getResourceType() {
            return ResourceType.ATTR;
        }

        @Override
        @NotNull
        public final SymbolJavaType getJavaType() {
            return SymbolJavaType.INT;
        }

        @Override
        @NotNull
        public final String getValue() {
            return "0x" + Integer.toHexString(this.getIntValue());
        }

        @Override
        @NotNull
        public final ImmutableList<String> getChildren() {
            throw new UnsupportedOperationException("Attributes cannot have children.");
        }

        @NotNull
        public final String toString() {
            String maybeSuffix = this.isMaybeDefinition() ? "?" : "";
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            ResourceType resourceType = this.getResourceType();
            String string = this.getCanonicalName();
            String string2 = Integer.toString(this.getIntValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return resourceVisibility + " " + resourceType + maybeSuffix + " " + string + " = 0x" + string2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/android/ide/common/symbols/Symbol$AttributeSymbolImpl;", "Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "name", "", "intValue", "", "isMaybeDefinition", "", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "<init>", "(Ljava/lang/String;IZLcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getIntValue", "()I", "()Z", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getCanonicalName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "sdk-common"})
    public static final class AttributeSymbolImpl
    extends AttributeSymbol {
        @NotNull
        private final String name;
        private final int intValue;
        private final boolean isMaybeDefinition;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        public AttributeSymbolImpl(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            this.name = name;
            this.intValue = intValue;
            this.isMaybeDefinition = isMaybeDefinition;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
        }

        public /* synthetic */ AttributeSymbolImpl(String string, int n, boolean bl, ResourceVisibility resourceVisibility, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n2 & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            this(string, n, bl, resourceVisibility, string2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        public boolean isMaybeDefinition() {
            return this.isMaybeDefinition;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.intValue;
        }

        public final boolean component3() {
            return this.isMaybeDefinition;
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.resourceVisibility;
        }

        @NotNull
        public final String component5() {
            return this.canonicalName;
        }

        @NotNull
        public final AttributeSymbolImpl copy(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return new AttributeSymbolImpl(name, intValue, isMaybeDefinition, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ AttributeSymbolImpl copy$default(AttributeSymbolImpl attributeSymbolImpl, String string, int n, boolean bl, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = attributeSymbolImpl.name;
            }
            if ((n2 & 2) != 0) {
                n = attributeSymbolImpl.intValue;
            }
            if ((n2 & 4) != 0) {
                bl = attributeSymbolImpl.isMaybeDefinition;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = attributeSymbolImpl.resourceVisibility;
            }
            if ((n2 & 0x10) != 0) {
                string2 = attributeSymbolImpl.canonicalName;
            }
            return attributeSymbolImpl.copy(string, n, bl, resourceVisibility, string2);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.intValue);
            result2 = result2 * 31 + Boolean.hashCode(this.isMaybeDefinition);
            result2 = result2 * 31 + this.resourceVisibility.hashCode();
            result2 = result2 * 31 + this.canonicalName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttributeSymbolImpl)) {
                return false;
            }
            AttributeSymbolImpl attributeSymbolImpl = (AttributeSymbolImpl)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)attributeSymbolImpl.name)) {
                return false;
            }
            if (this.intValue != attributeSymbolImpl.intValue) {
                return false;
            }
            if (this.isMaybeDefinition != attributeSymbolImpl.isMaybeDefinition) {
                return false;
            }
            if (this.resourceVisibility != attributeSymbolImpl.resourceVisibility) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.canonicalName, (Object)attributeSymbolImpl.canonicalName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/android/ide/common/symbols/Symbol$BasicAttributeSymbol;", "Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "intValue", "", "getIntValue", "()I", "isMaybeDefinition", "", "()Z", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "canonicalName", "getCanonicalName", "component1", "copy", "equals", "other", "", "hashCode", "sdk-common"})
    public static final class BasicAttributeSymbol
    extends AttributeSymbol {
        @NotNull
        private final String name;

        public BasicAttributeSymbol(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return 0;
        }

        @Override
        public boolean isMaybeDefinition() {
            return false;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return ResourceVisibility.UNDEFINED;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.getName();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final BasicAttributeSymbol copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BasicAttributeSymbol(name);
        }

        public static /* synthetic */ BasicAttributeSymbol copy$default(BasicAttributeSymbol basicAttributeSymbol, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = basicAttributeSymbol.name;
            }
            return basicAttributeSymbol.copy(string);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BasicAttributeSymbol)) {
                return false;
            }
            BasicAttributeSymbol basicAttributeSymbol = (BasicAttributeSymbol)other;
            return Intrinsics.areEqual((Object)this.name, (Object)basicAttributeSymbol.name);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\rH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/android/ide/common/symbols/Symbol$BasicNormalSymbol;", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "", "<init>", "(Lcom/android/resources/ResourceType;Ljava/lang/String;)V", "getResourceType", "()Lcom/android/resources/ResourceType;", "getName", "()Ljava/lang/String;", "intValue", "", "getIntValue", "()I", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "canonicalName", "getCanonicalName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "sdk-common"})
    public static final class BasicNormalSymbol
    extends NormalSymbol {
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final String name;

        public BasicNormalSymbol(@NotNull ResourceType resourceType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.resourceType = resourceType;
            this.name = name;
        }

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return 0;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return ResourceVisibility.UNDEFINED;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.getName();
        }

        @NotNull
        public final ResourceType component1() {
            return this.resourceType;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final BasicNormalSymbol copy(@NotNull ResourceType resourceType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new BasicNormalSymbol(resourceType, name);
        }

        public static /* synthetic */ BasicNormalSymbol copy$default(BasicNormalSymbol basicNormalSymbol, ResourceType resourceType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                resourceType = basicNormalSymbol.resourceType;
            }
            if ((n & 2) != 0) {
                string = basicNormalSymbol.name;
            }
            return basicNormalSymbol.copy(resourceType, string);
        }

        public int hashCode() {
            int result2 = this.resourceType.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BasicNormalSymbol)) {
                return false;
            }
            BasicNormalSymbol basicNormalSymbol = (BasicNormalSymbol)other;
            if (this.resourceType != basicNormalSymbol.resourceType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)basicNormalSymbol.name);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/android/ide/common/symbols/Symbol$BasicStyleableSymbol;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "name", "", "children", "Lcom/google/common/collect/ImmutableList;", "<init>", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableList;)V", "getName", "()Ljava/lang/String;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "values", "", "getValues", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "canonicalName", "getCanonicalName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "sdk-common"})
    public static final class BasicStyleableSymbol
    extends StyleableSymbol {
        @NotNull
        private final String name;
        @NotNull
        private final ImmutableList<String> children;

        public BasicStyleableSymbol(@NotNull String name, @NotNull ImmutableList<String> children) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.name = name;
            this.children = children;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            return this.children;
        }

        @Override
        @NotNull
        public ImmutableList<Integer> getValues() {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return immutableList;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return ResourceVisibility.UNDEFINED;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.getName();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ImmutableList<String> component2() {
            return this.children;
        }

        @NotNull
        public final BasicStyleableSymbol copy(@NotNull String name, @NotNull ImmutableList<String> children) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new BasicStyleableSymbol(name, children);
        }

        public static /* synthetic */ BasicStyleableSymbol copy$default(BasicStyleableSymbol basicStyleableSymbol, String string, ImmutableList immutableList, int n, Object object) {
            if ((n & 1) != 0) {
                string = basicStyleableSymbol.name;
            }
            if ((n & 2) != 0) {
                immutableList = basicStyleableSymbol.children;
            }
            return basicStyleableSymbol.copy(string, immutableList);
        }

        @NotNull
        public String toString() {
            return "BasicStyleableSymbol(name=" + this.name + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.children.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BasicStyleableSymbol)) {
                return false;
            }
            BasicStyleableSymbol basicStyleableSymbol = (BasicStyleableSymbol)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)basicStyleableSymbol.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.children, basicStyleableSymbol.children);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00122\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0006H\u0007J8\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00122\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0006H\u0007JB\u0010\"\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00062\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0006H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/ide/common/symbols/Symbol$Companion;", "", "<init>", "()V", "NO_CHILDREN", "Lcom/google/common/collect/ImmutableList;", "", "createSymbol", "Lcom/android/ide/common/symbols/Symbol;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "isMaybeDefinition", "", "validation", "value", "", "createStyleableSymbol", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "values", "children", "", "validateSymbol", "", "normalSymbol", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "intValue", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "attributeSymbol", "Lcom/android/ide/common/symbols/Symbol$AttributeSymbol;", "styleableSymbol", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition, boolean validation) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
            return this.createSymbol(resourceType, name, idProvider.next(resourceType), isMaybeDefinition, validation);
        }

        public static /* synthetic */ Symbol createSymbol$default(Companion companion, ResourceType resourceType, String string, IdProvider idProvider, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            return companion.createSymbol(resourceType, string, idProvider, bl, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition, boolean validation) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (validation) {
                this.validateSymbol(name, resourceType);
            }
            return resourceType == ResourceType.ATTR ? (Symbol)com.android.ide.common.symbols.Symbol$Companion.attributeSymbol$default(this, name, value, isMaybeDefinition, null, null, 24, null) : (Symbol)com.android.ide.common.symbols.Symbol$Companion.normalSymbol$default(this, resourceType, name, value, null, null, 24, null);
        }

        public static /* synthetic */ Symbol createSymbol$default(Companion companion, ResourceType resourceType, String string, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = true;
            }
            return companion.createSymbol(resourceType, string, n, bl, bl2);
        }

        @JvmStatic
        @NotNull
        public final StyleableSymbol createStyleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull List<String> children, boolean validation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            if (validation) {
                this.validateSymbol(name, ResourceType.STYLEABLE);
            }
            String string = SymbolUtils.canonicalizeValueResourceName(name);
            ImmutableList immutableList = ImmutableList.copyOf((Collection)children);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            ImmutableList immutableList2 = immutableList;
            return com.android.ide.common.symbols.Symbol$Companion.styleableSymbol$default(this, name, values, immutableList2, null, string, 8, null);
        }

        public static /* synthetic */ StyleableSymbol createStyleableSymbol$default(Companion companion, String string, ImmutableList immutableList, List list, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.createStyleableSymbol(string, (ImmutableList<Integer>)immutableList, list, bl);
        }

        private final void validateSymbol(String name, ResourceType resourceType) {
            try {
                ValueResourceNameValidator.validate(name, resourceType, null);
            }
            catch (MergingException e) {
                throw new IllegalArgumentException("Validation of a resource with name '" + name + "' and type '" + resourceType.getName() + "' failed.'", e);
            }
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            Preconditions.checkArgument((resourceType != ResourceType.STYLEABLE ? 1 : 0) != 0, (String)"Internal Error: Styleables must be represented by StyleableSymbol.", (Object[])new Object[0]);
            Preconditions.checkArgument((resourceType != ResourceType.ATTR ? 1 : 0) != 0, (String)"Internal Error: Attributes must be represented by AttributeSymbol.", (Object[])new Object[0]);
            if (intValue == 0 && resourceVisibility == ResourceVisibility.UNDEFINED && Intrinsics.areEqual((Object)canonicalName, (Object)name)) {
                return new BasicNormalSymbol(resourceType, name);
            }
            return new NormalSymbolImpl(resourceType, name, intValue, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ NormalSymbol normalSymbol$default(Companion companion, ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n2 & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            return companion.normalSymbol(resourceType, string, n, resourceVisibility, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            if (intValue == 0 && !isMaybeDefinition && resourceVisibility == ResourceVisibility.UNDEFINED && Intrinsics.areEqual((Object)canonicalName, (Object)name)) {
                return new BasicAttributeSymbol(name);
            }
            return new AttributeSymbolImpl(name, intValue, isMaybeDefinition, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ AttributeSymbol attributeSymbol$default(Companion companion, String string, int n, boolean bl, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n2 & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            return companion.attributeSymbol(string, n, bl, resourceVisibility, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            if (values.isEmpty() && resourceVisibility == ResourceVisibility.UNDEFINED && Intrinsics.areEqual((Object)canonicalName, (Object)name)) {
                return new BasicStyleableSymbol(name, children);
            }
            return new StyleableSymbolImpl(name, values, children, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ StyleableSymbol styleableSymbol$default(Companion companion, String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                ImmutableList immutableList3 = ImmutableList.of();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList3, (String)"of(...)");
                immutableList = immutableList3;
            }
            if ((n & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            return companion.styleableSymbol(string, (ImmutableList<Integer>)immutableList, (ImmutableList<String>)immutableList2, resourceVisibility, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider, boolean isMaybeDefinition) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
            return com.android.ide.common.symbols.Symbol$Companion.createSymbol$default(this, resourceType, name, idProvider, isMaybeDefinition, false, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, @NotNull IdProvider idProvider) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
            return com.android.ide.common.symbols.Symbol$Companion.createSymbol$default(this, resourceType, name, idProvider, false, false, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value, boolean isMaybeDefinition) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.createSymbol$default(this, resourceType, name, value, isMaybeDefinition, false, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Symbol createSymbol(@NotNull ResourceType resourceType, @NotNull String name, int value) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.createSymbol$default(this, resourceType, name, value, false, false, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            return com.android.ide.common.symbols.Symbol$Companion.normalSymbol$default(this, resourceType, name, intValue, resourceVisibility, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name, int intValue) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.normalSymbol$default(this, resourceType, name, intValue, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final NormalSymbol normalSymbol(@NotNull ResourceType resourceType, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.normalSymbol$default(this, resourceType, name, 0, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            return com.android.ide.common.symbols.Symbol$Companion.attributeSymbol$default(this, name, intValue, isMaybeDefinition, resourceVisibility, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AttributeSymbol attributeSymbol(@NotNull String name, int intValue, boolean isMaybeDefinition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.attributeSymbol$default(this, name, intValue, isMaybeDefinition, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AttributeSymbol attributeSymbol(@NotNull String name, int intValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.attributeSymbol$default(this, name, intValue, false, null, null, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AttributeSymbol attributeSymbol(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return com.android.ide.common.symbols.Symbol$Companion.attributeSymbol$default(this, name, 0, false, null, null, 30, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            return com.android.ide.common.symbols.Symbol$Companion.styleableSymbol$default(this, name, values, children, resourceVisibility, null, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return com.android.ide.common.symbols.Symbol$Companion.styleableSymbol$default(this, name, values, children, null, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final StyleableSymbol styleableSymbol(@NotNull String name, @NotNull ImmutableList<String> children) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return com.android.ide.common.symbols.Symbol$Companion.styleableSymbol$default(this, name, null, children, null, null, 26, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "<init>", "()V", "toString", "", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "getValue", "children", "Lcom/google/common/collect/ImmutableList;", "getChildren", "()Lcom/google/common/collect/ImmutableList;", "sdk-common"})
    public static abstract class NormalSymbol
    extends Symbol {
        public NormalSymbol() {
            super(null);
        }

        @NotNull
        public final String toString() {
            ResourceVisibility resourceVisibility = this.getResourceVisibility();
            ResourceType resourceType = this.getResourceType();
            String string = this.getCanonicalName();
            String string2 = Integer.toString(this.getIntValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return resourceVisibility + " " + resourceType + " " + string + " = 0x" + string2;
        }

        @Override
        @NotNull
        public final SymbolJavaType getJavaType() {
            return SymbolJavaType.INT;
        }

        @Override
        @NotNull
        public final String getValue() {
            return "0x" + Integer.toHexString(this.getIntValue());
        }

        @Override
        @NotNull
        public final ImmutableList<String> getChildren() {
            throw new UnsupportedOperationException("Only styleables have children.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/android/ide/common/symbols/Symbol$NormalSymbolImpl;", "Lcom/android/ide/common/symbols/Symbol$NormalSymbol;", "resourceType", "Lcom/android/resources/ResourceType;", "name", "", "intValue", "", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "<init>", "(Lcom/android/resources/ResourceType;Ljava/lang/String;ILcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getResourceType", "()Lcom/android/resources/ResourceType;", "getName", "()Ljava/lang/String;", "getIntValue", "()I", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getCanonicalName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "sdk-common"})
    public static final class NormalSymbolImpl
    extends NormalSymbol {
        @NotNull
        private final ResourceType resourceType;
        @NotNull
        private final String name;
        private final int intValue;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        public NormalSymbolImpl(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            this.resourceType = resourceType;
            this.name = name;
            this.intValue = intValue;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
        }

        @Override
        @NotNull
        public ResourceType getResourceType() {
            return this.resourceType;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public int getIntValue() {
            return this.intValue;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @NotNull
        public final ResourceType component1() {
            return this.resourceType;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final int component3() {
            return this.intValue;
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.resourceVisibility;
        }

        @NotNull
        public final String component5() {
            return this.canonicalName;
        }

        @NotNull
        public final NormalSymbolImpl copy(@NotNull ResourceType resourceType, @NotNull String name, int intValue, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)resourceType, (String)"resourceType");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return new NormalSymbolImpl(resourceType, name, intValue, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ NormalSymbolImpl copy$default(NormalSymbolImpl normalSymbolImpl, ResourceType resourceType, String string, int n, ResourceVisibility resourceVisibility, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                resourceType = normalSymbolImpl.resourceType;
            }
            if ((n2 & 2) != 0) {
                string = normalSymbolImpl.name;
            }
            if ((n2 & 4) != 0) {
                n = normalSymbolImpl.intValue;
            }
            if ((n2 & 8) != 0) {
                resourceVisibility = normalSymbolImpl.resourceVisibility;
            }
            if ((n2 & 0x10) != 0) {
                string2 = normalSymbolImpl.canonicalName;
            }
            return normalSymbolImpl.copy(resourceType, string, n, resourceVisibility, string2);
        }

        public int hashCode() {
            int result2 = this.resourceType.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.intValue);
            result2 = result2 * 31 + this.resourceVisibility.hashCode();
            result2 = result2 * 31 + this.canonicalName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NormalSymbolImpl)) {
                return false;
            }
            NormalSymbolImpl normalSymbolImpl = (NormalSymbolImpl)other;
            if (this.resourceType != normalSymbolImpl.resourceType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)normalSymbolImpl.name)) {
                return false;
            }
            if (this.intValue != normalSymbolImpl.intValue) {
                return false;
            }
            if (this.resourceVisibility != normalSymbolImpl.resourceVisibility) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.canonicalName, (Object)normalSymbolImpl.canonicalName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "Lcom/android/ide/common/symbols/Symbol;", "<init>", "()V", "resourceType", "Lcom/android/resources/ResourceType;", "getResourceType", "()Lcom/android/resources/ResourceType;", "intValue", "", "getIntValue", "()I", "values", "Lcom/google/common/collect/ImmutableList;", "getValues", "()Lcom/google/common/collect/ImmutableList;", "getValue", "", "javaType", "Lcom/android/ide/common/symbols/SymbolJavaType;", "getJavaType", "()Lcom/android/ide/common/symbols/SymbolJavaType;", "sdk-common"})
    public static abstract class StyleableSymbol
    extends Symbol {
        public StyleableSymbol() {
            super(null);
        }

        @Override
        @NotNull
        public final ResourceType getResourceType() {
            return ResourceType.STYLEABLE;
        }

        @Override
        public final int getIntValue() {
            throw new UnsupportedOperationException("Styleables have no int value");
        }

        @NotNull
        public abstract ImmutableList<Integer> getValues();

        @Override
        @NotNull
        public final String getValue() {
            StringBuilder stringBuilder;
            StringBuilder $this$getValue_u24lambda_u240 = stringBuilder = new StringBuilder(this.getValues().size() * 12 + 2);
            boolean bl = false;
            $this$getValue_u24lambda_u240.append("{ ");
            int n = this.getValues().size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    $this$getValue_u24lambda_u240.append(", ");
                }
                $this$getValue_u24lambda_u240.append("0x");
                Object object = this.getValues().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                $this$getValue_u24lambda_u240.append(Integer.toHexString(((Number)object).intValue()));
            }
            $this$getValue_u24lambda_u240.append(" }");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        @NotNull
        public final SymbolJavaType getJavaType() {
            return SymbolJavaType.INT_LIST;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JG\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/android/ide/common/symbols/Symbol$StyleableSymbolImpl;", "Lcom/android/ide/common/symbols/Symbol$StyleableSymbol;", "name", "", "values", "Lcom/google/common/collect/ImmutableList;", "", "children", "resourceVisibility", "Lcom/android/resources/ResourceVisibility;", "canonicalName", "<init>", "(Ljava/lang/String;Lcom/google/common/collect/ImmutableList;Lcom/google/common/collect/ImmutableList;Lcom/android/resources/ResourceVisibility;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValues", "()Lcom/google/common/collect/ImmutableList;", "getChildren", "getResourceVisibility", "()Lcom/android/resources/ResourceVisibility;", "getCanonicalName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "sdk-common"})
    public static final class StyleableSymbolImpl
    extends StyleableSymbol {
        @NotNull
        private final String name;
        @NotNull
        private final ImmutableList<Integer> values;
        @NotNull
        private final ImmutableList<String> children;
        @NotNull
        private final ResourceVisibility resourceVisibility;
        @NotNull
        private final String canonicalName;

        public StyleableSymbolImpl(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            this.name = name;
            this.values = values;
            this.children = children;
            this.resourceVisibility = resourceVisibility;
            this.canonicalName = canonicalName;
        }

        public /* synthetic */ StyleableSymbolImpl(String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                resourceVisibility = ResourceVisibility.UNDEFINED;
            }
            if ((n & 0x10) != 0) {
                string2 = SymbolUtils.canonicalizeValueResourceName(string);
            }
            this(string, (ImmutableList<Integer>)immutableList, (ImmutableList<String>)immutableList2, resourceVisibility, string2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public ImmutableList<Integer> getValues() {
            return this.values;
        }

        @Override
        @NotNull
        public ImmutableList<String> getChildren() {
            return this.children;
        }

        @Override
        @NotNull
        public ResourceVisibility getResourceVisibility() {
            return this.resourceVisibility;
        }

        @Override
        @NotNull
        public String getCanonicalName() {
            return this.canonicalName;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ImmutableList<Integer> component2() {
            return this.values;
        }

        @NotNull
        public final ImmutableList<String> component3() {
            return this.children;
        }

        @NotNull
        public final ResourceVisibility component4() {
            return this.resourceVisibility;
        }

        @NotNull
        public final String component5() {
            return this.canonicalName;
        }

        @NotNull
        public final StyleableSymbolImpl copy(@NotNull String name, @NotNull ImmutableList<Integer> values, @NotNull ImmutableList<String> children, @NotNull ResourceVisibility resourceVisibility, @NotNull String canonicalName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter((Object)resourceVisibility, (String)"resourceVisibility");
            Intrinsics.checkNotNullParameter((Object)canonicalName, (String)"canonicalName");
            return new StyleableSymbolImpl(name, values, children, resourceVisibility, canonicalName);
        }

        public static /* synthetic */ StyleableSymbolImpl copy$default(StyleableSymbolImpl styleableSymbolImpl, String string, ImmutableList immutableList, ImmutableList immutableList2, ResourceVisibility resourceVisibility, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = styleableSymbolImpl.name;
            }
            if ((n & 2) != 0) {
                immutableList = styleableSymbolImpl.values;
            }
            if ((n & 4) != 0) {
                immutableList2 = styleableSymbolImpl.children;
            }
            if ((n & 8) != 0) {
                resourceVisibility = styleableSymbolImpl.resourceVisibility;
            }
            if ((n & 0x10) != 0) {
                string2 = styleableSymbolImpl.canonicalName;
            }
            return styleableSymbolImpl.copy(string, immutableList, immutableList2, resourceVisibility, string2);
        }

        @NotNull
        public String toString() {
            return "StyleableSymbolImpl(name=" + this.name + ", values=" + this.values + ", children=" + this.children + ", resourceVisibility=" + this.resourceVisibility + ", canonicalName=" + this.canonicalName + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.values.hashCode();
            result2 = result2 * 31 + this.children.hashCode();
            result2 = result2 * 31 + this.resourceVisibility.hashCode();
            result2 = result2 * 31 + this.canonicalName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StyleableSymbolImpl)) {
                return false;
            }
            StyleableSymbolImpl styleableSymbolImpl = (StyleableSymbolImpl)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)styleableSymbolImpl.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, styleableSymbolImpl.values)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.children, styleableSymbolImpl.children)) {
                return false;
            }
            if (this.resourceVisibility != styleableSymbolImpl.resourceVisibility) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.canonicalName, (Object)styleableSymbolImpl.canonicalName);
        }
    }
}

