/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locale {
    private static final String DEFAULT_LOCALE_LABEL = "Default (en-us)";
    private static final LocaleQualifier ANY_QUALIFIER = new LocaleQualifier("__");
    public static final Locale ANY = new Locale(ANY_QUALIFIER);
    @NotNull
    public final LocaleQualifier qualifier;
    public static final Comparator<Locale> SCRIPT_CODE_COMPARATOR = Comparator.comparing(locale -> locale.qualifier.getScript(), Comparator.nullsFirst(Comparator.naturalOrder()));
    public static final Comparator<Locale> REGION_NAME_COMPARATOR = Comparator.comparing(locale -> locale.qualifier.getRegion(), Comparator.nullsFirst(Comparator.comparing(LocaleManager::getRegionName)));
    public static final Comparator<Locale> LANGUAGE_NAME_COMPARATOR = Comparator.comparing(locale -> locale.qualifier.hasLanguage() ? LocaleManager.getLanguageName(locale.qualifier.getLanguage()) : null, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(REGION_NAME_COMPARATOR).thenComparing(SCRIPT_CODE_COMPARATOR);
    public static final Comparator<Locale> REGION_CODE_COMPARATOR = Comparator.comparing(locale -> locale.qualifier.getRegion(), Comparator.nullsFirst(Comparator.naturalOrder()));
    public static final Comparator<Locale> LANGUAGE_CODE_COMPARATOR = Comparator.comparing(locale -> locale.qualifier.hasLanguage() ? locale.qualifier.getLanguage() : null, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(REGION_CODE_COMPARATOR).thenComparing(SCRIPT_CODE_COMPARATOR);

    private Locale(@NotNull LocaleQualifier locale) {
        this.qualifier = locale;
    }

    @NotNull
    public static Locale create(@NotNull LocaleQualifier locale) {
        return new Locale(locale);
    }

    public static Locale create(FolderConfiguration folder) {
        LocaleQualifier locale = folder.getLocaleQualifier();
        if (locale == null) {
            return ANY;
        }
        return new Locale(locale);
    }

    @NotNull
    public static Locale create(@NotNull String localeString) {
        LocaleQualifier qualifier = LocaleQualifier.getQualifier(localeString);
        if (qualifier != null) {
            return new Locale(qualifier);
        }
        return ANY;
    }

    public boolean hasLanguage() {
        return !this.qualifier.hasFakeValue() && this.qualifier.hasLanguage();
    }

    public boolean hasRegion() {
        return this.qualifier.getRegion() != null && !"__".equals(this.qualifier.getRegion());
    }

    public String toLocaleId() {
        return this.qualifier == ANY_QUALIFIER ? "" : this.qualifier.getTag();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.qualifier.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        return this.qualifier.equals(other.qualifier);
    }

    public String toString() {
        return this.qualifier.getTag();
    }

    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        String label = Locale.getLocaleLabelWithoutScript(locale, brief);
        return locale != null && locale.qualifier.hasScript() ? label + " [" + locale.qualifier.getScript() + "]" : label;
    }

    public static String getLocaleLabelWithoutScript(@Nullable Locale locale, boolean brief) {
        if (locale == null || !locale.hasLanguage()) {
            return DEFAULT_LOCALE_LABEL;
        }
        String languageCode = locale.qualifier.getLanguage();
        assert (languageCode != null);
        String languageName = LocaleManager.getLanguageName(languageCode);
        if (!locale.hasRegion()) {
            if (languageName != null) {
                return String.format("%1$s (%2$s)", languageName, languageCode);
            }
            return languageCode;
        }
        String regionCode = locale.qualifier.getRegion();
        assert (regionCode != null) : locale.qualifier;
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName(regionCode);
            if (regionName != null) {
                return String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
            }
            return String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
        }
        return String.format("%1$s (%2$s / %3$s)", languageName, languageCode, regionCode);
    }
}

