/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.SdkConstants;
import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002)*B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H$J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u000bH\u0015J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0003H$J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H%R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/ide/common/repository/NetworkCache;", "", "baseUrl", "", "cacheKey", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "networkEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;IIZ)V", "RESERVED_WINDOWS_FILE_NAMES", "", "getCacheDir", "()Ljava/nio/file/Path;", "lastReadSourceType", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "getLastReadSourceType", "()Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "setLastReadSourceType", "(Lcom/android/ide/common/repository/NetworkCache$DataSourceType;)V", "encode", "it", "error", "", "throwable", "", "message", "findData", "Ljava/io/InputStream;", "relative", "treatAsDirectory", "readDefaultData", "readUrlData", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "url", "timeout", "lastModified", "", "DataSourceType", "ReadUrlDataResult", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nNetworkCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkCache.kt\ncom/android/ide/common/repository/NetworkCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public abstract class NetworkCache {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String cacheKey;
    @Nullable
    private final Path cacheDir;
    private final int networkTimeoutMs;
    private final int cacheExpiryHours;
    private final boolean networkEnabled;
    @NotNull
    private final Set<String> RESERVED_WINDOWS_FILE_NAMES;
    @NotNull
    private DataSourceType lastReadSourceType;

    public NetworkCache(@NotNull String baseUrl, @NotNull String cacheKey, @Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean networkEnabled) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        this.baseUrl = baseUrl;
        this.cacheKey = cacheKey;
        this.cacheDir = cacheDir;
        this.networkTimeoutMs = networkTimeoutMs;
        this.cacheExpiryHours = cacheExpiryHours;
        this.networkEnabled = networkEnabled;
        Object[] objectArray = new String[]{"CON", "PRN", "AUX", "NUL", "COM0", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b9", "COM\u00b2", "COM\u00b3", "LPT0", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b9", "LPT\u00b2", "LPT\u00b3"};
        this.RESERVED_WINDOWS_FILE_NAMES = SetsKt.setOf((Object[])objectArray);
        this.lastReadSourceType = DataSourceType.UNKNOWN_SOURCE;
    }

    public /* synthetic */ NetworkCache(String string, String string2, Path path, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            path = null;
        }
        if ((n3 & 8) != 0) {
            n = 3000;
        }
        if ((n3 & 0x10) != 0) {
            n2 = (int)TimeUnit.DAYS.toHours(7L);
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        this(string, string2, path, n, n2, bl);
    }

    @Nullable
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    protected final DataSourceType getLastReadSourceType() {
        return this.lastReadSourceType;
    }

    protected final void setLastReadSourceType(@NotNull DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)((Object)dataSourceType), (String)"<set-?>");
        this.lastReadSourceType = dataSourceType;
    }

    @Slow
    @NotNull
    protected abstract ReadUrlDataResult readUrlData(@NotNull String var1, int var2, long var3);

    @Nullable
    protected abstract InputStream readDefaultData(@NotNull String var1);

    protected abstract void error(@NotNull Throwable var1, @Nullable String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    @Nullable
    protected InputStream findData(@NotNull String relative, boolean treatAsDirectory) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        if (this.cacheDir != null) {
            long lastModified = 0L;
            Path path = this.cacheDir;
            synchronized (path) {
                StringBuilder stringBuilder;
                boolean bl = false;
                int n = relative.length() + 8;
                StringBuilder $this$findData_u24lambda_u243_u24lambda_u240 = stringBuilder = new StringBuilder(n);
                boolean bl2 = false;
                char[] cArray = new char[]{'/'};
                $this$findData_u24lambda_u243_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)relative, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                    final /* synthetic */ NetworkCache this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return NetworkCache.access$encode(this.this$0, it);
                    }
                }), (int)30, null));
                if (treatAsDirectory && ((CharSequence)$this$findData_u24lambda_u243_u24lambda_u240).length() > 0 && !StringsKt.endsWith$default((CharSequence)$this$findData_u24lambda_u243_u24lambda_u240, (char)'/', (boolean)false, (int)2, null)) {
                    $this$findData_u24lambda_u243_u24lambda_u240.append('/');
                }
                if (((CharSequence)$this$findData_u24lambda_u243_u24lambda_u240).length() == 0 || StringsKt.endsWith$default((CharSequence)$this$findData_u24lambda_u243_u24lambda_u240, (char)'/', (boolean)false, (int)2, null)) {
                    $this$findData_u24lambda_u243_u24lambda_u240.append("(index)");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String relativePath2 = string;
                Path file = this.cacheDir.resolve(relativePath2);
                try {
                    lastModified = CancellableFileIo.getLastModifiedTime((Path)file, (LinkOption[])new LinkOption[0]).toMillis();
                    long now = System.currentTimeMillis();
                    long expiryMs = TimeUnit.HOURS.toMillis(this.cacheExpiryHours);
                    if (!this.networkEnabled || lastModified == 0L || now - lastModified <= expiryMs) {
                        this.lastReadSourceType = lastModified != 0L ? (now - lastModified > expiryMs ? DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK : DataSourceType.CACHE_FILE_RECENT) : DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN;
                        return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
                if (this.networkEnabled) {
                    try {
                        FileTime time = FileTime.fromMillis(System.currentTimeMillis());
                        ReadUrlDataResult result2 = this.readUrlData(this.baseUrl + relative, this.networkTimeoutMs, lastModified);
                        if (!result2.getModifiedSince()) {
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_NOT_MODIIFED_SINCE;
                            Files.setLastModifiedTime(file, time);
                            return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                        }
                        byte[] byArray = result2.getData();
                        if (byArray != null) {
                            Path path2;
                            byte[] data = byArray;
                            boolean bl3 = false;
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_NEW;
                            Path path3 = path2 = file.getParent();
                            if (path3 != null) {
                                Intrinsics.checkNotNull((Object)path3);
                                Path it = path2;
                                boolean bl4 = false;
                                Files.createDirectories(it, new FileAttribute[0]);
                            }
                            Files.write(file, data, new OpenOption[0]);
                            return new ByteArrayInputStream(data);
                        }
                    }
                    catch (AssertionError e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        try {
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR;
                            return CancellableFileIo.newInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        InputStream result3 = this.readDefaultData(relative);
        this.lastReadSourceType = DataSourceType.DEFAULT_DATA;
        return result3;
    }

    public static /* synthetic */ InputStream findData$default(NetworkCache networkCache, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findData");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return networkCache.findData(string, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String encode(String it) {
        Object object;
        String encoded = URLEncoder.encode(it, Charsets.UTF_8.name());
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            Intrinsics.checkNotNull((Object)encoded);
            String string = StringsKt.substringBefore$default((String)encoded, (String)".", null, (int)2, null);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (this.RESERVED_WINDOWS_FILE_NAMES.contains(string2)) {
                object = "(" + encoded + ")";
                return object;
            }
        }
        Intrinsics.checkNotNull((Object)encoded);
        object = encoded;
        return object;
    }

    public static final /* synthetic */ String access$encode(NetworkCache $this, String it) {
        return $this.encode(it);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "", "(Ljava/lang/String;I)V", "UNKNOWN_SOURCE", "TEST_DATA", "CACHE_FILE_EXPIRED_NO_NETWORK", "CACHE_FILE_EXPIRED_NETWORK_ERROR", "CACHE_FILE_EXPIRED_UNKNOWN", "CACHE_FILE_RECENT", "CACHE_FILE_NEW", "CACHE_FILE_NOT_MODIIFED_SINCE", "DEFAULT_DATA", "sdk-common"})
    public static final class DataSourceType
    extends Enum<DataSourceType> {
        public static final /* enum */ DataSourceType UNKNOWN_SOURCE = new DataSourceType();
        public static final /* enum */ DataSourceType TEST_DATA = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_NO_NETWORK = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_NETWORK_ERROR = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_UNKNOWN = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_RECENT = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_NEW = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_NOT_MODIIFED_SINCE = new DataSourceType();
        public static final /* enum */ DataSourceType DEFAULT_DATA = new DataSourceType();
        private static final /* synthetic */ DataSourceType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DataSourceType[] values() {
            return (DataSourceType[])$VALUES.clone();
        }

        public static DataSourceType valueOf(String value) {
            return Enum.valueOf(DataSourceType.class, value);
        }

        @NotNull
        public static EnumEntries<DataSourceType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = dataSourceTypeArray = new DataSourceType[]{DataSourceType.UNKNOWN_SOURCE, DataSourceType.TEST_DATA, DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK, DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR, DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN, DataSourceType.CACHE_FILE_RECENT, DataSourceType.CACHE_FILE_NEW, DataSourceType.CACHE_FILE_NOT_MODIIFED_SINCE, DataSourceType.DEFAULT_DATA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "", "data", "", "modifiedSince", "", "([BZ)V", "getData", "()[B", "getModifiedSince", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "sdk-common"})
    public static final class ReadUrlDataResult {
        @Nullable
        private final byte[] data;
        private final boolean modifiedSince;

        public ReadUrlDataResult(@Nullable byte[] data, boolean modifiedSince) {
            this.data = data;
            this.modifiedSince = modifiedSince;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public final boolean getModifiedSince() {
            return this.modifiedSince;
        }

        @Nullable
        public final byte[] component1() {
            return this.data;
        }

        public final boolean component2() {
            return this.modifiedSince;
        }

        @NotNull
        public final ReadUrlDataResult copy(@Nullable byte[] data, boolean modifiedSince) {
            return new ReadUrlDataResult(data, modifiedSince);
        }

        public static /* synthetic */ ReadUrlDataResult copy$default(ReadUrlDataResult readUrlDataResult, byte[] byArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                byArray = readUrlDataResult.data;
            }
            if ((n & 2) != 0) {
                bl = readUrlDataResult.modifiedSince;
            }
            return readUrlDataResult.copy(byArray, bl);
        }

        @NotNull
        public String toString() {
            return "ReadUrlDataResult(data=" + Arrays.toString(this.data) + ", modifiedSince=" + this.modifiedSince + ")";
        }

        public int hashCode() {
            int result2 = this.data == null ? 0 : Arrays.hashCode(this.data);
            result2 = result2 * 31 + Boolean.hashCode(this.modifiedSince);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadUrlDataResult)) {
                return false;
            }
            ReadUrlDataResult readUrlDataResult = (ReadUrlDataResult)other;
            if (!Intrinsics.areEqual((Object)this.data, (Object)readUrlDataResult.data)) {
                return false;
            }
            return this.modifiedSince == readUrlDataResult.modifiedSince;
        }
    }
}

