/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.DownloadableParseResult;
import com.android.ide.common.fonts.FontQueryParserError;
import com.android.ide.common.fonts.FontType;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryResolverLegacy;
import com.android.utils.Pair;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class QueryResolver {
    private static final int MAX_QUERY_LENGTH = 512;
    private static final String[] ITALIC_OPTIONS = new String[]{"", "i", "italic"};
    private static final ImmutableMap<String, Integer> NAMED_WEIGHTS = new ImmutableMap.Builder().put((Object)"100", (Object)100).put((Object)"200", (Object)200).put((Object)"300", (Object)300).put((Object)"400", (Object)400).put((Object)"500", (Object)500).put((Object)"600", (Object)600).put((Object)"700", (Object)700).put((Object)"800", (Object)800).put((Object)"900", (Object)900).put((Object)"thin", (Object)100).put((Object)"extralight", (Object)200).put((Object)"extra-light", (Object)200).put((Object)"ultralight", (Object)200).put((Object)"ultra-light", (Object)200).put((Object)"light", (Object)300).put((Object)"regular", (Object)400).put((Object)"book", (Object)400).put((Object)"medium", (Object)500).put((Object)"semi-bold", (Object)600).put((Object)"semibold", (Object)600).put((Object)"demi-bold", (Object)600).put((Object)"demibold", (Object)600).put((Object)"bold", (Object)700).put((Object)"extra-bold", (Object)800).put((Object)"extrabold", (Object)800).put((Object)"ultra-bold", (Object)800).put((Object)"ultrabold", (Object)800).put((Object)"black", (Object)900).put((Object)"heavy", (Object)900).put((Object)"l", (Object)300).put((Object)"r", (Object)400).put((Object)"b", (Object)700).put((Object)"", (Object)400).buildOrThrow();
    private static final Map<String, Pair<Integer, Float>> KNOWN_VARIANTS = QueryResolver.getKnownVariants();

    private static Map<String, Pair<Integer, Float>> getKnownVariants() {
        HashMap<String, Pair<Integer, Float>> knownVariants = new HashMap<String, Pair<Integer, Float>>();
        for (Map.Entry entry : NAMED_WEIGHTS.entrySet()) {
            for (String italicOption : ITALIC_OPTIONS) {
                knownVariants.put((String)entry.getKey() + italicOption, (Pair<Integer, Float>)Pair.of((Object)((Integer)entry.getValue()), (Object)Float.valueOf(italicOption.isEmpty() ? 0.0f : 1.0f)));
            }
        }
        return knownVariants;
    }

    public static DownloadableParseResult parseDownloadableFont(String authority, String query) {
        try {
            List<MutableFontDetail> specs = QueryResolver.getSpecsForQuery(query);
            LinkedHashMultimap fonts = LinkedHashMultimap.create();
            specs.forEach(arg_0 -> QueryResolver.lambda$parseDownloadableFont$0((Multimap)fonts, arg_0));
            return new DownloadableParseResult(authority, (Multimap<String, MutableFontDetail>)fonts);
        }
        catch (Exception ex) {
            throw new FontQueryParserError(ex.getMessage(), ex);
        }
    }

    private static List<MutableFontDetail> getSpecsForQuery(String query) {
        if (query == null || query.isEmpty() || query.length() > 512) {
            throw new IllegalArgumentException("query cannot be null, empty, or over 512 characters");
        }
        if (query.contains("=") || query.contains(",") && !query.contains(":")) {
            return QueryResolverLegacy.getSpecsForQuery(query);
        }
        List queries = Splitter.on((char)'|').omitEmptyStrings().trimResults().splitToList((CharSequence)query);
        ArrayList<MutableFontDetail> finalSpecs = new ArrayList<MutableFontDetail>();
        for (String q : queries) {
            finalSpecs.addAll(QueryResolver.getSpecsForIndividualQuery(q));
        }
        return finalSpecs;
    }

    static float extractFloat(String component, int position) {
        try {
            return Float.parseFloat(component.substring(position));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("query contains invalid value (" + component + ")");
        }
    }

    static int extractInt(String component, int position) {
        try {
            return Integer.parseInt(component.substring(position));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("query contains invalid value (" + component + ")");
        }
    }

    private static List<MutableFontDetail> getSpecsForIndividualQuery(String query) {
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("query cannot be null or empty");
        }
        ArrayList<MutableFontDetail> finalSpecs = new ArrayList<MutableFontDetail>();
        if (!query.contains(":")) {
            finalSpecs.add(new MutableFontDetail(query.replace('+', ' '), FontType.SINGLE, 0.0f, true));
            return finalSpecs;
        }
        int firstColonPosition = query.indexOf(58);
        String familyName = query.substring(0, firstColonPosition).replace('+', ' ');
        query = query.substring(firstColonPosition + 1);
        List queries = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)query);
        if (queries.size() == 1) {
            if (((String)queries.get(0)).toLowerCase(Locale.ENGLISH).equals("vf")) {
                finalSpecs.add(new MutableFontDetail(familyName, FontType.VARIABLE, 0.0f, true));
                return finalSpecs;
            }
            if (((String)queries.get(0)).toLowerCase(Locale.ENGLISH).equals("vf:italic")) {
                finalSpecs.add(new MutableFontDetail(familyName, FontType.VARIABLE, 1.0f, true));
                return finalSpecs;
            }
            if (((String)queries.get(0)).toLowerCase(Locale.ENGLISH).startsWith("vf")) {
                throw new IllegalArgumentException("invalid vf query (" + (String)queries.get(0) + ")");
            }
        }
        for (String q : queries) {
            List components = Splitter.on((char)':').omitEmptyStrings().trimResults().splitToList((CharSequence)q);
            float italicValue = 0.0f;
            float widthValue = 100.0f;
            int weightValue = 400;
            boolean nearestValue = false;
            for (String component : components) {
                int possibleWeight;
                Pair<Integer, Float> attributes = KNOWN_VARIANTS.get(component = component.toLowerCase(Locale.ENGLISH));
                if (attributes != null) {
                    weightValue = (Integer)attributes.getFirst();
                    italicValue = ((Float)attributes.getSecond()).floatValue();
                    continue;
                }
                if (component.equals("nearest")) {
                    nearestValue = true;
                    continue;
                }
                if (component.startsWith("wght")) {
                    possibleWeight = QueryResolver.extractInt(component, 4);
                    if (possibleWeight >= 1 && possibleWeight <= 1000) {
                        weightValue = possibleWeight;
                        continue;
                    }
                    throw new IllegalArgumentException("query contains invalid weight (" + component + ")");
                }
                if (component.startsWith("ital")) {
                    float possibleItalic = QueryResolver.extractFloat(component, 4);
                    if (possibleItalic >= 0.0f && possibleItalic <= 1.0f) {
                        italicValue = possibleItalic;
                        continue;
                    }
                    throw new IllegalArgumentException("query contains invalid italic value (" + component + ")");
                }
                if (component.startsWith("wdth")) {
                    float possibleWidth = QueryResolver.extractFloat(component, 4);
                    if (possibleWidth > 0.0f) {
                        widthValue = possibleWidth;
                        continue;
                    }
                    throw new IllegalArgumentException("query contains invalid width (" + component + ")");
                }
                possibleWeight = QueryResolver.extractInt(component, 0);
                if (possibleWeight >= 1 && possibleWeight <= 1000) {
                    weightValue = possibleWeight;
                    continue;
                }
                throw new IllegalArgumentException("query contains invalid weight (" + component + ")");
            }
            finalSpecs.add(new MutableFontDetail(familyName, weightValue, widthValue, italicValue, !nearestValue));
        }
        return finalSpecs;
    }

    private static /* synthetic */ void lambda$parseDownloadableFont$0(Multimap fonts, MutableFontDetail spec) {
        fonts.put((Object)spec.getName(), (Object)spec);
    }
}

