/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Storage {
    static final Pattern storagePattern = Pattern.compile("([0-9]+)( *)([KMGT]?)(B?)");
    private long mNoBytes;

    public Storage(long amount, Unit unit) {
        this.mNoBytes = amount * unit.getNumberOfBytes();
    }

    public Storage(long amount) {
        this(amount, Unit.B);
    }

    public long getSize() {
        return this.getSizeAsUnit(Unit.B);
    }

    public Storage deepCopy() {
        return new Storage(this.mNoBytes);
    }

    public long getSizeAsUnit(Unit unit) {
        return this.mNoBytes / unit.getNumberOfBytes();
    }

    public double getPreciseSizeAsUnit(Unit unit) {
        return (double)this.mNoBytes / (double)unit.getNumberOfBytes();
    }

    public static Storage getStorageFromString(String storageString) {
        Unit unitPart;
        int numberPart;
        if (storageString == null || storageString.isEmpty()) {
            return null;
        }
        Matcher matcher = storagePattern.matcher(storageString);
        if (!matcher.matches()) {
            return null;
        }
        try {
            numberPart = Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException unused) {
            return null;
        }
        String unitString = matcher.group(3);
        if (!unitString.isEmpty()) {
            unitPart = Unit.getEnum(matcher.group(3).charAt(0));
            if (unitPart == null) {
                return null;
            }
        } else {
            unitPart = matcher.group(4).isEmpty() ? Unit.MiB : Unit.B;
        }
        return new Storage(numberPart, unitPart);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Storage)) {
            return false;
        }
        return this.getSize() == ((Storage)other).getSize();
    }

    public boolean lessThan(Object other) {
        if (!(other instanceof Storage)) {
            return false;
        }
        return this.getSize() < ((Storage)other).getSize();
    }

    public int hashCode() {
        int result = 17;
        return 31 * result + (int)(this.mNoBytes ^ this.mNoBytes >>> 32);
    }

    public Unit getAppropriateUnits() {
        Unit optimalUnit = Unit.B;
        for (Unit unit : Unit.values()) {
            if (this.mNoBytes % unit.getNumberOfBytes() != 0L) break;
            optimalUnit = unit;
        }
        return optimalUnit;
    }

    public Unit getLargestReasonableUnits() {
        Unit optimalUnit = Unit.B;
        for (Unit unit : Unit.values()) {
            if (this.mNoBytes / unit.getNumberOfBytes() == 0L) break;
            optimalUnit = unit;
        }
        return optimalUnit;
    }

    public String toString() {
        Unit unit = this.getAppropriateUnits();
        return String.format("%d %s", this.getSizeAsUnit(unit), unit.getDisplayValue());
    }

    public String toUiString() {
        return this.toUiString(1);
    }

    public String toUiString(int precision) {
        Unit reasonableUnit = this.getLargestReasonableUnits();
        if (reasonableUnit == Unit.B) {
            precision = 0;
        }
        double sizeInReasonableUnits = this.getPreciseSizeAsUnit(reasonableUnit);
        String format = String.format("%%.%df %%s", precision);
        return String.format(format, sizeInReasonableUnits, reasonableUnit.getDisplayValue());
    }

    public String toIniString() {
        Unit unit = this.getAppropriateUnits();
        return String.format("%d%c", this.getSizeAsUnit(unit), Character.valueOf(unit.getUnitChar()));
    }

    public static enum Unit {
        B("B", "B", 1L),
        KiB("KiB", "KB", 1024L),
        MiB("MiB", "MB", 0x100000L),
        GiB("GiB", "GB", 0x40000000L),
        TiB("TiB", "TB", 0x10000000000L);

        private String mValue;
        private String mDisplayValue;
        private long mNoBytes;

        private Unit(String val, String displayVal, long noBytes) {
            this.mValue = val;
            this.mDisplayValue = displayVal;
            this.mNoBytes = noBytes;
        }

        public static Unit getEnum(String val) {
            for (Unit unit : Unit.values()) {
                if (!unit.mValue.equals(val)) continue;
                return unit;
            }
            return null;
        }

        public static Unit getEnum(char unitChar) {
            for (Unit unit : Unit.values()) {
                if (unitChar != unit.mValue.charAt(0)) continue;
                return unit;
            }
            return null;
        }

        public long getNumberOfBytes() {
            return this.mNoBytes;
        }

        public String toString() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public char getUnitChar() {
            return this.mValue.charAt(0);
        }
    }
}

