/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.prefs.AndroidLocation;
import com.android.repository.Revision;
import com.android.repository.api.ConstantSourceProvider;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemoteListSourceProvider;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.impl.sources.LocalSourceProvider;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.legacy.LegacyLocalRepoLoader;
import com.android.sdklib.repository.legacy.LegacyRemoteRepoLoader;
import com.android.sdklib.repository.meta.AddonFactory;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.meta.RepoFactory;
import com.android.sdklib.repository.meta.SdkCommonFactory;
import com.android.sdklib.repository.meta.SysImgFactory;
import com.android.sdklib.repository.sources.RemoteSiteType;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.sdklib.repository.targets.SystemImageManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class AndroidSdkHandler {
    private static final SchemaModule<AddonFactory> ADDON_MODULE = new SchemaModule("com.android.sdklib.repository.generated.addon.v%d.ObjectFactory", "sdk-addon-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule<RepoFactory> REPOSITORY_MODULE = new SchemaModule("com.android.sdklib.repository.generated.repository.v%d.ObjectFactory", "sdk-repository-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule<SysImgFactory> SYS_IMG_MODULE = new SchemaModule("com.android.sdklib.repository.generated.sysimg.v%d.ObjectFactory", "sdk-sys-img-%02d.xsd", AndroidSdkHandler.class);
    private static final SchemaModule<SdkCommonFactory> COMMON_MODULE = new SchemaModule("com.android.sdklib.repository.generated.common.v%d.ObjectFactory", "sdk-common-%02d.xsd", AndroidSdkHandler.class);
    private static final String URL_GOOGLE_SDK_SITE = "https://dl.google.com/android/repository/";
    private static final String CUSTOM_SOURCE_PROPERTY = "android.sdk.custom.url";
    public static final String SDK_TEST_BASE_URL_ENV_VAR = "SDK_TEST_BASE_URL";
    public static final String SDK_TEST_BASE_URL_PROPERTY = "sdk.test.base.url";
    public static final int LATEST_LEGACY_VERSION = 12;
    @VisibleForTesting
    static final String LOCAL_ADDONS_FILENAME = "repositories.cfg";
    private static final String DEFAULT_SITE_LIST_FILENAME_PATTERN = "addons_list-%d.xml";
    private static final Object MANAGER_LOCK = new Object();
    private static final String REPO_URL_PATTERN = "%srepository2-%d.xml";
    private RepoManager mRepoManager;
    private SystemImageManager mSystemImageManager;
    private AndroidTargetManager mAndroidTargetManager;
    private BuildToolInfo mLatestBuildTool = null;
    private final FileOp mFop;
    private static final Map<File, AndroidSdkHandler> sInstances = Maps.newConcurrentMap();
    private final File mLocation;
    private final File mAndroidFolder;
    private LocalSourceProvider mUserSourceProvider;
    private static RepoConfig sRepoConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidSdkHandler getInstance(File localPath) {
        File key = localPath == null ? new File("") : localPath;
        Map<File, AndroidSdkHandler> map = sInstances;
        synchronized (map) {
            return sInstances.computeIfAbsent(key, k -> {
                File androidFolder;
                try {
                    androidFolder = new File(AndroidLocation.getFolder());
                }
                catch (AndroidLocation.AndroidLocationException e) {
                    androidFolder = null;
                }
                return new AndroidSdkHandler(localPath, androidFolder, FileOpUtils.create());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInstance(File localPath) {
        Map<File, AndroidSdkHandler> map = sInstances;
        synchronized (map) {
            sInstances.remove(localPath);
        }
    }

    @VisibleForTesting
    public AndroidSdkHandler(File localPath, File androidFolder, FileOp fop) {
        this.mLocation = localPath;
        this.mAndroidFolder = androidFolder;
        this.mFop = (FileOp)Preconditions.checkNotNull((Object)fop);
    }

    @VisibleForTesting
    public AndroidSdkHandler(File localPath, File androidFolder, FileOp fop, RepoManager repoManager) {
        this(localPath, androidFolder, fop);
        this.mRepoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepoManager getSdkManager(ProgressIndicator progress) {
        RepoManager result = this.mRepoManager;
        Object object = MANAGER_LOCK;
        synchronized (object) {
            if (result == null) {
                this.mSystemImageManager = null;
                this.mAndroidTargetManager = null;
                this.mLatestBuildTool = null;
                result = AndroidSdkHandler.getRepoConfig(progress).createRepoManager(progress, this.mLocation, this.getUserSourceProvider(progress), this.mFop);
                result.registerLocalChangeListener(packages -> {
                    this.mSystemImageManager = null;
                    this.mAndroidTargetManager = null;
                    this.mLatestBuildTool = null;
                });
                this.mRepoManager = result;
            }
        }
        return this.mRepoManager;
    }

    public SystemImageManager getSystemImageManager(ProgressIndicator progress) {
        if (this.mSystemImageManager == null) {
            this.getSdkManager(progress);
            this.mSystemImageManager = new SystemImageManager(this.mRepoManager, (SysImgFactory)AndroidSdkHandler.getSysImgModule().createLatestFactory(), this.mFop);
        }
        return this.mSystemImageManager;
    }

    public AndroidTargetManager getAndroidTargetManager(ProgressIndicator progress) {
        if (this.mAndroidTargetManager == null) {
            this.getSdkManager(progress);
            this.mAndroidTargetManager = new AndroidTargetManager(this, this.mFop);
        }
        return this.mAndroidTargetManager;
    }

    public File getLocation() {
        return this.mLocation;
    }

    public File getAndroidFolder() {
        return this.mAndroidFolder;
    }

    public LocalPackage getLocalPackage(String path, ProgressIndicator progress) {
        return (LocalPackage)this.getSdkManager(progress).getPackages().getLocalPackages().get(path);
    }

    public static <P extends RepoPackage, T> P getLatestPackageFromPrefixCollection(Collection<P> packages, Predicate<Revision> filter, boolean allowPreview, Function<String, T> mapper, Comparator<T> comparator) {
        Function<RepoPackage, Object> keyGen = p -> mapper.apply(p.getPath().substring(p.getPath().lastIndexOf(59) + 1));
        return (P)((RepoPackage)packages.stream().filter(p -> !(filter != null && !filter.test(p.getVersion()) || !allowPreview && p.getVersion().isPreview())).max((p1, p2) -> comparator.compare(keyGen.apply((RepoPackage)p1), keyGen.apply((RepoPackage)p2))).orElse(null));
    }

    public LocalPackage getLatestLocalPackageForPrefix(String prefix, Predicate<Revision> filter, boolean allowPreview, ProgressIndicator progress) {
        return this.getLatestLocalPackageForPrefix(prefix, filter, allowPreview, Revision::safeParseRevision, progress);
    }

    public LocalPackage getLatestLocalPackageForPrefix(String prefix, Predicate<Revision> filter, boolean allowPreview, Function<String, ? extends Comparable> mapper, ProgressIndicator progress) {
        return this.getLatestLocalPackageForPrefix(prefix, filter, allowPreview, mapper, Comparator.naturalOrder(), progress);
    }

    public <T> LocalPackage getLatestLocalPackageForPrefix(String prefix, Predicate<Revision> filter, boolean allowPreview, Function<String, T> mapper, Comparator<T> comparator, ProgressIndicator progress) {
        return (LocalPackage)AndroidSdkHandler.getLatestPackageFromPrefixCollection(this.getSdkManager(progress).getPackages().getLocalPackagesForPrefix(prefix), filter, allowPreview, mapper, comparator);
    }

    public RemotePackage getLatestRemotePackageForPrefix(String prefix, boolean allowPreview, ProgressIndicator progress) {
        return this.getLatestRemotePackageForPrefix(prefix, allowPreview, Revision::safeParseRevision, progress);
    }

    public RemotePackage getLatestRemotePackageForPrefix(String prefix, boolean allowPreview, Function<String, ? extends Comparable> mapper, ProgressIndicator progress) {
        return this.getLatestRemotePackageForPrefix(prefix, allowPreview, mapper, Comparator.naturalOrder(), progress);
    }

    public <T> RemotePackage getLatestRemotePackageForPrefix(String prefix, boolean allowPreview, Function<String, T> mapper, Comparator<T> comparator, ProgressIndicator progress) {
        return (RemotePackage)AndroidSdkHandler.getLatestPackageFromPrefixCollection(this.getSdkManager(progress).getPackages().getRemotePackagesForPrefix(prefix), null, allowPreview, mapper, comparator);
    }

    private static void invalidateAll() {
        for (AndroidSdkHandler handler : sInstances.values()) {
            handler.mRepoManager = null;
        }
    }

    public static SchemaModule<SdkCommonFactory> getCommonModule() {
        return COMMON_MODULE;
    }

    public static SchemaModule<AddonFactory> getAddonModule() {
        return ADDON_MODULE;
    }

    public static SchemaModule<RepoFactory> getRepositoryModule() {
        return REPOSITORY_MODULE;
    }

    public static SchemaModule<SysImgFactory> getSysImgModule() {
        return SYS_IMG_MODULE;
    }

    public static List<SchemaModule<?>> getAllModules() {
        return ImmutableList.of(AndroidSdkHandler.getRepositoryModule(), AndroidSdkHandler.getAddonModule(), AndroidSdkHandler.getSysImgModule(), (Object)RepoManager.getCommonModule(), (Object)RepoManager.getGenericModule());
    }

    @VisibleForTesting
    RemoteListSourceProvider getRemoteListSourceProvider(ProgressIndicator progress) {
        return AndroidSdkHandler.getRepoConfig(progress).getRemoteListSourceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalSourceProvider getUserSourceProvider(ProgressIndicator progress) {
        if (this.mUserSourceProvider == null && this.mAndroidFolder != null) {
            this.mUserSourceProvider = RepoConfig.createUserSourceProvider(this.mFop, this.mAndroidFolder);
            Object object = MANAGER_LOCK;
            synchronized (object) {
                if (this.mRepoManager != null) {
                    this.mRepoManager = null;
                    this.getSdkManager(progress);
                }
            }
        }
        return this.mUserSourceProvider;
    }

    public static void addCustomSourceProvider(RepositorySourceProvider provider, ProgressIndicator progress) {
        AndroidSdkHandler.getRepoConfig(progress).addCustomSourceProvider(provider);
        AndroidSdkHandler.invalidateAll();
    }

    private static RepoConfig getRepoConfig(ProgressIndicator progress) {
        if (sRepoConfig == null) {
            sRepoConfig = new RepoConfig(progress);
        }
        return sRepoConfig;
    }

    public LocalPackage getPackageInRange(String prefix, Range<Revision> range, ProgressIndicator progressIndicator) {
        Collection allBuildTools = this.getSdkManager(progressIndicator).getPackages().getLocalPackagesForPrefix(prefix);
        return allBuildTools.stream().filter(p -> range.contains((Comparable)p.getVersion())).sorted(Comparator.comparing(RepoPackage::getVersion).reversed()).findFirst().orElse(null);
    }

    public BuildToolInfo getLatestBuildTool(ProgressIndicator progress, boolean allowPreview) {
        return this.getLatestBuildTool(progress, null, allowPreview);
    }

    public BuildToolInfo getLatestBuildTool(ProgressIndicator progress, Predicate<Revision> filter, boolean allowPreview) {
        if (!allowPreview && this.mLatestBuildTool != null) {
            return this.mLatestBuildTool;
        }
        LocalPackage latestBuildToolPackage = this.getLatestLocalPackageForPrefix("build-tools", filter, allowPreview, progress);
        if (latestBuildToolPackage == null) {
            return null;
        }
        BuildToolInfo latestBuildTool = BuildToolInfo.fromLocalPackage(latestBuildToolPackage);
        if (!latestBuildToolPackage.getVersion().isPreview()) {
            this.mLatestBuildTool = latestBuildTool;
        }
        return latestBuildTool;
    }

    public BuildToolInfo getBuildToolInfo(Revision revision, ProgressIndicator progress) {
        String pathId = DetailsTypes.getBuildToolsPath(revision);
        LocalPackage localPackage = this.getSdkManager(progress).getLocalSynchronously(pathId, progress);
        if (localPackage != null) {
            return BuildToolInfo.fromLocalPackage(localPackage);
        }
        localPackage = this.getLocalPackage(pathId, progress);
        if (localPackage != null) {
            return BuildToolInfo.fromLocalPackage(localPackage);
        }
        return null;
    }

    public IAndroidTarget getAndroidTarget(AndroidVersion androidVersion, ProgressIndicator progress) {
        String pathId = DetailsTypes.getPlatformPath(androidVersion);
        LocalPackage localPackage = this.getSdkManager(progress).getLocalSynchronously(pathId, progress);
        if (localPackage != null) {
            return new PlatformTarget(localPackage, this, this.mFop, progress);
        }
        localPackage = this.getLocalPackage(pathId, progress);
        if (localPackage != null) {
            return new PlatformTarget(localPackage, this, this.mFop, progress);
        }
        return null;
    }

    public FileOp getFileOp() {
        return this.mFop;
    }

    private static class RepoConfig {
        private RemoteListSourceProvider mAddonsListSourceProvider;
        private ConstantSourceProvider mRepositorySourceProvider;
        private Set<RepositorySourceProvider> mCustomSourceProviders = new HashSet<RepositorySourceProvider>();

        public RepoConfig(ProgressIndicator progress) {
            SchemaModule addonListModule = new SchemaModule("com.android.sdklib.repository.sources.generated.v%d.ObjectFactory", "sdk-sites-list-%d.xsd", RemoteSiteType.class);
            try {
                ImmutableMap siteTypes = ImmutableMap.builder().put(RemoteSiteType.AddonSiteType.class, (Object)ImmutableSet.of((Object)ADDON_MODULE)).put(RemoteSiteType.SysImgSiteType.class, (Object)ImmutableSet.of((Object)SYS_IMG_MODULE)).build();
                this.mAddonsListSourceProvider = RemoteListSourceProvider.create((String)RepoConfig.getAddonListUrl(progress), (SchemaModule)addonListModule, (Map)siteTypes);
            }
            catch (URISyntaxException e) {
                progress.logError("Failed to set up addons source provider", (Throwable)e);
            }
            String url = String.format(Locale.US, AndroidSdkHandler.REPO_URL_PATTERN, RepoConfig.getBaseUrl(progress), REPOSITORY_MODULE.getNamespaceVersionMap().size());
            this.mRepositorySourceProvider = new ConstantSourceProvider(url, "Android Repository", (Collection)ImmutableSet.of((Object)REPOSITORY_MODULE, (Object)RepoManager.getGenericModule()));
        }

        public static LocalSourceProvider createUserSourceProvider(FileOp fileOp, File androidFolder) {
            return new LocalSourceProvider(new File(androidFolder, AndroidSdkHandler.LOCAL_ADDONS_FILENAME), (Collection)ImmutableList.of((Object)SYS_IMG_MODULE, (Object)ADDON_MODULE), fileOp);
        }

        private static String getAddonListUrl(ProgressIndicator progress) {
            return RepoConfig.getBaseUrl(progress) + AndroidSdkHandler.DEFAULT_SITE_LIST_FILENAME_PATTERN;
        }

        private static String getBaseUrl(ProgressIndicator progress) {
            String baseUrl = Optional.ofNullable(System.getenv(AndroidSdkHandler.SDK_TEST_BASE_URL_ENV_VAR)).orElse(System.getProperty(AndroidSdkHandler.SDK_TEST_BASE_URL_PROPERTY));
            if (baseUrl != null) {
                if (!baseUrl.isEmpty() && baseUrl.endsWith("/")) {
                    return baseUrl;
                }
                progress.logWarning("Ignoring invalid SDK_TEST_BASE_URL: " + baseUrl);
            }
            return AndroidSdkHandler.URL_GOOGLE_SDK_SITE;
        }

        public RemoteListSourceProvider getRemoteListSourceProvider() {
            return this.mAddonsListSourceProvider;
        }

        public void addCustomSourceProvider(RepositorySourceProvider provider) {
            this.mCustomSourceProviders.add(provider);
        }

        public RepoManager createRepoManager(ProgressIndicator progress, File localLocation, LocalSourceProvider userProvider, FileOp fop) {
            RepoManager result = RepoManager.create((FileOp)fop);
            result.registerSchemaModule(ADDON_MODULE);
            result.registerSchemaModule(REPOSITORY_MODULE);
            result.registerSchemaModule(SYS_IMG_MODULE);
            result.registerSchemaModule(COMMON_MODULE);
            result.registerSourceProvider((RepositorySourceProvider)this.mRepositorySourceProvider);
            this.mCustomSourceProviders.forEach(arg_0 -> ((RepoManager)result).registerSourceProvider(arg_0));
            String customSourceUrl = System.getProperty(AndroidSdkHandler.CUSTOM_SOURCE_PROPERTY);
            if (customSourceUrl != null && !customSourceUrl.isEmpty()) {
                result.registerSourceProvider((RepositorySourceProvider)new ConstantSourceProvider(customSourceUrl, "Custom Provider", (Collection)result.getSchemaModules()));
            }
            result.registerSourceProvider((RepositorySourceProvider)this.mAddonsListSourceProvider);
            if (userProvider != null) {
                result.registerSourceProvider((RepositorySourceProvider)userProvider);
                userProvider.setRepoManager(result);
            }
            result.setFallbackRemoteRepoLoader((FallbackRemoteRepoLoader)new LegacyRemoteRepoLoader());
            result.setLocalPath(localLocation);
            if (localLocation != null) {
                result.setFallbackLocalRepoLoader((FallbackLocalRepoLoader)new LegacyLocalRepoLoader(localLocation, fop));
                result.loadSynchronously(0L, progress, null, null);
            }
            return result;
        }
    }
}

