/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.NameDetails;
import com.android.sdklib.SdkVersionInfo;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\"\u0010\u0002\u001a\u00020\u0003*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\u000e\u001a\u00020\u000b*\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\tH\u0007\u001a\u001e\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\t\u001a\u001e\u0010\u0013\u001a\u00020\u000b*\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\t\u001a\u001e\u0010\u0015\u001a\u00020\u0012*\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"MIN_API_FOR_DISPLAY_MINOR_VERSION", "", "appendDisplayApiLevelString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "includeExtension", "", "displayApiString", "", "getDisplayApiString", "(Lcom/android/sdklib/AndroidVersion;)Ljava/lang/String;", "getFullApiName", "includeReleaseName", "includeCodeName", "getApiNameAndDetails", "Lcom/android/sdklib/NameDetails;", "getFullReleaseName", "includeApiLevel", "getReleaseNameAndDetails", "sdklib"})
@JvmName(name="AndroidVersionUtils")
@SourceDebugExtension(value={"SMAP\nAndroidVersionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidVersionUtils.kt\ncom/android/sdklib/AndroidVersionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
public final class AndroidVersionUtils {
    private static final int MIN_API_FOR_DISPLAY_MINOR_VERSION = 36;

    private static final void appendDisplayApiLevelString(StringBuilder $this$appendDisplayApiLevelString, AndroidVersion androidVersion, boolean includeExtension) {
        String string = androidVersion.getCodename();
        if (string != null) {
            String codename = string;
            boolean bl = false;
            $this$appendDisplayApiLevelString.append(codename);
            return;
        }
        $this$appendDisplayApiLevelString.append(androidVersion.getApiLevel());
        if (androidVersion.getApiLevel() >= 36 || androidVersion.getApiMinorLevel() > 0) {
            $this$appendDisplayApiLevelString.append(".").append(androidVersion.getApiMinorLevel());
        }
        if (includeExtension && !androidVersion.isBaseExtension()) {
            StringBuilder stringBuilder = $this$appendDisplayApiLevelString.append("-ext");
            Integer n = androidVersion.getExtensionLevel();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getExtensionLevel(...)");
            stringBuilder.append(((Number)n).intValue());
        }
    }

    static /* synthetic */ void appendDisplayApiLevelString$default(StringBuilder stringBuilder, AndroidVersion androidVersion, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        AndroidVersionUtils.appendDisplayApiLevelString(stringBuilder, androidVersion, bl);
    }

    @NotNull
    public static final String getDisplayApiString(@NotNull AndroidVersion $this$displayApiString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$displayApiString, (String)"<this>");
        StringBuilder $this$_get_displayApiString__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        AndroidVersionUtils.appendDisplayApiLevelString($this$_get_displayApiString__u24lambda_u241, $this$displayApiString, true);
        return stringBuilder.toString();
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        NameDetails nameDetails = AndroidVersionUtils.getApiNameAndDetails($this$getFullApiName, includeReleaseName, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ")";
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String getFullApiName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getFullApiName(androidVersion, bl, bl2);
    }

    @NotNull
    public static final NameDetails getApiNameAndDetails(@NotNull AndroidVersion $this$getApiNameAndDetails, boolean includeReleaseName, boolean includeCodeName) {
        String codeName;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getApiNameAndDetails, (String)"<this>");
        if ($this$getApiNameAndDetails.getCodename() != null) {
            return new NameDetails("API " + $this$getApiNameAndDetails.getCodename() + " Preview", null);
        }
        StringBuilder name = new StringBuilder("API ");
        AndroidVersionUtils.appendDisplayApiLevelString(name, $this$getApiNameAndDetails, false);
        if (!$this$getApiNameAndDetails.isBaseExtension()) {
            StringBuilder stringBuilder = name.append(" ext. ");
            Integer n = $this$getApiNameAndDetails.getExtensionLevel();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getExtensionLevel(...)");
            stringBuilder.append(((Number)n).intValue());
        }
        boolean useCodeName = false;
        useCodeName = includeCodeName;
        if (includeReleaseName) {
            String codeName2;
            String string2;
            String relName = SdkVersionInfo.getReleaseVersionString($this$getApiNameAndDetails.getApiLevel());
            if (relName == null) {
                String string3 = SdkVersionInfo.getCodeName($this$getApiNameAndDetails.getApiLevel());
                if (string3 != null) {
                    String string4;
                    String it = string4 = string3;
                    boolean bl = false;
                    useCodeName = false;
                    string2 = string4;
                } else {
                    string2 = null;
                }
            } else {
                string2 = codeName2 = null;
            }
            if ((string = relName) == null) {
                string = codeName2;
            }
        } else {
            string = null;
        }
        String releaseName = string;
        String string5 = codeName = useCodeName ? SdkVersionInfo.getCodeName($this$getApiNameAndDetails.getApiLevel()) : null;
        if (codeName == null && releaseName == null) {
            String string6 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
            return new NameDetails(string6, null);
        }
        StringBuilder details = new StringBuilder();
        if (codeName != null) {
            details.append("\"").append(codeName).append("\"");
            if (releaseName != null) {
                details.append("; ");
            }
        }
        if (releaseName != null) {
            details.append("Android ").append(releaseName);
        }
        String string7 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        return new NameDetails(string7, details.toString());
    }

    public static /* synthetic */ NameDetails getApiNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getApiNameAndDetails(androidVersion, bl, bl2);
    }

    @NotNull
    public static final String getFullReleaseName(@NotNull AndroidVersion $this$getFullReleaseName, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullReleaseName, (String)"<this>");
        NameDetails nameDetails = AndroidVersionUtils.getReleaseNameAndDetails($this$getFullReleaseName, includeApiLevel, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ")";
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String getFullReleaseName$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getFullReleaseName(androidVersion, bl, bl2);
    }

    @NotNull
    public static final NameDetails getReleaseNameAndDetails(@NotNull AndroidVersion $this$getReleaseNameAndDetails, boolean includeApiLevel, boolean includeCodeName) {
        String resolvedCodeName;
        Intrinsics.checkNotNullParameter((Object)$this$getReleaseNameAndDetails, (String)"<this>");
        if ($this$getReleaseNameAndDetails.getCodename() != null) {
            return new NameDetails("Android " + $this$getReleaseNameAndDetails.getCodename() + " Preview", null);
        }
        StringBuilder name = new StringBuilder();
        String releaseName = SdkVersionInfo.getReleaseVersionString($this$getReleaseNameAndDetails.getApiLevel());
        if (releaseName == null) {
            String knownCodeName = SdkVersionInfo.getCodeName($this$getReleaseNameAndDetails.getApiLevel());
            if (knownCodeName != null) {
                name.append("Android " + knownCodeName);
                if (includeApiLevel) {
                    name.append(" (API \"" + $this$getReleaseNameAndDetails.getApiStringWithoutExtension() + "\"");
                    if (!$this$getReleaseNameAndDetails.isBaseExtension()) {
                        name.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
                    }
                    name.append(")");
                }
            } else {
                name.append("Android API " + $this$getReleaseNameAndDetails.getApiStringWithoutExtension());
                if (includeApiLevel && !$this$getReleaseNameAndDetails.isBaseExtension()) {
                    name.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
                }
            }
            String string = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new NameDetails(string, null);
        }
        name.append("Android " + releaseName);
        String string = resolvedCodeName = includeCodeName ? SdkVersionInfo.getCodeName($this$getReleaseNameAndDetails.getApiLevel()) : null;
        if (resolvedCodeName == null && !includeApiLevel) {
            String string2 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return new NameDetails(string2, null);
        }
        StringBuilder details = new StringBuilder();
        if (resolvedCodeName != null) {
            details.append("\"" + resolvedCodeName + "\"");
            if (includeApiLevel) {
                details.append("; ");
            }
        }
        if (includeApiLevel) {
            details.append("API " + $this$getReleaseNameAndDetails.getApiStringWithoutExtension());
            if (!$this$getReleaseNameAndDetails.isBaseExtension()) {
                details.append(" ext. " + $this$getReleaseNameAndDetails.getExtensionLevel());
            }
        }
        String string3 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return new NameDetails(string3, details.toString());
    }

    public static /* synthetic */ NameDetails getReleaseNameAndDetails$default(AndroidVersion androidVersion, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return AndroidVersionUtils.getReleaseNameAndDetails(androidVersion, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, includeReleaseName, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFullApiName, (String)"<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, false, false, 3, null);
    }
}

