/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.coverage;

import com.android.tools.utp.plugins.host.coverage.AndroidTestCoveragePlugin;
import com.android.tools.utp.plugins.host.coverage.proto.AndroidTestCoverageConfigProto;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ProtoConfig;
import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.device.DeviceProperties;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import com.google.testing.platform.runtime.android.controller.ext.AndroidDeviceControllerExtKt;
import com.google.testing.platform.runtime.android.device.AndroidDeviceProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J%\u0010&\u001a\u00020'*\u00020\u00102\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060)\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010*J%\u0010+\u001a\u00020'*\u00020\u00102\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060)\"\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010*R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/utp/plugins/host/coverage/AndroidTestCoveragePlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "logger", "Ljava/util/logging/Logger;", "createRandomId", "Lkotlin/Function0;", "", "(Ljava/util/logging/Logger;Lkotlin/jvm/functions/Function0;)V", "testCoverageConfig", "Lcom/android/tools/utp/plugins/host/coverage/proto/AndroidTestCoverageConfigProto$AndroidTestCoverageConfig;", "useTestStorageService", "", "afterAll", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "testSuiteResult", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "afterEach", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "testResult", "beforeAll", "", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "cancel", "cleanPreviousCodeCoverageOnDevice", "configure", "config", "Lcom/google/testing/platform/api/config/Config;", "copyCoverageFileToHost", "tmpDir", "copyCoverageFilesInDirectoryToHost", "createEmptyDirectoryOnHost", "directory", "Ljava/io/File;", "retrieveCoverageFiles", "deviceShellAndCheckSuccess", "Lcom/google/testing/platform/api/device/CommandResult;", "commands", "", "(Lcom/google/testing/platform/api/device/DeviceController;[Ljava/lang/String;)Lcom/google/testing/platform/api/device/CommandResult;", "deviceShellWithRunAs", "Companion", "android-test-plugin-host-coverage"})
public final class AndroidTestCoveragePlugin
implements HostPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Function0<String> createRandomId;
    private AndroidTestCoverageConfigProto.AndroidTestCoverageConfig testCoverageConfig;
    private boolean useTestStorageService;
    @NotNull
    private static final String TMP_DIR_ON_DEVICE = "/data/local/tmp/";
    @NotNull
    private static final String TEST_STORAGE_SERVICE_OUTPUT_DIR = "/sdcard/googletest/internal_use/";

    public AndroidTestCoveragePlugin(@NotNull Logger logger, @NotNull Function0<String> createRandomId) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(createRandomId, (String)"createRandomId");
        this.logger = logger;
        this.createRandomId = createRandomId;
    }

    public /* synthetic */ AndroidTestCoveragePlugin(Logger logger, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = LoggerExtKt.getLogger((Object)Companion);
        }
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(logger, (Function0<String>)function0);
    }

    public void configure(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ProtoConfig cfr_ignored_0 = (ProtoConfig)config;
        Any any = ((ProtoConfig)config).getConfigProto();
        Intrinsics.checkNotNull((Object)any);
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig = AndroidTestCoverageConfigProto.AndroidTestCoverageConfig.parseFrom((ByteString)any.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)androidTestCoverageConfig, (String)"parseFrom(\n            config.configProto!!.value\n        )");
        this.testCoverageConfig = androidTestCoverageConfig;
    }

    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig = this.testCoverageConfig;
        if (androidTestCoverageConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
            throw null;
        }
        this.createEmptyDirectoryOnHost(new File(androidTestCoverageConfig.getOutputDirectoryOnHost()));
        this.cleanPreviousCodeCoverageOnDevice(deviceController);
        androidTestCoverageConfig = this.testCoverageConfig;
        if (androidTestCoverageConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
            throw null;
        }
        if (androidTestCoverageConfig.getUseTestStorageService() && !AndroidDeviceControllerExtKt.isTestServiceInstalled((DeviceController)deviceController)) {
            this.logger.warning("useTestStorageService is requested but TestStorageService is not installed on device.");
        }
        if ((androidTestCoverageConfig = this.testCoverageConfig) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
            throw null;
        }
        boolean bl = this.useTestStorageService = androidTestCoverageConfig.getUseTestStorageService() && AndroidDeviceControllerExtKt.isTestServiceInstalled((DeviceController)deviceController);
        if (this.useTestStorageService) {
            int apiLevel;
            String[] stringArray;
            DeviceProperties deviceProperties = deviceController.getDevice().getProperties();
            Object object = deviceProperties instanceof AndroidDeviceProperties ? (AndroidDeviceProperties)deviceProperties : null;
            String[] stringArray2 = stringArray = object == null ? null : object.getDeviceApiLevel();
            int n = stringArray == null ? 0 : (apiLevel = (object = StringsKt.toIntOrNull((String)stringArray)) == null ? 0 : (Integer)object);
            if (apiLevel >= 30) {
                stringArray = new String[]{"appops set androidx.test.services MANAGE_EXTERNAL_STORAGE allow"};
                this.deviceShellAndCheckSuccess(deviceController, stringArray);
            }
        }
    }

    private final void createEmptyDirectoryOnHost(File directory) {
        if (directory.exists()) {
            FilesKt.deleteRecursively((File)directory);
        }
        directory.mkdirs();
    }

    private final void cleanPreviousCodeCoverageOnDevice(DeviceController deviceController) {
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig = this.testCoverageConfig;
        if (androidTestCoverageConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
            throw null;
        }
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig.TestCoveragePathOnDeviceCase testCoveragePathOnDeviceCase = androidTestCoverageConfig.getTestCoveragePathOnDeviceCase();
        int n = testCoveragePathOnDeviceCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[testCoveragePathOnDeviceCase.ordinal()];
        switch (n) {
            case 1: {
                String[] stringArray = this.testCoverageConfig;
                if (stringArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                    throw null;
                }
                String file = stringArray.getSingleCoverageFile();
                stringArray = new String[]{"rm -f \"" + file + '\"'};
                this.deviceShellWithRunAs(deviceController, stringArray);
                break;
            }
            case 2: {
                String[] stringArray = this.testCoverageConfig;
                if (stringArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                    throw null;
                }
                String dir = stringArray.getMultipleCoverageFilesInDirectory();
                stringArray = new String[]{"rm -rf \"" + dir + '\"'};
                this.deviceShellWithRunAs(deviceController, stringArray);
                stringArray = new String[]{"mkdir -p \"" + dir + '\"'};
                this.deviceShellWithRunAs(deviceController, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("test_coverage_path_on_device must be specified.");
            }
        }
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    @NotNull
    public TestResultProto.TestResult afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        return testResult;
    }

    @NotNull
    public TestSuiteResultProto.TestSuiteResult afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        try {
            if (testSuiteResult.getTestResultCount() > 0) {
                this.retrieveCoverageFiles(deviceController);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e, afterAll.1.INSTANCE);
        }
        return testSuiteResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void retrieveCoverageFiles(DeviceController deviceController) {
        String tmpDir = TMP_DIR_ON_DEVICE + (String)this.createRandomId.invoke() + "-coverage_data";
        String[] stringArray = new String[]{"mkdir -p \"" + tmpDir + '\"'};
        this.deviceShellAndCheckSuccess(deviceController, stringArray);
        try {
            KFunction kFunction;
            AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            stringArray = androidTestCoverageConfig.getTestCoveragePathOnDeviceCase();
            int n = stringArray == null ? -1 : WhenMappings.$EnumSwitchMapping$0[stringArray.ordinal()];
            switch (n) {
                case 1: {
                    kFunction = (KFunction)new Function2<DeviceController, String, Unit>(this){

                        public final void invoke(@NotNull DeviceController p0, @NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            AndroidTestCoveragePlugin.access$copyCoverageFileToHost((AndroidTestCoveragePlugin)this.receiver, p0, p1);
                        }
                    };
                    break;
                }
                case 2: {
                    kFunction = (KFunction)new Function2<DeviceController, String, Unit>(this){

                        public final void invoke(@NotNull DeviceController p0, @NotNull String p1) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            AndroidTestCoveragePlugin.access$copyCoverageFilesInDirectoryToHost((AndroidTestCoveragePlugin)this.receiver, p0, p1);
                        }
                    };
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("test_coverage_path_on_device must be specified.");
                }
            }
            ((Function2)kFunction).invoke((Object)deviceController, (Object)tmpDir);
        }
        catch (Throwable throwable) {
            String[] stringArray2 = new String[]{"rm -rf \"" + tmpDir + '\"'};
            this.deviceShellAndCheckSuccess(deviceController, stringArray2);
            throw throwable;
        }
        stringArray = new String[]{"rm -rf \"" + tmpDir + '\"'};
        this.deviceShellAndCheckSuccess(deviceController, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyCoverageFileToHost(DeviceController deviceController, String tmpDir) {
        void $this$copyCoverageFileToHost_u24lambda_u2d0;
        String string;
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig;
        if (this.useTestStorageService) {
            androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            string = Intrinsics.stringPlus((String)"/sdcard/googletest/internal_use//", (Object)androidTestCoverageConfig.getSingleCoverageFile());
        } else {
            androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            string = androidTestCoverageConfig.getSingleCoverageFile();
        }
        String coverageFilePath = string;
        String coverageFileName = new File(coverageFilePath).getName();
        String tmpCoverageFilePath = tmpDir + '/' + coverageFileName;
        String[] stringArray = new String[]{"cat \"" + coverageFilePath + "\" > \"" + tmpCoverageFilePath + '\"'};
        this.deviceShellWithRunAs(deviceController, stringArray);
        TestArtifactProto.Artifact.Builder builder = TestArtifactProto.Artifact.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TestArtifactProto.Artifact.Builder builder2 = builder;
        DeviceController deviceController2 = deviceController;
        boolean bl3 = false;
        $this$copyCoverageFileToHost_u24lambda_u2d0.getDestinationPathBuilder().setPath(tmpCoverageFilePath);
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig2 = this.testCoverageConfig;
        if (androidTestCoverageConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
            throw null;
        }
        $this$copyCoverageFileToHost_u24lambda_u2d0.getSourcePathBuilder().setPath(androidTestCoverageConfig2.getOutputDirectoryOnHost() + '/' + coverageFileName);
        Unit unit = Unit.INSTANCE;
        stringArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"newBuilder().apply {\n            destinationPathBuilder.path = tmpCoverageFilePath\n            sourcePathBuilder.path = \"${testCoverageConfig.outputDirectoryOnHost}/${coverageFileName}\"\n        }.build()");
        deviceController2.pull((TestArtifactProto.Artifact)stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void copyCoverageFilesInDirectoryToHost(DeviceController deviceController, String tmpDir) {
        String string;
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig;
        if (this.useTestStorageService) {
            androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            string = Intrinsics.stringPlus((String)"/sdcard/googletest/internal_use//", (Object)androidTestCoverageConfig.getMultipleCoverageFilesInDirectory());
        } else {
            androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            string = androidTestCoverageConfig.getMultipleCoverageFilesInDirectory();
        }
        String coverageDir = string;
        Object object = new String[]{"ls \"" + coverageDir + '\"'};
        object = this.deviceShellWithRunAs(deviceController, (String[])object).getOutput();
        boolean bl = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            String it = (String)t;
            boolean bl3 = false;
            if (!StringsKt.endsWith$default((String)it, (String)".ec", (boolean)false, (int)2, null)) continue;
            collection.add(t);
        }
        List covFileNames = CollectionsKt.toList((Iterable)((List)collection));
        object = covFileNames;
        bl = false;
        object2 = object.iterator();
        while (object2.hasNext()) {
            void $this$copyCoverageFilesInDirectoryToHost_u24lambda_u2d3_u24lambda_u2d2;
            collection = object2.next();
            String covFileName = (String)((Object)collection);
            boolean bl4 = false;
            String covFilePath = coverageDir + '/' + covFileName;
            String tmpCovFilePath = tmpDir + '/' + covFileName;
            String[] stringArray = new String[]{"cat \"" + covFilePath + "\" > \"" + tmpCovFilePath + '\"'};
            this.deviceShellWithRunAs(deviceController, stringArray);
            TestArtifactProto.Artifact.Builder builder = TestArtifactProto.Artifact.newBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            TestArtifactProto.Artifact.Builder builder2 = builder;
            DeviceController deviceController2 = deviceController;
            boolean bl7 = false;
            $this$copyCoverageFilesInDirectoryToHost_u24lambda_u2d3_u24lambda_u2d2.getDestinationPathBuilder().setPath(tmpCovFilePath);
            AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig2 = this.testCoverageConfig;
            if (androidTestCoverageConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            $this$copyCoverageFilesInDirectoryToHost_u24lambda_u2d3_u24lambda_u2d2.getSourcePathBuilder().setPath(androidTestCoverageConfig2.getOutputDirectoryOnHost() + '/' + covFileName);
            Unit unit = Unit.INSTANCE;
            stringArray = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"newBuilder().apply {\n                destinationPathBuilder.path = tmpCovFilePath\n                sourcePathBuilder.path = \"${testCoverageConfig.outputDirectoryOnHost}/${covFileName}\"\n            }.build()");
            deviceController2.pull((TestArtifactProto.Artifact)stringArray);
        }
    }

    public boolean canRun() {
        return true;
    }

    public boolean cancel() {
        return false;
    }

    private final CommandResult deviceShellWithRunAs(DeviceController $this$deviceShellWithRunAs, String ... commands) {
        CommandResult commandResult;
        AndroidTestCoverageConfigProto.AndroidTestCoverageConfig androidTestCoverageConfig;
        String string;
        if (this.useTestStorageService) {
            string = "";
        } else {
            androidTestCoverageConfig = this.testCoverageConfig;
            if (androidTestCoverageConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCoverageConfig");
                throw null;
            }
            string = androidTestCoverageConfig.getRunAsPackageName();
        }
        String runAsPackage = string;
        Intrinsics.checkNotNullExpressionValue((Object)runAsPackage, (String)"runAsPackage");
        androidTestCoverageConfig = runAsPackage;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)androidTestCoverageConfig)) {
            String[] stringArray = commands;
            DeviceController deviceController = $this$deviceShellWithRunAs;
            AndroidTestCoveragePlugin androidTestCoveragePlugin = this;
            boolean bl2 = false;
            String[] stringArray2 = stringArray;
            Collection collection = new ArrayList();
            boolean bl3 = false;
            String[] stringArray3 = stringArray2;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String c = string2 = stringArray3[i];
                boolean bl4 = false;
                Object[] objectArray = new String[]{"run-as", runAsPackage, c};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            List list = (List)collection;
            stringArray = list;
            bl2 = false;
            stringArray2 = stringArray;
            String[] stringArray4 = stringArray2.toArray(new String[0]);
            if (stringArray4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            androidTestCoverageConfig = stringArray4;
            stringArray = new String[((String[])androidTestCoverageConfig).length];
            System.arraycopy(androidTestCoverageConfig, 0, stringArray, 0, ((String[])androidTestCoverageConfig).length);
            commandResult = androidTestCoveragePlugin.deviceShellAndCheckSuccess(deviceController, stringArray);
        } else {
            androidTestCoverageConfig = new String[commands.length];
            System.arraycopy(commands, 0, androidTestCoverageConfig, 0, commands.length);
            commandResult = this.deviceShellAndCheckSuccess($this$deviceShellWithRunAs, (String[])androidTestCoverageConfig);
        }
        return commandResult;
    }

    private final CommandResult deviceShellAndCheckSuccess(DeviceController $this$deviceShellAndCheckSuccess, String ... commands) {
        CommandResult result = AndroidDeviceControllerExtKt.deviceShell$default((DeviceController)$this$deviceShellAndCheckSuccess, (List)ArraysKt.toList((Object[])commands), null, (int)2, null);
        if (result.getStatusCode() != 0) {
            this.logger.warning(new Supplier<String>(result, commands){
                final /* synthetic */ CommandResult $result;
                final /* synthetic */ String[] $commands;
                {
                    this.$result = $result;
                    this.$commands = $commands;
                }

                public final String get() {
                    return "Shell command failed (" + this.$result.getStatusCode() + "): " + ArraysKt.joinToString$default((Object[])this.$commands, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + '\n' + CollectionsKt.joinToString$default((Iterable)this.$result.getOutput(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                }
            });
        }
        return result;
    }

    public AndroidTestCoveragePlugin() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ void access$copyCoverageFileToHost(AndroidTestCoveragePlugin $this, DeviceController deviceController, String tmpDir) {
        $this.copyCoverageFileToHost(deviceController, tmpDir);
    }

    public static final /* synthetic */ void access$copyCoverageFilesInDirectoryToHost(AndroidTestCoveragePlugin $this, DeviceController deviceController, String tmpDir) {
        $this.copyCoverageFilesInDirectoryToHost(deviceController, tmpDir);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/utp/plugins/host/coverage/AndroidTestCoveragePlugin$Companion;", "", "()V", "TEST_STORAGE_SERVICE_OUTPUT_DIR", "", "TMP_DIR_ON_DEVICE", "android-test-plugin-host-coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidTestCoverageConfigProto.AndroidTestCoverageConfig.TestCoveragePathOnDeviceCase.values().length];
            nArray[AndroidTestCoverageConfigProto.AndroidTestCoverageConfig.TestCoveragePathOnDeviceCase.SINGLE_COVERAGE_FILE.ordinal()] = 1;
            nArray[AndroidTestCoverageConfigProto.AndroidTestCoverageConfig.TestCoveragePathOnDeviceCase.MULTIPLE_COVERAGE_FILES_IN_DIRECTORY.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

