/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.icebox;

import com.android.tools.utp.plugins.host.icebox.EmulatorGrpcInfo;
import com.android.tools.utp.plugins.host.icebox.GrpcInfoFinder;
import com.android.tools.utp.plugins.host.icebox.IceboxCaller;
import com.android.tools.utp.plugins.host.icebox.proto.IceboxOutputProto;
import com.android.tools.utp.plugins.host.icebox.proto.IceboxPluginProto;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.testing.platform.api.config.Config;
import com.google.testing.platform.api.config.ConfigExtKt;
import com.google.testing.platform.api.config.ProtoConfig;
import com.google.testing.platform.api.context.Context;
import com.google.testing.platform.api.device.DeviceController;
import com.google.testing.platform.api.plugin.HostPlugin;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestCaseProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B5\b\u0007\u0012\"\u0010\u0003\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\"H\u0016J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010-\u001a\u00020,2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u00100\u001a\u00020\"H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u00107\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0003\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxPlugin;", "Lcom/google/testing/platform/api/plugin/HostPlugin;", "()V", "iceboxCallerFactory", "Lkotlin/Function3;", "Lio/grpc/ManagedChannelBuilder;", "", "Lkotlinx/coroutines/CoroutineScope;", "Lcom/android/tools/utp/plugins/host/icebox/IceboxCaller;", "grpcInfoFinder", "Lcom/android/tools/utp/plugins/host/icebox/GrpcInfoFinder;", "(Lkotlin/jvm/functions/Function3;Lcom/android/tools/utp/plugins/host/icebox/GrpcInfoFinder;)V", "androidStudioDdmlibPort", "", "deviceController", "Lcom/google/testing/platform/api/device/DeviceController;", "failureSnapshotId", "iceboxCaller", "iceboxPluginConfig", "Lcom/android/tools/utp/plugins/host/icebox/proto/IceboxPluginProto$IceboxPlugin;", "getIceboxPluginConfig$annotations", "getIceboxPluginConfig", "()Lcom/android/tools/utp/plugins/host/icebox/proto/IceboxPluginProto$IceboxPlugin;", "setIceboxPluginConfig", "(Lcom/android/tools/utp/plugins/host/icebox/proto/IceboxPluginProto$IceboxPlugin;)V", "maxSnapshotNumber", "outputDir", "Ljava/io/File;", "getOutputDir$annotations", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "printedWarning", "", "remainSnapshotNumber", "afterAll", "Lcom/google/testing/platform/proto/api/core/TestSuiteResultProto$TestSuiteResult;", "testSuiteResult", "cancelled", "afterEach", "Lcom/google/testing/platform/proto/api/core/TestResultProto$TestResult;", "testResult", "beforeAll", "", "beforeEach", "testCase", "Lcom/google/testing/platform/proto/api/core/TestCaseProto$TestCase;", "canRun", "configure", "context", "Lcom/google/testing/platform/api/context/Context;", "getGrpcInfo", "Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "setupIcebox", "updateIceboxResult", "Companion", "android-test-plugin-host-retention"})
public final class IceboxPlugin
implements HostPlugin {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function3<ManagedChannelBuilder<?>, String, CoroutineScope, IceboxCaller> iceboxCallerFactory;
    @NotNull
    private final GrpcInfoFinder grpcInfoFinder;
    private IceboxCaller iceboxCaller;
    private DeviceController deviceController;
    private int androidStudioDdmlibPort;
    public IceboxPluginProto.IceboxPlugin iceboxPluginConfig;
    public File outputDir;
    private int maxSnapshotNumber;
    private int remainSnapshotNumber;
    private int failureSnapshotId;
    private boolean printedWarning;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger((Object)Companion);
    @Deprecated
    public static final int defaultAndroidStudioDdmlibPort = 8599;
    @Deprecated
    @NotNull
    public static final String snapshotNamePrefix = "failure";

    @VisibleForTesting
    public IceboxPlugin(@NotNull Function3<? super ManagedChannelBuilder<?>, ? super String, ? super CoroutineScope, ? extends IceboxCaller> iceboxCallerFactory, @NotNull GrpcInfoFinder grpcInfoFinder) {
        Intrinsics.checkNotNullParameter(iceboxCallerFactory, (String)"iceboxCallerFactory");
        Intrinsics.checkNotNullParameter((Object)grpcInfoFinder, (String)"grpcInfoFinder");
        this.iceboxCallerFactory = iceboxCallerFactory;
        this.grpcInfoFinder = grpcInfoFinder;
        this.androidStudioDdmlibPort = 8599;
    }

    public /* synthetic */ IceboxPlugin(Function3 function3, GrpcInfoFinder grpcInfoFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            grpcInfoFinder = new GrpcInfoFinder();
        }
        this(function3, grpcInfoFinder);
    }

    public IceboxPlugin() {
        this(1.INSTANCE, null, 2, null);
    }

    @NotNull
    public final IceboxPluginProto.IceboxPlugin getIceboxPluginConfig() {
        IceboxPluginProto.IceboxPlugin iceboxPlugin = this.iceboxPluginConfig;
        if (iceboxPlugin != null) {
            return iceboxPlugin;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"iceboxPluginConfig");
        return null;
    }

    public final void setIceboxPluginConfig(@NotNull IceboxPluginProto.IceboxPlugin iceboxPlugin) {
        Intrinsics.checkNotNullParameter((Object)iceboxPlugin, (String)"<set-?>");
        this.iceboxPluginConfig = iceboxPlugin;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIceboxPluginConfig$annotations() {
    }

    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        return null;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @VisibleForTesting
    public static /* synthetic */ void getOutputDir$annotations() {
    }

    public void configure(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.get("config");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.testing.platform.api.config.ProtoConfig");
        ProtoConfig config = (ProtoConfig)object;
        Any any = config.getConfigProto();
        Intrinsics.checkNotNull((Object)any);
        IceboxPluginProto.IceboxPlugin iceboxPlugin = IceboxPluginProto.IceboxPlugin.parseFrom((ByteString)any.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)iceboxPlugin, (String)"parseFrom(config.configProto!!.value)");
        this.setIceboxPluginConfig(iceboxPlugin);
        this.androidStudioDdmlibPort = this.getIceboxPluginConfig().getAndroidStudioDdmlibPort();
        if (this.androidStudioDdmlibPort == 0) {
            this.androidStudioDdmlibPort = 8599;
        }
        this.maxSnapshotNumber = this.getIceboxPluginConfig().getSkipSnapshot() ? 0 : (this.getIceboxPluginConfig().getMaxSnapshotNumber() <= 0 ? Integer.MAX_VALUE : this.getIceboxPluginConfig().getMaxSnapshotNumber());
        this.remainSnapshotNumber = this.maxSnapshotNumber;
        this.setOutputDir(new File(ConfigExtKt.getEnvironment((Config)((Config)config)).getOutputDirectory()));
    }

    public final void setupIcebox(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.deviceController = deviceController;
        EmulatorGrpcInfo grpcInfo = this.getGrpcInfo();
        this.printedWarning = false;
        ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forAddress((String)this.getIceboxPluginConfig().getEmulatorGrpcAddress(), (int)grpcInfo.getPort()).usePlaintext();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannelBuilder, (String)"forAddress(\n            \u2026         ).usePlaintext()");
        String string = grpcInfo.getToken();
        if (string == null) {
            string = "";
        }
        this.iceboxCaller = (IceboxCaller)this.iceboxCallerFactory.invoke((Object)managedChannelBuilder, (Object)string, (Object)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())));
        this.failureSnapshotId = 0;
        IceboxCaller iceboxCaller = this.iceboxCaller;
        if (iceboxCaller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iceboxCaller");
            iceboxCaller = null;
        }
        String string2 = this.getIceboxPluginConfig().getAppPackage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"iceboxPluginConfig.appPackage");
        iceboxCaller.runIcebox(deviceController, string2, snapshotNamePrefix, this.remainSnapshotNumber, this.androidStudioDdmlibPort);
    }

    public void beforeAll(@NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        this.setupIcebox(deviceController);
    }

    public void beforeEach(@Nullable TestCaseProto.TestCase testCase, @NotNull DeviceController deviceController) {
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
    }

    @NotNull
    public TestResultProto.TestResult afterEach(@NotNull TestResultProto.TestResult testResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        TestResultProto.TestResult res = this.updateIceboxResult(testResult);
        if (this.getIceboxPluginConfig().getSetupStrategy() == IceboxPluginProto.IceboxSetupStrategy.RECONNECT_BETWEEN_TEST_CASES) {
            IceboxCaller iceboxCaller = this.iceboxCaller;
            if (iceboxCaller == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iceboxCaller");
                iceboxCaller = null;
            }
            iceboxCaller.shutdownGrpc();
            this.setupIcebox(deviceController);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TestResultProto.TestResult updateIceboxResult(TestResultProto.TestResult testResult) {
        String string;
        if (testResult.getTestStatus() != TestStatusProto.TestStatus.FAILED || this.remainSnapshotNumber <= 0) {
            if (testResult.getTestStatus() == TestStatusProto.TestStatus.FAILED && !this.printedWarning) {
                logger.warning("Number of failures exceeds maximum snapshot count. Only the first " + this.maxSnapshotNumber + " failure(s) will have retention snapshots.");
                this.printedWarning = true;
            }
            return testResult;
        }
        String testClass = testResult.getTestCase().getTestClass();
        String testMethod = testResult.getTestCase().getTestMethod();
        IceboxPluginProto.Compression compression = this.getIceboxPluginConfig().getSnapshotCompression();
        switch (compression == null ? -1 : WhenMappings.$EnumSwitchMapping$0[compression.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = ".tar.gz";
                break;
            }
            case 3: {
                string = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String ext = string;
        String emulatorSnapshotName = snapshotNamePrefix + this.failureSnapshotId;
        File snapshotFile = new File(this.getOutputDir().getAbsolutePath(), "snapshot-" + testClass + "-" + testMethod + "-" + emulatorSnapshotName + ext);
        IceboxCaller iceboxCaller = this.iceboxCaller;
        if (iceboxCaller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iceboxCaller");
            iceboxCaller = null;
        }
        IceboxPluginProto.Compression compression2 = this.getIceboxPluginConfig().getSnapshotCompression();
        Intrinsics.checkNotNullExpressionValue((Object)compression2, (String)"iceboxPluginConfig.snapshotCompression");
        iceboxCaller.fetchSnapshot(snapshotFile, compression2, emulatorSnapshotName);
        if (snapshotFile.exists()) {
            void $this$updateIceboxResult_u24lambda_u243_u24lambda_u242;
            TestArtifactProto.Artifact.Builder $this$updateIceboxResult_u24lambda_u243_u24lambda_u241;
            TestArtifactProto.Artifact.Builder builder;
            ++this.failureSnapshotId;
            --this.remainSnapshotNumber;
            IceboxOutputProto.IceboxOutput iceboxInfo = IceboxOutputProto.IceboxOutput.newBuilder().setAppPackage(this.getIceboxPluginConfig().getAppPackage()).build();
            File iceboxInfoFile = new File(this.getOutputDir(), "icebox-info-" + testClass + "-" + testMethod + "-" + emulatorSnapshotName + ".pb");
            Closeable closeable = new FileOutputStream(iceboxInfoFile);
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl = false;
                iceboxInfo.writeTo((OutputStream)it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Throwable $this$updateIceboxResult_u24lambda_u243 = throwable = testResult.toBuilder();
            boolean bl = false;
            TestArtifactProto.Artifact.Builder builder2 = builder = TestArtifactProto.Artifact.newBuilder();
            Throwable throwable2 = $this$updateIceboxResult_u24lambda_u243;
            boolean bl2 = false;
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u241.getLabelBuilder().setLabel("icebox.info");
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u241.getLabelBuilder().setNamespace("android");
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u241.getSourcePathBuilder().setPath(iceboxInfoFile.getPath());
            throwable2.addOutputArtifact(builder);
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u241 = builder = TestArtifactProto.Artifact.newBuilder();
            throwable2 = $this$updateIceboxResult_u24lambda_u243;
            boolean bl3 = false;
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u242.getLabelBuilder().setLabel("icebox.snapshot");
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u242.getLabelBuilder().setNamespace("android");
            $this$updateIceboxResult_u24lambda_u243_u24lambda_u242.getSourcePathBuilder().setPath(snapshotFile.getPath());
            throwable2.addOutputArtifact(builder);
            TestResultProto.TestResult testResult2 = throwable.build();
            Intrinsics.checkNotNullExpressionValue((Object)testResult2, (String)"testResult.toBuilder().a\u2026  )\n            }.build()");
            return testResult2;
        }
        return testResult;
    }

    @NotNull
    public TestSuiteResultProto.TestSuiteResult afterAll(@NotNull TestSuiteResultProto.TestSuiteResult testSuiteResult, @NotNull DeviceController deviceController, boolean cancelled) {
        Intrinsics.checkNotNullParameter((Object)testSuiteResult, (String)"testSuiteResult");
        Intrinsics.checkNotNullParameter((Object)deviceController, (String)"deviceController");
        IceboxCaller iceboxCaller = this.iceboxCaller;
        if (iceboxCaller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"iceboxCaller");
            iceboxCaller = null;
        }
        iceboxCaller.shutdownGrpc();
        return testSuiteResult;
    }

    public boolean canRun() {
        return true;
    }

    private final EmulatorGrpcInfo getGrpcInfo() {
        if (this.getIceboxPluginConfig().getEmulatorGrpcPort() != 0) {
            return new EmulatorGrpcInfo(this.getIceboxPluginConfig().getEmulatorGrpcPort(), this.getIceboxPluginConfig().getEmulatorGrpcToken(), "", "", "");
        }
        DeviceController deviceController = this.deviceController;
        if (deviceController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"deviceController");
            deviceController = null;
        }
        return this.grpcInfoFinder.findInfo(deviceController.getDevice().getSerial());
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/IceboxPlugin$Companion;", "", "()V", "defaultAndroidStudioDdmlibPort", "", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "getLogger", "()Ljava/util/logging/Logger;", "snapshotNamePrefix", "", "android-test-plugin-host-retention"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IceboxPluginProto.Compression.values().length];
            try {
                nArray[IceboxPluginProto.Compression.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IceboxPluginProto.Compression.TARGZ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IceboxPluginProto.Compression.UNRECOGNIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

