/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.icebox;

import com.android.tools.utp.plugins.host.icebox.EmulatorGrpcInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\fH\u0000\u001a\n\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002\"\u001c\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"DEFAULT_EMULATOR_GRPC_INFO", "Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "getDEFAULT_EMULATOR_GRPC_INFO$annotations", "()V", "getDEFAULT_EMULATOR_GRPC_INFO", "()Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "DEFAULT_EMULATOR_GRPC_PORT", "", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "computeRegistrationDirectoryContainer", "Ljava/nio/file/Path;", "findGrpcInfo", "deviceSerial", "file", "getUid", "android-test-plugin-host-retention"})
@SourceDebugExtension(value={"SMAP\nIceboxConfigUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceboxConfigUtils.kt\ncom/android/tools/utp/plugins/host/icebox/IceboxConfigUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1849#2,2:176\n*S KotlinDebug\n*F\n+ 1 IceboxConfigUtils.kt\ncom/android/tools/utp/plugins/host/icebox/IceboxConfigUtilsKt\n*L\n153#1:176,2\n*E\n"})
public final class IceboxConfigUtilsKt {
    @NotNull
    public static final String DEFAULT_EMULATOR_GRPC_PORT = "8554";
    private static final Logger LOG = Logger.getLogger("IceboxConfigUtils");
    @NotNull
    private static final EmulatorGrpcInfo DEFAULT_EMULATOR_GRPC_INFO = new EmulatorGrpcInfo(Integer.parseInt("8554"), "", "", "", "");

    @NotNull
    public static final EmulatorGrpcInfo getDEFAULT_EMULATOR_GRPC_INFO() {
        return DEFAULT_EMULATOR_GRPC_INFO;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_EMULATOR_GRPC_INFO$annotations() {
    }

    private static final Path computeRegistrationDirectoryContainer() {
        String[] stringArray = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getProperty(\"os.name\")");
        String[] stringArray2 = stringArray;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string = stringArray2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        String os = string;
        if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            String string2 = System.getenv("HOME");
            if (string2 == null) {
                string2 = "/";
            }
            stringArray2 = new String[]{"Library", "Caches", "TemporaryItems"};
            return Paths.get(string2, stringArray2);
        }
        if (StringsKt.startsWith$default((String)os, (String)"win", (boolean)false, (int)2, null)) {
            String string3 = System.getenv("LOCALAPPDATA");
            if (string3 == null) {
                string3 = "/";
            }
            stringArray2 = new String[]{"Temp"};
            return Paths.get(string3, stringArray2);
        }
        String[] stringArray3 = new String[6];
        stringArray3[0] = System.getenv("XDG_RUNTIME_DIR");
        stringArray3[1] = "/run/user/" + IceboxConfigUtilsKt.getUid();
        stringArray3[2] = System.getenv("ANDROID_EMULATOR_HOME");
        stringArray3[3] = System.getenv("ANDROID_PREFS_ROOT");
        stringArray3[4] = System.getenv("ANDROID_SDK_HOME");
        String string4 = System.getenv("HOME");
        if (string4 == null) {
            string4 = "/";
        }
        stringArray3[5] = string4 + ".android";
        for (String dirstr : stringArray3) {
            if (dirstr == null) continue;
            try {
                Path dir = Paths.get(dirstr, new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                return dir;
            }
            catch (InvalidPathException exception) {
                LOG.finer("Failed to parse dir " + dirstr + ", exception " + exception);
            }
        }
        stringArray2 = new String[]{"android-" + System.getProperty("USER")};
        return Paths.get(FileUtils.getTempDirectory().getAbsolutePath(), stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getUid() {
        try {
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            Process process = Runtime.getRuntime().exec(command);
            Closeable closeable = process.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String result = ((Object)StringsKt.trim((CharSequence)new String(byArray, charset2))).toString();
                if (((CharSequence)result).length() == 0) {
                    String string = null;
                    return string;
                }
                String string = result;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static final EmulatorGrpcInfo findGrpcInfo(@NotNull String deviceSerial, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map discovered = null;
        discovered = new LinkedHashMap();
        List<String> list = Files.readAllLines(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(file)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            String[] stringArray = new String[]{"="};
            List keyValuePair = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            if (keyValuePair.size() != 2) continue;
            discovered.put(keyValuePair.get(0), keyValuePair.get(1));
        }
        String serial = discovered.getOrDefault("port.serial", "");
        boolean matchedAvd = Intrinsics.areEqual((Object)("emulator-" + serial), (Object)deviceSerial);
        if (matchedAvd) {
            return new EmulatorGrpcInfo(Integer.parseInt(discovered.getOrDefault("grpc.port", DEFAULT_EMULATOR_GRPC_PORT)), discovered.getOrDefault("grpc.token", ""), discovered.getOrDefault("grpc.server_cert", ""), discovered.getOrDefault("grpc.jwks", ""), discovered.getOrDefault("grpc.jwk_active", ""));
        }
        return null;
    }

    public static final /* synthetic */ Path access$computeRegistrationDirectoryContainer() {
        return IceboxConfigUtilsKt.computeRegistrationDirectoryContainer();
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

