/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp.plugins.host.icebox;

import com.android.tools.utp.plugins.host.icebox.EmulatorGrpcInfo;
import com.android.tools.utp.plugins.host.icebox.IceboxConfigUtilsKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/utp/plugins/host/icebox/GrpcInfoFinder;", "", "()V", "findInfo", "Lcom/android/tools/utp/plugins/host/icebox/EmulatorGrpcInfo;", "deviceSerial", "", "android-test-plugin-host-retention"})
public final class GrpcInfoFinder {
    @NotNull
    public final EmulatorGrpcInfo findInfo(@NotNull String deviceSerial) {
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        try {
            Pattern fileNamePattern = Pattern.compile("pid_\\d+.ini");
            Path path = IceboxConfigUtilsKt.access$computeRegistrationDirectoryContainer();
            Path directory = path != null ? path.resolve("avd/running") : null;
            Iterator iterator = Files.list(directory).iterator();
            while (iterator.hasNext()) {
                Path file = (Path)iterator.next();
                if (!fileNamePattern.matcher(((Object)file.getFileName()).toString()).matches()) continue;
                Intrinsics.checkNotNull((Object)file);
                EmulatorGrpcInfo emulatorGrpcInfo = IceboxConfigUtilsKt.findGrpcInfo(deviceSerial, file);
                if (emulatorGrpcInfo == null) continue;
                EmulatorGrpcInfo potentialGrpc = emulatorGrpcInfo;
                return potentialGrpc;
            }
            return IceboxConfigUtilsKt.getDEFAULT_EMULATOR_GRPC_INFO();
        }
        catch (Throwable exception) {
            IceboxConfigUtilsKt.access$getLOG$p().fine("Failed to parse emulator gRPC port, fallback to default, exception " + exception);
            return IceboxConfigUtilsKt.getDEFAULT_EMULATOR_GRPC_INFO();
        }
    }
}

