/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.NoCopyByteArrayOutputStream;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamSource
extends Source {
    private ByteBuffer buffer;
    private final InputStream inputStream;
    private final int compressionLevel;

    public InputStreamSource(InputStream inputStream, String name, int compressionLevel) {
        super(name);
        this.inputStream = inputStream;
        this.compressionLevel = compressionLevel;
    }

    @Override
    void prepare() throws IOException {
        int bytesRead;
        NoCopyByteArrayOutputStream ncbos = new NoCopyByteArrayOutputStream(16000);
        byte[] tmpBuffer = new byte[16000];
        while ((bytesRead = this.inputStream.read(tmpBuffer)) != -1) {
            ncbos.write(tmpBuffer, 0, bytesRead);
        }
        this.inputStream.close();
        this.uncompressedSize = ncbos.getCount();
        this.crc = Crc32.crc32(ncbos.buf(), 0, ncbos.getCount());
        if (this.compressionLevel == 0) {
            this.buffer = ncbos.getByteBuffer();
            this.compressedSize = this.uncompressedSize;
            this.compressionFlag = 0;
        } else {
            this.buffer = Compressor.deflate(ncbos.buf(), 0, ncbos.getCount(), this.compressionLevel);
            this.compressedSize = this.buffer.limit();
            this.compressionFlag = (short)8;
        }
    }

    @Override
    long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.buffer);
    }
}

