/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.CentralDirectory;
import com.android.zipflinger.EndOfCentralDirectory;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Ints;
import com.android.zipflinger.Location;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;

class ZipMap {
    private static final int EOCD_MIN_SIZE = 22;
    private static final long EOCD_MAX_SIZE = 65557L;
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private CentralDirectory cd = null;
    private final boolean accountDataDescriptors;
    private File file;
    private long fileSize;

    private ZipMap(File file, boolean accountDataDescriptors) {
        this.file = file;
        this.accountDataDescriptors = accountDataDescriptors;
    }

    static ZipMap from(File zipFile, boolean accountDataDescriptors) throws IOException {
        ZipMap map = new ZipMap(zipFile, accountDataDescriptors);
        map.parse();
        return map;
    }

    private void parse() throws IOException {
        try (FileChannel channel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);){
            this.fileSize = channel.size();
            int sizeToRead = Math.toIntExact(Math.min(this.fileSize, 65557L));
            ByteBuffer buffer = ByteBuffer.allocate(sizeToRead).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(buffer, this.fileSize - (long)sizeToRead);
            Location cdLocation = ZipMap.getCDLocation(buffer);
            if (cdLocation == Location.INVALID) {
                throw new IllegalStateException(String.format("Could not find CD in '%s'", this.file.toString()));
            }
            this.parseCentralDirectory(channel, cdLocation);
        }
    }

    private void parseCentralDirectory(FileChannel channel, Location location) throws IOException {
        int size = Math.toIntExact(location.size());
        ByteBuffer buf = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buf, location.first);
        buf.rewind();
        while (buf.remaining() >= 4 && buf.getInt() == 33639248) {
            Entry entry = new Entry();
            this.parseCentralDirectoryRecord(buf, channel, entry);
            if (entry.getName().isEmpty()) continue;
            this.entries.put(entry.getName(), entry);
        }
        this.cd = new CentralDirectory(buf, this.entries);
        this.sanityCheck(location);
    }

    private void sanityCheck(Location cdLocation) {
        for (Entry e : this.entries.values()) {
            Location loc = e.getLocation();
            if (loc.first < 0L) {
                throw new IllegalStateException("Invalid first loc '" + e.getName() + "' " + loc);
            }
            if (loc.last >= this.fileSize) {
                throw new IllegalStateException(this.fileSize + "Invalid last loc '" + e.getName() + "' " + loc);
            }
            Location cdLoc = e.getCdLocation();
            if (cdLoc.first < 0L) {
                throw new IllegalStateException("Invalid first cdloc '" + e.getName() + "' " + cdLoc);
            }
            long cdSize = cdLocation.size();
            if (cdLoc.last < cdSize) continue;
            throw new IllegalStateException(cdSize + "Invalid last loc '" + e.getName() + "' " + cdLoc);
        }
    }

    private static Location getCDLocation(ByteBuffer buffer) {
        Location eocdLocation = null;
        buffer.position(buffer.position() - 22);
        while (true) {
            int signature;
            if ((signature = buffer.getInt()) == 101010256) {
                eocdLocation = new Location(buffer.position() - 4, 22L);
                break;
            }
            if (buffer.position() == 4) break;
            buffer.position(buffer.position() - 4 - 1);
        }
        if (eocdLocation == null) {
            throw new IllegalStateException("Unable to find EOCD signature");
        }
        return EndOfCentralDirectory.parse(buffer, eocdLocation);
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    CentralDirectory getCentralDirectory() {
        return this.cd;
    }

    public void parseCentralDirectoryRecord(ByteBuffer buf, FileChannel channel, Entry entry) throws IOException {
        boolean hasDataDescriptor;
        long cdEntryStart = buf.position() - 4;
        buf.position(buf.position() + 4);
        short flags = buf.getShort();
        short compressionFlag = buf.getShort();
        entry.setCompressionFlag(compressionFlag);
        buf.position(buf.position() + 4);
        int crc = buf.getInt();
        entry.setCrc(crc);
        long compressedSize = Ints.uintToLong(buf.getInt());
        entry.setCompressedSize(compressedSize);
        long uncompressedSize = Ints.uintToLong(buf.getInt());
        entry.setUncompressedSize(uncompressedSize);
        int pathLength = Ints.ushortToInt(buf.getShort());
        int extraLength = Ints.ushortToInt(buf.getShort());
        int commentLength = Ints.ushortToInt(buf.getShort());
        buf.position(buf.position() + 8);
        long start = buf.getInt();
        ZipMap.parseName(buf, pathLength, entry);
        ByteBuffer localFieldBuffer = this.readLocalFields(start + 26L, entry, channel);
        int localPathLength = Ints.ushortToInt(localFieldBuffer.getShort());
        int localExtraLength = Ints.ushortToInt(localFieldBuffer.getShort());
        if (pathLength != localPathLength) {
            String message = String.format("Entry '%s' name differ (%d vs %d)", entry.getName(), localPathLength, pathLength);
            throw new IllegalStateException(message);
        }
        ZipMap.parseExtra(buf, extraLength);
        buf.position(buf.position() + commentLength);
        boolean isCompressed = compressionFlag != 0;
        long payloadSize = isCompressed ? compressedSize : uncompressedSize;
        long end = start + 30L + (long)pathLength + (long)localExtraLength + payloadSize;
        entry.setLocation(new Location(start, end - start));
        Location payloadLocation = new Location(start + 30L + (long)pathLength + (long)localExtraLength, payloadSize);
        entry.setPayloadLocation(payloadLocation);
        long cdEntrySize = 46 + pathLength + extraLength + commentLength;
        entry.setCdLocation(new Location(cdEntryStart, cdEntrySize));
        boolean bl = hasDataDescriptor = (flags & 8) == 8;
        if (hasDataDescriptor) {
            if (this.accountDataDescriptors) {
                channel.position(end);
                ZipMap.parseDataDescriptor(channel, entry);
            } else {
                entry.setLocation(Location.INVALID);
            }
        }
    }

    private ByteBuffer readLocalFields(long offset, Entry entry, FileChannel channel) throws IOException {
        ByteBuffer localFieldsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        if (offset < 0L || offset + 4L > this.fileSize) {
            throw new IllegalStateException("Entry :" + entry.getName() + " invalid offset (" + offset + ")");
        }
        channel.read(localFieldsBuffer, offset);
        localFieldsBuffer.rewind();
        return localFieldsBuffer;
    }

    private static void parseName(ByteBuffer buf, int length, Entry entry) {
        byte[] pathBytes = new byte[length];
        buf.get(pathBytes);
        entry.setNameBytes(pathBytes);
    }

    private static void parseDataDescriptor(FileChannel channel, Entry entry) throws IOException {
        ByteBuffer dataDescriptorBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(dataDescriptorBuffer);
        dataDescriptorBuffer.rewind();
        int dataDescriptorLength = 12;
        if (dataDescriptorBuffer.getInt() == 134695760) {
            dataDescriptorLength += 4;
        }
        Location adjustedLocation = new Location(entry.getLocation().first, entry.getLocation().size() + (long)dataDescriptorLength);
        entry.setLocation(adjustedLocation);
    }

    private static void parseExtra(ByteBuffer buf, int length) {
        while (length >= 4) {
            buf.getShort();
            int size = Ints.ushortToInt(buf.getShort());
            if (buf.remaining() < size) {
                throw new IllegalStateException("Invalid zip entry, extra size > remaining data");
            }
            buf.position(buf.position() + size);
            length -= size + 2 + 2;
        }
    }

    public File getFile() {
        return this.file;
    }
}

