/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Ints;
import com.android.zipflinger.Location;
import java.nio.ByteBuffer;

class CentralDirectoryRecord {
    public static final int SIGNATURE = 33639248;
    public static final int SIZE = 46;
    public static final int DATA_DESCRIPTOR_FLAG = 8;
    public static final int DATA_DESCRIPTOR_SIGNATURE = 134695760;
    public static final int EXTRA_ID_FIELD_SIZE = 2;
    public static final int EXTRA_SIZE_FIELD_SIZE = 2;
    public static final short DEFAULT_VERSION_MADE_BY = 798;
    private final byte[] nameBytes;
    private final int crc;
    private final long compressedSize;
    private final long uncompressedSize;
    private final Location location;
    private final short compressionFlag;
    private final Location payloadLocation;

    CentralDirectoryRecord(byte[] nameBytes, int crc, long compressedSize, long uncompressedSize, Location location, short compressionFlag, Location payloadLocation) {
        this.nameBytes = nameBytes;
        this.crc = crc;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.location = location;
        this.compressionFlag = compressionFlag;
        this.payloadLocation = payloadLocation;
    }

    void write(ByteBuffer buf) {
        buf.putInt(33639248);
        buf.putShort((short)798);
        buf.putShort((short)20);
        buf.putShort((short)0);
        buf.putShort(this.compressionFlag);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putInt(this.crc);
        buf.putInt(Ints.longToUint(this.compressedSize));
        buf.putInt(Ints.longToUint(this.uncompressedSize));
        buf.putShort(Ints.intToUshort(this.nameBytes.length));
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putInt(0);
        buf.putInt(Ints.longToUint(this.location.first));
        buf.put(this.nameBytes);
    }

    int getCrc() {
        return this.crc;
    }

    long getCompressedSize() {
        return this.compressedSize;
    }

    long getUncompressedSize() {
        return this.uncompressedSize;
    }

    short getCompressionFlag() {
        return this.compressionFlag;
    }

    long getSize() {
        return 46 + this.nameBytes.length;
    }

    Location getPayloadLocation() {
        return this.payloadLocation;
    }

    Location getLocation() {
        return this.location;
    }
}

