/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipSource;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZipSourceEntryDeflater
extends Source {
    private final Location loc;
    private final ZipSource zipSource;
    private final int compressionLevel;
    private ByteBuffer compressedByteBuffer;

    public ZipSourceEntryDeflater(String newName, Entry entry, ZipSource zipSource, int compressionLevel) {
        super(newName);
        this.loc = entry.getPayloadLocation();
        this.zipSource = zipSource;
        this.compressionLevel = compressionLevel;
    }

    @Override
    void prepare() throws IOException {
        ByteBuffer uncompressedBytes = ByteBuffer.allocate(Math.toIntExact(this.loc.size()));
        this.zipSource.getChannel().read(uncompressedBytes, this.loc.first);
        this.compressedByteBuffer = Compressor.deflate(uncompressedBytes.array(), this.compressionLevel);
        this.crc = Crc32.crc32(uncompressedBytes.array());
        this.compressedSize = this.compressedByteBuffer.limit();
        this.uncompressedSize = uncompressedBytes.limit();
        this.compressionFlag = (short)8;
    }

    @Override
    long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.compressedByteBuffer);
    }
}

