/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

class ZipWriter
implements Closeable,
WritableByteChannel {
    private final FileChannel channel;

    public ZipWriter(FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void truncate(long size) throws IOException {
        this.channel.truncate(size);
    }

    public void position(long position) throws IOException {
        this.channel.position(position);
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        return this.channel.write(buffer, position);
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        return this.channel.write(buffer);
    }

    public void transferFrom(FileChannel src, long position, long count) throws IOException {
        for (long copied = 0L; copied != count; copied += src.transferTo(position + copied, count - copied, this.channel)) {
        }
    }
}

