/*
 * Decompiled with CFR 0.152.
 */
package com.annimon.stream;

import com.annimon.stream.DoubleStream;
import com.annimon.stream.Objects;
import com.annimon.stream.Optional;
import com.annimon.stream.OptionalInt;
import com.annimon.stream.OptionalLong;
import com.annimon.stream.function.DoubleConsumer;
import com.annimon.stream.function.DoubleFunction;
import com.annimon.stream.function.DoublePredicate;
import com.annimon.stream.function.DoubleSupplier;
import com.annimon.stream.function.DoubleToIntFunction;
import com.annimon.stream.function.DoubleToLongFunction;
import com.annimon.stream.function.DoubleUnaryOperator;
import com.annimon.stream.function.Function;
import com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY = new OptionalDouble();
    private final boolean isPresent;
    private final double value;

    public static OptionalDouble empty() {
        return EMPTY;
    }

    public static OptionalDouble of(double value) {
        return new OptionalDouble(value);
    }

    public static OptionalDouble ofNullable(Double value) {
        return value == null ? EMPTY : new OptionalDouble(value);
    }

    private OptionalDouble() {
        this.isPresent = false;
        this.value = 0.0;
    }

    private OptionalDouble(double value) {
        this.isPresent = true;
        this.value = value;
    }

    public double getAsDouble() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(DoubleConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(DoubleConsumer consumer, Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalDouble executeIfPresent(DoubleConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    public OptionalDouble executeIfAbsent(Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    public <R> R custom(Function<OptionalDouble, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public OptionalDouble filter(DoublePredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalDouble.empty();
    }

    public OptionalDouble filterNot(DoublePredicate predicate) {
        return this.filter(DoublePredicate.Util.negate(predicate));
    }

    public OptionalDouble map(DoubleUnaryOperator mapper) {
        if (!this.isPresent()) {
            return OptionalDouble.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalDouble.of(mapper.applyAsDouble(this.value));
    }

    public <U> Optional<U> mapToObj(DoubleFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public OptionalInt mapToInt(DoubleToIntFunction mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    public OptionalLong mapToLong(DoubleToLongFunction mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        Objects.requireNonNull(mapper);
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    public DoubleStream stream() {
        if (!this.isPresent()) {
            return DoubleStream.empty();
        }
        return DoubleStream.of(this.value);
    }

    public OptionalDouble or(Supplier<OptionalDouble> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public double orElse(double other) {
        return this.isPresent ? this.value : other;
    }

    public double orElseGet(DoubleSupplier other) {
        return this.isPresent ? this.value : other.getAsDouble();
    }

    public double orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> double orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalDouble)) {
            return false;
        }
        OptionalDouble other = (OptionalDouble)obj;
        return this.isPresent && other.isPresent ? Double.compare(this.value, other.value) == 0 : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? Objects.hashCode(this.value) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalDouble[%s]", this.value) : "OptionalDouble.empty";
    }
}

