/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class InverseContextBuilder {
    private final ActiveContext activeContext;

    private InverseContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static final InverseContextBuilder with(ActiveContext activeContext) {
        return new InverseContextBuilder(activeContext);
    }

    public InverseContext build() {
        InverseContext result = new InverseContext();
        String defaultLanguage = this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage().toLowerCase() : "@none";
        for (String termName : this.activeContext.getTerms().stream().sorted().collect(Collectors.toList())) {
            String langDir;
            Optional<String> variable;
            if (this.activeContext.getTerm(termName).isEmpty() || (variable = this.activeContext.getTerm(termName).map(TermDefinition::getUriMapping)).isEmpty()) continue;
            String variableValue = variable.get();
            Optional<Collection> containerMapping = this.activeContext.getTerm(termName).map(TermDefinition::getContainerMapping);
            String container = ((Collection)containerMapping.filter(Predicate.not(Collection::isEmpty)).orElse(Arrays.asList("@none"))).stream().sorted().collect(Collectors.joining());
            result.setIfAbsent(variableValue, container, "@any", "@none", termName);
            Optional<JsonValue> languageMapping = this.activeContext.getTerm(termName).map(TermDefinition::getLanguageMapping);
            Optional<DirectionType> directionMapping = this.activeContext.getTerm(termName).map(TermDefinition::getDirectionMapping);
            if (this.activeContext.getTerm(termName).map(TermDefinition::isReverseProperty).orElse(false).booleanValue()) {
                result.setIfAbsent(variableValue, container, "@type", "@reverse", termName);
                continue;
            }
            Optional<String> typeMapping = this.activeContext.getTerm(termName).map(TermDefinition::getTypeMapping);
            if (typeMapping.filter("@none"::equals).isPresent()) {
                result.setIfAbsent(variableValue, container, "@language", "@any", termName);
                result.setIfAbsent(variableValue, container, "@type", "@any", termName);
                continue;
            }
            if (typeMapping.isPresent()) {
                result.setIfAbsent(variableValue, container, "@type", typeMapping.get(), termName);
                continue;
            }
            if (languageMapping.isPresent() && directionMapping.isPresent()) {
                langDir = languageMapping.filter(JsonUtils::isString).isPresent() && directionMapping.get() != DirectionType.NULL ? languageMapping.map(JsonString.class::cast).map(JsonString::getString).orElse("").concat("_").concat(directionMapping.get().name()).toLowerCase() : (languageMapping.filter(JsonUtils::isString).isPresent() ? ((JsonString)languageMapping.get()).getString().toLowerCase() : (directionMapping.get() != DirectionType.NULL ? "_".concat(directionMapping.get().name().toLowerCase()) : "@null"));
                result.setIfAbsent(variableValue, container, "@language", langDir, termName);
                continue;
            }
            if (languageMapping.isPresent()) {
                String language = JsonUtils.isString(languageMapping.get()) ? ((JsonString)languageMapping.get()).getString().toLowerCase() : "@null";
                result.setIfAbsent(variableValue, container, "@language", language, termName);
                continue;
            }
            if (directionMapping.isPresent()) {
                String direction = directionMapping.get() != DirectionType.NULL ? "_".concat(directionMapping.get().name().toLowerCase()) : "@none";
                result.setIfAbsent(variableValue, container, "@language", direction, termName);
                continue;
            }
            if (this.activeContext.getDefaultBaseDirection() != null) {
                langDir = (this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage() : "").concat("_").concat(this.activeContext.getDefaultBaseDirection().name()).toLowerCase();
                result.setIfAbsent(variableValue, container, "@language", langDir, termName);
                result.setIfAbsent(variableValue, container, "@language", "@none", termName);
                result.setIfAbsent(variableValue, container, "@type", "@none", termName);
                continue;
            }
            result.setIfAbsent(variableValue, container, "@language", defaultLanguage, termName);
            result.setIfAbsent(variableValue, container, "@language", "@none", termName);
            result.setIfAbsent(variableValue, container, "@type", "@none", termName);
        }
        return result;
    }
}

