/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ContextClassLoaderThreadFactory
implements ThreadFactory {
    private final ClassLoader contextClassLoader;

    public ContextClassLoaderThreadFactory(ClassLoader contextClassLoader) {
        this.contextClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)contextClassLoader);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setContextClassLoader(this.contextClassLoader);
        return thread;
    }

    @VisibleForTesting
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }
}

