/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.spi;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import java.util.Objects;
import javax.sql.DataSource;

public class DataSourceProviderImpl
implements DataSourceProvider {
    private final TenantAwareDataSourceProvider tenantAwareDataSourceProvider;
    private final TenantContext tenantContext;

    public DataSourceProviderImpl(TenantAwareDataSourceProvider tenantAwareDataSourceProvider, TenantContext tenantContext) {
        this.tenantAwareDataSourceProvider = Objects.requireNonNull(tenantAwareDataSourceProvider);
        this.tenantContext = Objects.requireNonNull(tenantContext);
    }

    @Override
    public DataSource getDataSource() {
        Tenant tenant = this.tenantContext.getCurrentTenant();
        if (tenant == null) {
            throw new IllegalStateException("tenant / dataSource unavailable");
        }
        return this.tenantAwareDataSourceProvider.getDataSource(tenant);
    }

    @Override
    public DatabaseType getDatabaseType() {
        Tenant tenant = this.tenantContext.getCurrentTenant();
        if (tenant == null) {
            throw new IllegalStateException("tenant / databaseType unavailable");
        }
        return this.tenantAwareDataSourceProvider.getDatabaseType(tenant);
    }

    @Override
    public String getSchema() {
        Tenant tenant = this.tenantContext.getCurrentTenant();
        if (tenant == null) {
            throw new IllegalStateException("tenant / schema unavailable");
        }
        return this.tenantAwareDataSourceProvider.getSchema(tenant);
    }
}

