/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import java.util.Objects;
import java.util.Optional;

public final class VersionId {
    private final Optional<String> version;
    private final Optional<String> propertyName;

    public static VersionId version(String version) {
        return new VersionId(Optional.of(version), Optional.empty());
    }

    public static VersionId versionProperty(String propertyName, String defaultVersion) {
        return new VersionId(Optional.of(defaultVersion), Optional.of(propertyName));
    }

    public static VersionId noVersion() {
        return new VersionId(Optional.empty(), Optional.empty());
    }

    private VersionId(Optional<String> version, Optional<String> propertyName) {
        this.version = Objects.requireNonNull(version, "version");
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public Optional<String> getPropertyName() {
        return this.propertyName;
    }

    public boolean isDefined() {
        return this.version.isPresent() || this.propertyName.isPresent();
    }

    public Optional<String> getVersionOrPropertyPlaceholder() {
        return this.propertyPlaceholder().isPresent() ? this.propertyPlaceholder() : this.version;
    }

    public String toString() {
        return this.propertyPlaceholder().map(placeholder -> placeholder + this.defaultValueSuffix()).orElse(this.version.orElse("?"));
    }

    private String defaultValueSuffix() {
        return this.version.map(v -> " (" + v + ")").orElse("");
    }

    private Optional<String> propertyPlaceholder() {
        return this.propertyName.map(property -> "${" + property + "}");
    }

    public boolean equals(Object other) {
        if (other instanceof VersionId) {
            VersionId v = (VersionId)other;
            return this.version.equals(v.version) && this.propertyName.equals(v.propertyName);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

