/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.confluence.blueprint;

import com.atlassian.plugins.codegen.ArtifactDependency;
import com.atlassian.plugins.codegen.ComponentDeclaration;
import com.atlassian.plugins.codegen.PluginProjectChange;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.annotations.ConfluencePluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.BasicClassModuleProperties;
import com.atlassian.plugins.codegen.modules.common.ContextProviderProperties;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.common.ResourcedProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebItemProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.ContentTemplateProperties;
import java.util.Map;

@ConfluencePluginModuleCreator
public class BlueprintModuleCreator
extends AbstractPluginModuleCreator<BlueprintProperties> {
    private static final String MODULE_NAME = "Blueprint";
    private static final String TEMPLATE_PREFIX = "templates/confluence/blueprint/";
    private static final String BLUEPRINT_MODULE_TEMPLATE = "templates/confluence/blueprint/plugin-module-blueprint.xml.vtl";
    private static final String CONTENT_TEMPLATE_MODULE_TEMPLATE = "templates/confluence/blueprint/plugin-module-content-template.xml.vtl";
    private static final String CONTENT_TEMPLATE_FILE_TEMPLATE = "templates/confluence/blueprint/resource-file-content-template.xml.vtl";
    private static final String INDEX_PAGE_CONTENT_TEMPLATE_FILE_TEMPLATE = "templates/confluence/blueprint/resource-file-index-page-content-template.xml.vtl";
    private static final String SOY_TEMPLATE_FILE_TEMPLATE = "templates/confluence/blueprint/resource-file-soy-template.soy.vtl";
    private static final String JS_TEMPLATE_FILE_TEMPLATE = "templates/confluence/blueprint/resource-file-dialog-wizard.js.vtl";
    private static final String CSS_TEMPLATE_FILE_TEMPLATE = "templates/confluence/blueprint/resource-file-blueprints.css.vtl";
    private static final String CONTEXT_PROVIDER_CLASS_TEMPLATE = "templates/confluence/blueprint/ContentTemplateContextProvider.jva.vtl";
    private static final String EVENT_LISTENER_CLASS_TEMPLATE = "templates/confluence/blueprint/BlueprintCreatedListener.jva.vtl";

    @Override
    public PluginProjectChangeset createModule(BlueprintProperties props) throws Exception {
        WebItemProperties webItem;
        PluginProjectChangeset changeset = new PluginProjectChangeset().with(this.createModule(props, BLUEPRINT_MODULE_TEMPLATE));
        ArtifactDependency createContent = ArtifactDependency.dependency((String)"com.atlassian.confluence.plugins", (String)"confluence-create-content-plugin", (String)"1.5.25", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED);
        ArtifactDependency plugins = ArtifactDependency.dependency((String)"com.atlassian.plugins", (String)"atlassian-plugins-core", (String)"2.13.4", (ArtifactDependency.Scope)ArtifactDependency.Scope.PROVIDED);
        changeset = changeset.with(new PluginProjectChange[]{createContent});
        changeset = changeset.with(new PluginProjectChange[]{plugins});
        for (ContentTemplateProperties contentTemplateProperties : props.getContentTemplates()) {
            changeset = changeset.with(this.createModule(contentTemplateProperties, CONTENT_TEMPLATE_MODULE_TEMPLATE));
            changeset = this.addResourceFiles(changeset, contentTemplateProperties, CONTENT_TEMPLATE_FILE_TEMPLATE);
            ContextProviderProperties contextProviderProperties = contentTemplateProperties.getContextProvider();
            if (contextProviderProperties == null) continue;
            changeset = changeset.with(this.createClass(contextProviderProperties, CONTEXT_PROVIDER_CLASS_TEMPLATE));
        }
        ContentTemplateProperties indexPageContentTemplate = props.getIndexPageContentTemplate();
        if (indexPageContentTemplate != null) {
            changeset = changeset.with(this.createModule(indexPageContentTemplate, CONTENT_TEMPLATE_MODULE_TEMPLATE));
            changeset = this.addResourceFiles(changeset, indexPageContentTemplate, INDEX_PAGE_CONTENT_TEMPLATE_FILE_TEMPLATE);
        }
        if ((webItem = props.getWebItem()) != null) {
            changeset = changeset.with(this.createModule(webItem, "templates/common/web/webitem/web-item-plugin.xml.vtl"));
        }
        WebResourceProperties webResource = props.getWebResource();
        changeset = changeset.with(this.createModule(webResource, "templates/common/web/webresource/web-resource-plugin.xml.vtl"));
        changeset = this.addResourceFiles(changeset, webResource, null);
        ComponentDeclaration eventListener = props.getEventListener();
        if (eventListener != null) {
            changeset = changeset.with(new PluginProjectChange[]{eventListener});
            BasicClassModuleProperties classProps = new BasicClassModuleProperties(eventListener.getClassId().getFullName());
            classProps.setProperty("PLUGIN_KEY", props.getPluginKey());
            changeset = changeset.with(this.createClass(classProps, EVENT_LISTENER_CLASS_TEMPLATE));
        }
        return changeset;
    }

    private PluginProjectChangeset addResourceFiles(PluginProjectChangeset changeset, ResourcedProperties properties, String givenTemplate) throws Exception {
        for (Resource resource : properties.getResources()) {
            String filePath = resource.getLocation();
            int lastSlash = filePath.lastIndexOf(47);
            String path = filePath.substring(0, lastSlash);
            String filename = filePath.substring(lastSlash + 1);
            String resourceFileTemplate = this.getResourceTemplate(givenTemplate, filename);
            changeset = changeset.with(this.createResource((Map<Object, Object>)((Object)properties), path, filename, resourceFileTemplate));
        }
        return changeset;
    }

    private String getResourceTemplate(String givenTemplate, String filename) {
        if (givenTemplate != null) {
            return givenTemplate;
        }
        if (filename.endsWith(".js")) {
            return JS_TEMPLATE_FILE_TEMPLATE;
        }
        if (filename.endsWith(".css")) {
            return CSS_TEMPLATE_FILE_TEMPLATE;
        }
        if (filename.endsWith(".soy")) {
            return SOY_TEMPLATE_FILE_TEMPLATE;
        }
        throw new UnsupportedOperationException("Can't render resource template for filename: " + filename);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

