/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.confluence.blueprint;

public class BlueprintStringer {
    private final String indexKey;
    private final String pluginKey;

    public BlueprintStringer(String indexKey, String pluginKey) {
        this.indexKey = indexKey;
        this.pluginKey = pluginKey;
    }

    public String makeBlueprintModuleKey() {
        return this.indexKey + "-blueprint";
    }

    public String makeContentTemplateKey(int templateIndex) {
        String key = this.indexKey + "-template";
        if (templateIndex > 0) {
            key = key + "-" + templateIndex;
        }
        return key;
    }

    public String makeBlueprintModuleName(String blueprintName) {
        return blueprintName + " Blueprint";
    }

    public String makeSoyTemplatePackage(String blueprintName) {
        return "Confluence.Blueprints.Plugin." + blueprintName.replaceAll("\\W", "");
    }

    public String makeContentTemplateName(String webItemName, int counter) {
        return webItemName + " Content Template " + counter;
    }

    public String makeI18nKey(String suffix) {
        return this.pluginKey + "." + suffix;
    }
}

